/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.http.HttpClient;

public class HttpClientPool {
    private Vector allConnections = new Vector(1);
    private Vector availableConnections = new Vector(1);

    public int getNumberOfAllConnections() {
        return this.allConnections.size();
    }

    public int getNumberOfAvailableConnections() {
        return this.availableConnections.size();
    }

    public HttpClient retrieveAvailableConnectionFromPool() {
        if (this.getNumberOfAvailableConnections() > 0) {
            return (HttpClient)this.availableConnections.remove(0);
        }
        return null;
    }

    public boolean returnAvailableConnectionToPool(HttpClient httpClient) {
        this.addConnectionToPool(httpClient);
        if (httpClient != null && !this.availableConnections.contains(httpClient)) {
            this.availableConnections.add(httpClient);
            return true;
        }
        return false;
    }

    public boolean addConnectionToPool(HttpClient httpClient) {
        if (httpClient != null && !this.allConnections.contains(httpClient)) {
            this.allConnections.add(httpClient);
            return true;
        }
        return false;
    }

    public boolean removeConnectionFromPool(HttpClient httpClient) {
        if (httpClient != null) {
            this.availableConnections.remove(httpClient);
            return this.allConnections.remove(httpClient);
        }
        return false;
    }

    public synchronized void closePool() {
        Iterator iter = this.allConnections.iterator();
        while (iter.hasNext()) {
            HttpClient httpClient = (HttpClient)iter.next();
            httpClient.disconnect();
        }
        this.allConnections.clear();
        this.availableConnections.clear();
    }

    protected void finalize() {
        this.closePool();
    }
}

