/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URI;
import java.security.Permission;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.AuthorizationHandler;
import org.sblim.wbem.http.HttpClient;
import org.sblim.wbem.http.HttpClientPool;
import org.sblim.wbem.util.GlobalProperties;

public class HttpUrlConnection
extends HttpURLConnection {
    private static final String CLASSNAME = "org.sblim.wbem.http.HttpUrlConnection";
    private InputStream inputStream;
    private boolean connected;
    public HttpClient httpClient;
    protected URI url;
    private HttpClientPool httpClientPool;
    AuthorizationHandler auth_handler;
    private Logger logger = null;

    public HttpUrlConnection(URI uri, HttpClientPool httpClientPool, AuthorizationHandler auth_handler) {
        super(null);
        this.url = uri;
        this.httpClientPool = httpClientPool;
        this.auth_handler = auth_handler;
        this.logger = GlobalProperties.getLogger();
    }

    public String toString() {
        return "HttpUrlConnection=[url=" + this.url + ",PoolSize=" + this.httpClientPool.getNumberOfAvailableConnections() + "," + this.auth_handler + "]";
    }

    public Permission getPermission() throws IOException {
        int port = this.url.getPort();
        port = port < 0 ? 80 : port;
        String host = this.url.getHost() + ":" + port;
        SocketPermission permission = new SocketPermission(host, "connect");
        return permission;
    }

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            this.getClient();
        }
        this.httpClient.connect();
    }

    private synchronized void getClient() {
        if (this.connected) {
            return;
        }
        this.httpClient = HttpClient.getClient(this.url, this.httpClientPool, this.auth_handler);
        this.httpClient.reset();
        this.connected = true;
    }

    public synchronized void setRequestMethod(String method) {
        if (!this.connected) {
            this.getClient();
        }
        this.httpClient.setRequestMethod(method);
        this.method = method;
    }

    public synchronized void setRequestProperty(String key, String value) {
        if (!this.connected) {
            this.getClient();
        }
        this.httpClient.setRequestProperty(key, value);
    }

    public synchronized void disconnect() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "disconnect()");
        }
        if (this.connected) {
            this.connected = false;
            this.httpClient.disconnect();
            if (this.httpClientPool != null) {
                this.httpClientPool.removeConnectionFromPool(this.httpClient);
                this.httpClient = null;
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, "disconnect()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(CLASSNAME, "close()");
        }
        this.disconnect();
        if (this.httpClientPool != null) {
            HttpClientPool httpClientPool = this.httpClientPool;
            synchronized (httpClientPool) {
                this.httpClientPool.closePool();
                this.httpClientPool = null;
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(CLASSNAME, "close()");
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (!this.connected) {
            this.getClient();
        }
        try {
            return this.httpClient.getInputStream();
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.getClient();
        }
        try {
            return this.httpClient.getOutputStream();
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    public boolean usingProxy() {
        return false;
    }

    public synchronized HttpClient getHttpClient() {
        if (!this.connected) {
            this.getClient();
        }
        return this.httpClient;
    }

    public synchronized String getHeaderField(String name) {
        if (!this.connected) {
            this.getClient();
        }
        return this.httpClient.getHeaderField(name);
    }

    public synchronized String getHeaderFieldKey(int index) {
        if (!this.connected) {
            this.getClient();
        }
        return this.httpClient.getHeaderFieldKey(index);
    }

    public synchronized String getHeaderField(int index) {
        if (!this.connected) {
            this.getClient();
        }
        return this.httpClient.getHeaderField(index);
    }

    public synchronized String getRequestProperty(String key) {
        if (!this.connected) {
            this.getClient();
        }
        return this.httpClient.getRequestProperty(key);
    }

    public synchronized String getRequestMethod() {
        if (!this.connected) {
            this.getClient();
        }
        return this.httpClient.getRequestMethod();
    }

    public synchronized void reset() {
        if (!this.connected) {
            this.getClient();
        }
        this.httpClient.reset();
    }

    public synchronized int getResponseCode() throws IOException {
        if (!this.connected) {
            this.getClient();
        }
        return this.httpClient.getResponseCode();
    }

    public synchronized String getResponseMessage() {
        if (!this.connected) {
            this.getClient();
        }
        return this.httpClient.getResponseMessage();
    }

    public synchronized void useHttp11(boolean bool) {
        if (!this.connected) {
            this.getClient();
        }
        this.httpClient.useHttp11(bool);
    }
}

