/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.HttpException;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpHeaderParser;
import org.sblim.wbem.http.HttpServerMethod;
import org.sblim.wbem.http.io.BoundedInputStream;
import org.sblim.wbem.http.io.ChunkedInputStream;
import org.sblim.wbem.http.io.PersistentInputStream;
import org.sblim.wbem.util.GlobalProperties;

public class MessageReader {
    HttpHeader header;
    HttpServerMethod method;
    private boolean chunked;
    private String encoding;
    InputStream content;

    public MessageReader(InputStream reader) throws IOException, HttpException {
        int contentLength;
        block8: {
            String contentType;
            String encoding;
            block7: {
                this.chunked = false;
                this.encoding = "UTF-8";
                this.method = new HttpServerMethod(reader);
                this.header = new HttpHeader(reader);
                encoding = this.header.getField("Transfer-Encoding");
                if (encoding != null && encoding.toLowerCase().endsWith("chunked")) {
                    this.chunked = true;
                }
                String length = this.header.getField("Content-Length");
                contentLength = -1;
                if (length != null) {
                    try {
                        contentLength = Integer.parseInt(length);
                    }
                    catch (Exception e) {
                        contentLength = -1;
                        Logger logger = GlobalProperties.getLogger();
                        if (!logger.isLoggable(Level.WARNING)) break block7;
                        logger.log(Level.WARNING, "invalid content length format from the response", e);
                    }
                }
            }
            if ((contentType = this.header.getField("Content-Type")) != null) {
                try {
                    HttpHeaderParser contentTypeHeader = new HttpHeaderParser(contentType);
                    encoding = contentTypeHeader.findValue("charset");
                }
                catch (Exception e) {
                    encoding = "UTF-8";
                    Logger logger = GlobalProperties.getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block8;
                    logger.log(Level.WARNING, "invalid content type format from the response", e);
                }
            }
        }
        this.content = this.chunked ? new ChunkedInputStream(new PersistentInputStream(reader, this.isPersistentConnectionSupported())) : new BoundedInputStream(new PersistentInputStream(reader, this.isPersistentConnectionSupported()), contentLength);
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public HttpHeader getHeader() {
        return this.header;
    }

    public HttpServerMethod getMethod() {
        return this.method;
    }

    public InputStream getInputStream() {
        return this.content;
    }

    public boolean isPersistentConnectionSupported() {
        String conn = this.header.getField("Connection");
        if (conn != null) {
            if (conn.equalsIgnoreCase("close")) {
                return false;
            }
            if (conn.equalsIgnoreCase("Keep-Alive")) {
                return true;
            }
        }
        return this.method.getMajorVersion() >= 1 && this.method.getMinorVersion() >= 1;
    }

    public boolean isChunkSupported() {
        String TE;
        return this.method.getMajorVersion() >= 1 && this.method.getMinorVersion() >= 1 && (TE = this.header.getField("TE")) != null && TE.equalsIgnoreCase("trailers");
    }

    public void close() throws IOException {
        this.content.close();
    }
}

