/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpMethod;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private int avail = 0;
    private long chunkSize = 0L;
    private boolean eof = false;
    private HttpHeader trailers = new HttpHeader();
    private boolean closed = false;
    private byte[] tmp = new byte[1];

    public ChunkedInputStream(InputStream is) {
        this.in = is;
    }

    public synchronized int read() throws IOException {
        return this.read(this.tmp, 0, 1) > 0 ? this.tmp[0] & 0xFF : -1;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int total = 0;
        if (this.eof || this.closed) {
            return -1;
        }
        if (this.chunkSize == 0L) {
            String line = HttpMethod.readLine(this.in);
            if ("".equals(line)) {
                line = HttpMethod.readLine(this.in);
            }
            try {
                this.chunkSize = Long.parseLong(line, 16);
            }
            catch (Exception e) {
                this.eof = true;
                throw new IOException("Invalid chunk size");
            }
        }
        if (this.chunkSize > 0L) {
            total = this.in.read(buf, off, this.chunkSize < (long)len ? (int)this.chunkSize : len);
            if (total > 0) {
                this.chunkSize -= (long)total;
            }
            if (total == -1) {
                throw new EOFException("Unexpected EOF");
            }
        } else {
            this.eof = true;
            this.trailers = new HttpHeader(this.in);
        }
        return total;
    }

    public synchronized HttpHeader getTrailers() {
        return this.trailers;
    }

    public synchronized long skip(long total) throws IOException {
        byte[] tmp = new byte[(int)total];
        return this.read(tmp, 0, (int)total);
    }

    public synchronized int available() throws IOException {
        return this.eof ? 0 : (this.chunkSize > 0L ? (int)this.chunkSize : 1);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            byte[] buf = new byte[512];
            while (this.read(buf, 0, buf.length) > -1) {
            }
        } else {
            throw new IOException("Error while closing stream");
        }
        this.in.close();
    }
}

