/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.client;

import java.io.FileInputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.ClientProperties;
import javax.wbem.client.Debug;
import javax.wbem.security.ClientSecurity;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;
import javax.wbem.security.UserPasswordEncryptionProvider;

public class SunDigestClientSecurity
extends ClientSecurity {
    private static final String mechanism = "sundigest";
    private static final String WBEM_LOCAL_TYPE = "__LOCAL";
    private static final String WBEM_LOCAL_DIR = "/var/sadm/wbem/security";
    private static final int WBEM_LOCAL_NONCE_SIZE = 16;
    private static final String BAD_HASH = ".B.A.D.H.A.S.H.";
    private static boolean initialized = false;
    private static MessageDigest md = null;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey cprivkey;
    private static PublicKey cpubkey;
    private static UserPasswordEncryptionProvider pep;
    private byte[] secret;
    private boolean bLocalMode;
    private PublicKey spubkey;
    private String initialKey = "InitialKey";
    private byte[] cchallenge1;
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] encryptKey = null;

    private static synchronized void initialize() throws NoSuchAlgorithmException {
        if (!initialized) {
            md = MessageDigest.getInstance("MD5");
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = keygen.generateKeyPair();
            cprivkey = keypair.getPrivate();
            cpubkey = keypair.getPublic();
            try {
                String cname = System.getProperty("security.password.provider.class");
                if (cname == null) {
                    cname = ClientProperties.getProperty("security.password.provider.class");
                }
                Class<?> c = Class.forName(cname);
                pep = (UserPasswordEncryptionProvider)c.newInstance();
            }
            catch (Exception ex) {
                Debug.trace1("Error getting password encryption provider: " + ex.getMessage());
                throw new NoSuchAlgorithmException("NO_PASSWORD_PROVIDER");
            }
            initialized = true;
        }
    }

    public SunDigestClientSecurity() throws NoSuchAlgorithmException {
        super(mechanism);
        SunDigestClientSecurity.initialize();
    }

    public SunDigestClientSecurity(CIMNameSpace ns, Principal prin, Object cred) throws NoSuchAlgorithmException, CIMException {
        super(mechanism);
        this.bLocalMode = false;
        this.setNameSpace(ns);
        this.setPrincipal(prin);
        this.setCredential(cred);
        SunDigestClientSecurity.initialize();
    }

    public void setPrincipal(Principal prin) throws CIMException {
        super.setPrincipal(prin);
    }

    public String getRoleName() {
        return null;
    }

    public String getRolePassword() {
        return null;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getUserPassword() {
        String tPswd = "";
        if (this.userPswd.length > 0) {
            char[] ca = new char[this.userPswd.length];
            for (int i = 0; i < this.userPswd.length; ++i) {
                ca[i] = (char)(0 | this.userPswd[i] & 0xFF);
            }
            tPswd = new String(ca);
        }
        return tPswd;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public PublicKey getPublicKey() {
        return cpubkey;
    }

    public PublicKey getServerPublicKey() {
        return this.spubkey;
    }

    public PrivateKey getPrivateKey() {
        return cprivkey;
    }

    public MessageDigest getMD() {
        return md;
    }

    public Signature getSigner() {
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateHello() {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            this.cchallenge1 = new byte[16];
            SecurityUtil.secrand.nextBytes(this.cchallenge1);
            md.reset();
            md.update(this.cchallenge1);
            md.update(this.initialKey.getBytes());
            byte[] digest = md.digest();
            String tName = this.userName;
            if (this.bLocalMode) {
                tName = tName + ":" + WBEM_LOCAL_TYPE;
            }
            byte[] unb = tName.getBytes();
            byte[] nsb = this.nsPath.getBytes();
            byte[] hashedUser = SecurityUtil.hashData(unb, digest);
            byte[] hashednsb = SecurityUtil.hashData(nsb, digest);
            md.reset();
            md.update(this.cchallenge1);
            md.update(this.initialKey.getBytes());
            md.update(hashedUser);
            return SecurityMessage.hello(this.cchallenge1, hashedUser, hashednsb, md.digest(hashednsb));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateResponse(SecurityMessage sm) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!sm.isChallenge()) {
                throw new IllegalArgumentException("not a challenge message");
            }
            this.schallenge1 = sm.getChallenge();
            md.reset();
            md.update(sm.getChallenge());
            byte[] digest = md.digest(this.initialKey.getBytes());
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(sm.getSalt());
            if (!MessageDigest.isEqual(md.digest(sm.getSessionId()), sm.getChecksum())) {
                throw new IllegalArgumentException("Checksum error");
            }
            byte[] salt = SecurityUtil.extractHashedData(sm.getSalt(), digest);
            this.sessionId = sm.getSessionId();
            if (salt == null || this.sessionId == null) {
                throw new IllegalArgumentException("Null salt/session");
            }
            String sSalt = new String(salt);
            this.secret = null;
            if (sSalt.startsWith("$__LOCAL$")) {
                Debug.trace2("Local authentication for " + this.userName);
                this.bLocalMode = true;
                String filename = null;
                FileInputStream fis = null;
                int i = WBEM_LOCAL_TYPE.length() + 2;
                try {
                    filename = "/var/sadm/wbem/security/" + sSalt.substring(i);
                    Debug.trace3("Authentication file name: " + filename);
                    fis = new FileInputStream(filename);
                    byte[] bb = new byte[96];
                    int len = fis.read(bb);
                    if (len > 0) {
                        byte[] tb = new byte[len];
                        System.arraycopy(bb, 0, tb, 0, len);
                        String nonceHash = new String(tb, "UTF-8");
                        byte[] sb = SecurityUtil.fromHex(nonceHash);
                        this.secret = SecurityUtil.extractHashedData(sb, this.cchallenge1);
                        Debug.trace3("Authentication shared secret: " + SecurityUtil.toHex(this.secret));
                    }
                }
                catch (Exception ex) {
                    Debug.trace1("Error reading local auth file: " + ex.getMessage());
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ex) {}
            } else {
                Debug.trace2("Password based authentication for " + this.userName);
                this.bLocalMode = false;
                String body = null;
                String pwEncr = null;
                try {
                    pwEncr = pep.encryptPassword(this.userName, sSalt, new String(this.userPswd));
                }
                catch (Exception ex) {
                    pwEncr = BAD_HASH;
                }
                if (pwEncr != null && pwEncr.length() > 0) {
                    if (pwEncr.charAt(0) == '$') {
                        try {
                            int i = pwEncr.lastIndexOf(36);
                            body = pwEncr.substring(i + 1);
                        }
                        catch (Exception ex) {}
                    } else {
                        body = pwEncr;
                    }
                }
                if (body != null) {
                    try {
                        this.secret = body.getBytes("UTF-8");
                        Debug.trace3("Authentication shared secret: " + new String(this.secret));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (this.secret == null) {
                try {
                    this.secret = BAD_HASH.getBytes("UTF-8");
                    Debug.trace3("Authentication shared secret is bad ");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(this.secret);
            digest = md.digest();
            byte[] pwHash = null;
            pwHash = this.bLocalMode ? SecurityUtil.hashData(this.secret, digest) : SecurityUtil.hashData(this.userPswd, digest);
            md.reset();
            md.update(sm.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(this.secret);
            md.update(pwHash);
            md.update(cpubkey.getEncoded());
            return SecurityMessage.response(pwHash, cpubkey, this.sessionId, md.digest(this.sessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] checkResult(SecurityMessage sm) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!sm.isResult()) {
                throw new IllegalArgumentException("not a result message");
            }
            byte[] bPswd = this.bLocalMode ? this.secret : this.userPswd;
            md.reset();
            md.update(this.getChallenge());
            md.update(bPswd);
            byte[] digest = md.digest();
            md.reset();
            md.update(this.getChallenge());
            md.update(bPswd);
            md.update(sm.getSessionId());
            this.spubkey = sm.getPublicKey();
            md.update(this.spubkey.getEncoded());
            md.update(sm.getResponse());
            if (!MessageDigest.isEqual(md.digest(), sm.getChecksum())) {
                Debug.trace1("Authentication checksum failure for " + this.userName);
                throw new IllegalArgumentException("mutual authentication failed");
            }
            this.sessionKey = SecurityUtil.extractHashedData(sm.getResponse(), digest);
            if (this.sessionKey == null) {
                throw new IllegalArgumentException("Null response");
            }
            this.encryptKey = new byte[this.sessionKey.length];
            System.arraycopy(this.sessionKey, 0, this.encryptKey, 0, this.sessionKey.length);
            return this.sessionKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityToken getSecurityToken(String[] sarray) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            SecurityToken st = new SecurityToken();
            String s = "";
            for (int i = 0; i < sarray.length; ++i) {
                s = s + sarray[i];
            }
            byte[] ser = s.getBytes();
            MessageDigest digester = this.getMD();
            digester.reset();
            digester.update(this.getSessionKey());
            digester.update(ser);
            byte[] digest = digester.digest();
            st.setChecksum(digest);
            st.setSessionId(this.getSessionId());
            return st;
        }
    }

    public synchronized void incSessionKey() {
        SecurityUtil.incByteArray(this.sessionKey);
    }

    static {
        pep = null;
    }
}

