/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.client.adapter.rmi;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMTransportException;
import javax.wbem.client.Debug;
import javax.wbem.security.ClientSecurityContext;
import org.wbemservices.wbem.client.adapter.rmi.CIMOM_1;
import org.wbemservices.wbem.client.adapter.rmi.RMIJavaxClient;

public class CIMClientRMI
implements CIMClientAPI {
    public static final String RMIPORT = "5987";
    private static final String RMIPORTPROP = "javax.wbem.rmiport";
    private static final String RMIPROTVERSION = "1";
    private static final Object lockObject = new Object();
    private static final String protocol_name = "cim-rmi";
    private CIMClientAPI rmiAdapter;
    private CIMNameSpace nameSpace;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$wbem$cim$CIMNameSpace;
    static /* synthetic */ Class class$javax$wbem$client$CIMListener;
    static /* synthetic */ Class class$java$lang$Integer;

    private CIMClientAPI getComSunAdapter(String version, CIMNameSpace name, CIMListener clientListener, Integer dbg) throws CIMException {
        try {
            Debug.trace2("Loading comsun adapter for backward compatibility");
            Class<?> c = Class.forName("org.wbemservices.wbem.client.RMIComSunClient");
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CIMClientRMI.class$("java.lang.String")) : class$java$lang$String, class$javax$wbem$cim$CIMNameSpace == null ? (class$javax$wbem$cim$CIMNameSpace = CIMClientRMI.class$("javax.wbem.cim.CIMNameSpace")) : class$javax$wbem$cim$CIMNameSpace, class$javax$wbem$client$CIMListener == null ? (class$javax$wbem$client$CIMListener = CIMClientRMI.class$("javax.wbem.client.CIMListener")) : class$javax$wbem$client$CIMListener, class$java$lang$Integer == null ? (class$java$lang$Integer = CIMClientRMI.class$("java.lang.Integer")) : class$java$lang$Integer};
            Constructor<?> constr = c.getConstructor(params);
            Object[] args = new Object[]{version, name, clientListener, dbg};
            CIMClientAPI api = (CIMClientAPI)constr.newInstance(args);
            return api;
        }
        catch (Exception e) {
            Debug.trace2("Got exception while initializing comsun adapter", e);
            throw new CIMException("VER_ERROR", RMIPROTVERSION, "No comsun adapter found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CIMOM_1 retryConnection(String uri) throws CIMTransportException, NotBoundException {
        boolean lastExceptionNotBound = false;
        NotBoundException nbe = null;
        int i = 0;
        while (true) {
            if (++i > 5) {
                if (lastExceptionNotBound) {
                    throw nbe;
                }
                throw new CIMTransportException("TIMED_OUT", (Object)uri);
            }
            CIMClientRMI cIMClientRMI = this;
            synchronized (cIMClientRMI) {
                try {
                    this.wait(4000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            try {
                CIMOM_1 comp = (CIMOM_1)Naming.lookup(uri);
                return comp;
            }
            catch (NotBoundException e0) {
                nbe = e0;
                lastExceptionNotBound = true;
                continue;
            }
            catch (Exception e1) {
                lastExceptionNotBound = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMClientRMI(String version, CIMNameSpace name, CIMListener clientListener, Integer dbg) throws CIMException {
        this.nameSpace = name;
        String rmiport = System.getProperty(RMIPORTPROP, RMIPORT);
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("//");
        buffer.append(this.nameSpace.getHost());
        buffer.append(':');
        buffer.append(rmiport);
        buffer.append("/CIMOM_");
        buffer.append(RMIPROTVERSION);
        String uri = buffer.toString();
        try {
            Object object = lockObject;
            synchronized (object) {
                CIMOM_1 comp;
                try {
                    comp = (CIMOM_1)Naming.lookup(uri);
                }
                catch (MarshalException me) {
                    comp = this.retryConnection(rmiport);
                }
                catch (ConnectIOException me) {
                    comp = this.retryConnection(rmiport);
                }
                this.rmiAdapter = new RMIJavaxClient(version, name, clientListener, dbg, comp);
            }
        }
        catch (UnknownHostException ex) {
            throw new CIMTransportException("UNKNOWNHOST", (Object)this.nameSpace.getHost());
        }
        catch (ConnectException ex) {
            throw new CIMTransportException("NO_CIMOM", (Object)uri);
        }
        catch (RemoteException ex) {
            if (ex.detail instanceof ClassNotFoundException) {
                throw new NoClassDefFoundError(ex.detail.toString());
            }
            throw new CIMTransportException("NO_CIMOM", (Object)uri);
        }
        catch (MalformedURLException ex) {
            throw new CIMTransportException("NO_CIMOM", (Object)uri);
        }
        catch (NotBoundException ex) {
            this.rmiAdapter = this.getComSunAdapter(version, name, clientListener, dbg);
        }
    }

    public String getProtocol() {
        return protocol_name;
    }

    public synchronized void initSecurityContext(String version, ClientSecurityContext csc) throws CIMException {
        this.rmiAdapter.initSecurityContext(version, csc);
    }

    public synchronized void createNameSpace(String version, CIMNameSpace currNs, CIMNameSpace newNs) throws CIMException {
        this.rmiAdapter.createNameSpace(version, currNs, newNs);
    }

    public synchronized void close(String version) throws CIMException {
        this.rmiAdapter.close(version);
    }

    public synchronized void deleteNameSpace(String version, CIMNameSpace currNs, CIMNameSpace delNs) throws CIMException {
        this.rmiAdapter.deleteNameSpace(version, currNs, delNs);
    }

    public synchronized void deleteClass(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        this.rmiAdapter.deleteClass(version, currNs, path);
    }

    public synchronized void deleteInstance(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        this.rmiAdapter.deleteInstance(version, currNs, path);
    }

    public synchronized void deleteQualifierType(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        this.rmiAdapter.deleteQualifierType(version, currNs, path);
    }

    public synchronized Vector enumerateClasses(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws CIMException {
        return this.rmiAdapter.enumerateClasses(version, currNs, path, deep, localOnly, includeQualifiers, includeClassOrigin);
    }

    public synchronized Vector enumerateClassNames(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        return this.rmiAdapter.enumerateClassNames(version, currNs, path, deep);
    }

    public synchronized Vector enumNameSpace(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep) throws CIMException {
        return this.rmiAdapter.enumNameSpace(version, currNs, path, deep);
    }

    public Vector enumerateInstances(String version, CIMNameSpace currNs, CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.rmiAdapter.enumerateInstances(version, currNs, path, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public Vector enumerateInstanceNames(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        return this.rmiAdapter.enumerateInstanceNames(version, currNs, path);
    }

    public synchronized Vector enumQualifierTypes(String version, CIMNameSpace currNs, CIMObjectPath path) throws CIMException {
        return this.rmiAdapter.enumQualifierTypes(version, currNs, path);
    }

    public CIMClass getClass(String version, CIMNameSpace currNs, CIMObjectPath path, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.rmiAdapter.getClass(version, currNs, path, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public CIMInstance getInstance(String version, CIMNameSpace currNs, CIMObjectPath path, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.rmiAdapter.getInstance(version, currNs, path, localOnly, includeQualifiers, includeClassOrigin, propertyList);
    }

    public synchronized CIMValue invokeMethod(String version, CIMNameSpace currNs, CIMObjectPath name, String methodName, CIMArgument[] inArgs, CIMArgument[] outArgs) throws CIMException {
        return this.rmiAdapter.invokeMethod(version, currNs, name, methodName, inArgs, outArgs);
    }

    public synchronized CIMQualifierType getQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name) throws CIMException {
        return this.rmiAdapter.getQualifierType(version, currNs, name);
    }

    public synchronized void createQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        this.rmiAdapter.createQualifierType(version, currNs, name, qt);
    }

    public synchronized void createClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        this.rmiAdapter.createClass(version, currNs, name, cc);
    }

    public synchronized CIMObjectPath createInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci) throws CIMException {
        return this.rmiAdapter.createInstance(version, currNs, name, ci);
    }

    public synchronized void setQualifierType(String version, CIMNameSpace currNs, CIMObjectPath name, CIMQualifierType qt) throws CIMException {
        this.rmiAdapter.setQualifierType(version, currNs, name, qt);
    }

    public synchronized void setClass(String version, CIMNameSpace currNs, CIMObjectPath name, CIMClass cc) throws CIMException {
        this.rmiAdapter.setClass(version, currNs, name, cc);
    }

    public synchronized void setInstance(String version, CIMNameSpace currNs, CIMObjectPath name, CIMInstance ci, boolean includeQualifier, String[] propertyList) throws CIMException {
        this.rmiAdapter.setInstance(version, currNs, name, ci, includeQualifier, propertyList);
    }

    public synchronized CIMValue getProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName) throws CIMException {
        return this.rmiAdapter.getProperty(version, currNs, name, propertyName);
    }

    public synchronized void setProperty(String version, CIMNameSpace currNs, CIMObjectPath name, String propertyName, CIMValue cv) throws CIMException {
        this.rmiAdapter.setProperty(version, currNs, name, propertyName, cv);
    }

    public synchronized Vector execQuery(String version, CIMNameSpace currNs, CIMObjectPath relNS, String query, String ql) throws CIMException {
        return this.rmiAdapter.execQuery(version, currNs, relNS, query, ql);
    }

    public Vector associators(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.rmiAdapter.associators(version, currNs, objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
    }

    public Vector associatorNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        return this.rmiAdapter.associatorNames(version, currNs, objectName, assocClass, resultClass, role, resultRole);
    }

    public Vector references(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList) throws CIMException {
        return this.rmiAdapter.references(version, currNs, objectName, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
    }

    public Vector referenceNames(String version, CIMNameSpace currNs, CIMObjectPath objectName, String resultClass, String role) throws CIMException {
        return this.rmiAdapter.referenceNames(version, currNs, objectName, resultClass, role);
    }

    public Vector performOperations(String version, CIMOperation[] batchedOperations) throws CIMException {
        return this.rmiAdapter.performOperations(version, batchedOperations);
    }

    public void setListener(String version) throws CIMException {
        this.rmiAdapter.setListener(version);
    }

    public void setListener(String version, int port) throws CIMException {
        this.rmiAdapter.setListener(version);
    }

    public CIMInstance getIndicationHandler(CIMListener cl) throws CIMException {
        return this.rmiAdapter.getIndicationHandler(cl);
    }

    public CIMInstance getIndicationListener(CIMListener cl) throws CIMException {
        return this.rmiAdapter.getIndicationListener(cl);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

