/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class SimulatorConfig {
    private static final String DERBY_LOCAL_URL = "jdbc:derby:";
    private static final String DB2_LOCAL_URL = "jdbc:db2:";
    private static final String DB2_REMOTE_URL = "jdbc:db2:";
    private static final String CONFIG_PROPERY_DATABASE = "DATABASE";
    private static final String CONFIG_PROPERTY_DB_USERNAME = "DB_USERNAME";
    private static final String CONFIG_PROPERTY_DB_PASSWORD = "DB_PASSWORD";
    private static final String CONFIG_PROPERTY_DB_NAME = "DB_NAME";
    private static final String CONFIG_PROPERTY_DB_LOCATION = "DB_LOCATION";
    private static final String SIMULATOR_CONFIG_FILENAME = "..\\..\\..\\san_simulator_cimom.properties";
    public static final String SETUP_WIZARD_CONFIG_FILEPATH = "SETUP_WIZARD_CONFIG_FILEPATH";
    public static final String DB2_LOCAL_DRIVER_NAME = "COM.ibm.db2.jdbc.app.DB2Driver";
    public static final String DB2_REMOTE_DRIVER_NAME = "com.ibm.db2.jcc.DB2Driver";
    public static final String DERBY_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String SUBSYSTEM = "SUBSYSTEM";
    public static final String STORAGE_POOLS = "STORAGE_POOLS";
    public static final String STORAGE_EXTENTS = "STORAGE_EXTENTS";
    public static final String STORAGE_VOLUMES = "STORAGE_VOLUMES";
    public static final String SUBSYSTEM_DS8K = "DS8K";
    public static String dbDriverName = "COM.ibm.db2.jdbc.app.DB2Driver";
    public static String dbUrl = "jdbc:db2:";
    public static String dbUsername;
    public static String dbPassword;
    private static String databaseName;

    static {
        databaseName = "SIMDB";
        Properties properties = new Properties();
        try {
            File file = new File(SIMULATOR_CONFIG_FILENAME);
            String string = System.getProperty(SETUP_WIZARD_CONFIG_FILEPATH);
            if (file.exists()) {
                properties.load(new FileInputStream(SIMULATOR_CONFIG_FILENAME));
            } else if (null != string) {
                properties.load(new FileInputStream(System.getProperty(SETUP_WIZARD_CONFIG_FILEPATH)));
            }
            String string2 = properties.getProperty(CONFIG_PROPERY_DATABASE);
            databaseName = properties.getProperty(CONFIG_PROPERTY_DB_NAME);
            if (string2.equalsIgnoreCase("derby")) {
                dbDriverName = DERBY_DRIVER_NAME;
                String string3 = properties.getProperty(CONFIG_PROPERTY_DB_PASSWORD);
                dbUrl = DERBY_LOCAL_URL + databaseName + ";bootPassword=" + string3;
            } else if (string2.equalsIgnoreCase("db2")) {
                String string4 = properties.getProperty(CONFIG_PROPERTY_DB_LOCATION);
                if (string4.equalsIgnoreCase("localhost") || string4.equals("127.0.0.1")) {
                    dbUrl = "jdbc:db2:" + databaseName;
                    dbDriverName = DB2_LOCAL_DRIVER_NAME;
                } else {
                    dbUrl = "jdbc:db2://" + string4 + ":50000/" + databaseName;
                    dbUsername = properties.getProperty(CONFIG_PROPERTY_DB_USERNAME);
                    dbPassword = properties.getProperty(CONFIG_PROPERTY_DB_PASSWORD);
                    dbDriverName = DB2_REMOTE_DRIVER_NAME;
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

