/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.DS4K;

import java.io.FileInputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;

public class DS4KCimomDataGenerator {
    private static final String DS4K_SYSTEM_NAME_PREFIX = "600A0B80000BC456";
    private static final String INTEROP_XML = "XML\\Storage\\IBM\\DS4K\\DS4K_interop.xml";
    private static final String ROOT_LSISSI11_XML = "XML\\Storage\\IBM\\DS4K\\DS4K_LSISSI_11.xml";
    private static final String NAMESPACE_INTEROP = "/interop";
    private static final String NAMESPACE_ROOT_LSISSI11 = "/root/lsissi11";
    private String configFile = "conf/DS4K-requirement.config";
    private String storageSystemName;
    private String storageSystemNumber;

    private void generateDataForInterop(int n, DataGeneratorResponse dataGeneratorResponse) throws Exception {
        DeviceDataGenerator deviceDataGenerator = new DeviceDataGenerator(INTEROP_XML, this.configFile);
        DataGeneratorResponse dataGeneratorResponse2 = deviceDataGenerator.generateData(NAMESPACE_INTEROP);
        Iterator iterator = dataGeneratorResponse2.getRemainingClassList().iterator();
        SimClass simClass = null;
        while (iterator.hasNext() && !(simClass = (SimClass)iterator.next()).getName().equalsIgnoreCase("LSISSI_ElementConformsToProfile")) {
        }
        List list = deviceDataGenerator.getCreator().createAssociationInstances(simClass, ((List)dataGeneratorResponse2.getInstanceMap().get("/interop:LSISSI_RegisteredProfile")).toArray(), (CIMInstance)dataGeneratorResponse.getInstanceMap().get("/root/lsissi11:LSISSI_StorageSystem"));
        dataGeneratorResponse2.getInstanceMap().put("/interop:LSISSI_ElementConformsToProfile", list);
        DatabaseManager.getDbManager().persistInstances(n, dataGeneratorResponse2.getInstanceMap(), deviceDataGenerator.getParserResponse().getClassMap());
    }

    private DataGeneratorResponse generateDataForLSISSI11(int n) throws Exception {
        DeviceDataGenerator deviceDataGenerator = new DeviceDataGenerator(ROOT_LSISSI11_XML, this.configFile);
        deviceDataGenerator.getConfProperties().setProperty("STORAGE_SYSTEM_NUMBER", this.storageSystemNumber);
        deviceDataGenerator.getConfProperties().setProperty("STORAGE_SYSTEM_NAME", this.storageSystemName);
        DataGeneratorResponse dataGeneratorResponse = deviceDataGenerator.generateData(NAMESPACE_ROOT_LSISSI11);
        Properties properties = new Properties();
        properties.load(new FileInputStream("conf/classlist.properties"));
        String[] stringArray = properties.getProperty("STORAGE_POOL_LIST").split(",");
        LinkedList linkedList = new LinkedList();
        Collections.addAll(linkedList, stringArray);
        stringArray = properties.getProperty("STORAGE_VOLUME_LIST").split(",");
        Collections.addAll(linkedList, stringArray);
        stringArray = properties.getProperty("STORAGE_EXTENT_LIST").split(",");
        Collections.addAll(linkedList, stringArray);
        Properties properties2 = new Properties();
        properties2.load(new FileInputStream(this.configFile));
        int n2 = Integer.parseInt(properties2.getProperty("NUMBER_OF_STORAGE_POOL"));
        String[] stringArray2 = properties2.getProperty("MAPPING_POOL_TO_VOLUME").split(" ");
        String[] stringArray3 = properties2.getProperty("MAPPING_DISK_TO_POOL").split(" ");
        for (int i = 0; i < n2; ++i) {
            deviceDataGenerator.getConfProperties().setProperty("NUMBER_OF_STORAGE_POOL", "1");
            deviceDataGenerator.getConfProperties().setProperty("NUMBER_OF_DISK", stringArray3[i]);
            deviceDataGenerator.getConfProperties().setProperty("NUMBER_OF_VOLUMES", stringArray2[i]);
            deviceDataGenerator.generateData(linkedList, dataGeneratorResponse);
        }
        DatabaseManager.getDbManager().persistInstances(n, dataGeneratorResponse.getInstanceMap(), deviceDataGenerator.getParserResponse().getClassMap());
        return dataGeneratorResponse;
    }

    public void generateData(String string) {
        if (null != string) {
            this.configFile = string;
        }
        DatabaseManager databaseManager = DatabaseManager.getDbManager();
        try {
            this.storageSystemNumber = DS4K_SYSTEM_NAME_PREFIX + IDGenerator.getRandomKey("8") + IDGenerator.getRandomKey("8");
            this.storageSystemName = "StorageSystem-" + IDGenerator.getRandomKey("4");
            databaseManager.insert_CIMOM_INFO(1, "DS4K " + this.storageSystemName + " CIMOM", "127.0.0.1", NAMESPACE_INTEROP, "administrator", "san46pass");
            int n = databaseManager.getMaxID("SIM.CIMOM_INFO");
            databaseManager.insert_NS_INFO(n, NAMESPACE_INTEROP);
            int n2 = databaseManager.getMaxID("SIM.NS_INFO");
            databaseManager.insert_NS_INFO(n, NAMESPACE_ROOT_LSISSI11);
            int n3 = databaseManager.getMaxID("SIM.NS_INFO");
            DataGeneratorResponse dataGeneratorResponse = this.generateDataForLSISSI11(n3);
            this.generateDataForInterop(n2, dataGeneratorResponse);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Jai Baberi");
        DS4KCimomDataGenerator dS4KCimomDataGenerator = new DS4KCimomDataGenerator();
        dS4KCimomDataGenerator.generateData(null);
        System.out.println("Program completed");
    }
}

