/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.brocade;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.PropertyParser;

public class BrocadeCIMOMDataGenerator {
    private static final String FABRIC_NAME_SUFFIX = "69101F9A";
    private static final String CONFIG_FILE = "conf/Brocade-requirement.config";
    private static final String BROCADE_ROOT_XML = "XML\\Brocade\\Switch\\Brocade_Root_Brocade1.xml";
    private static final String BROCADE_INTEROP_XML = "XML\\Brocade\\Switch\\Brocade_Interop.xml";
    private static final String NAMESPACE_ROOT_BROCADE1 = "/root/brocade1";
    private static final String NAMESPACE_INTEROP = "/interop";

    public void generateData() throws Exception {
        DatabaseManager databaseManager = DatabaseManager.getDbManager();
        databaseManager.insert_CIMOM_INFO(1, "Simulated Brocade CIMOM", "127.0.0.1", NAMESPACE_INTEROP, "administrator", "san46pass");
        int n = databaseManager.getMaxID("SIM.CIMOM_INFO");
        databaseManager.insert_NS_INFO(n, NAMESPACE_INTEROP);
        int n2 = databaseManager.getMaxID("SIM.NS_INFO");
        databaseManager.insert_NS_INFO(n, NAMESPACE_ROOT_BROCADE1);
        int n3 = databaseManager.getMaxID("SIM.NS_INFO");
        this.generateData(n2, n3);
    }

    private void generateData(int n, int n2) throws Exception {
        DeviceDataGenerator deviceDataGenerator = new DeviceDataGenerator(BROCADE_INTEROP_XML, CONFIG_FILE);
        DataGeneratorResponse dataGeneratorResponse = deviceDataGenerator.generateData(NAMESPACE_INTEROP);
        DeviceDataGenerator deviceDataGenerator2 = new DeviceDataGenerator(BROCADE_ROOT_XML, CONFIG_FILE);
        DataGeneratorResponse dataGeneratorResponse2 = deviceDataGenerator2.generateData(NAMESPACE_ROOT_BROCADE1);
        Properties properties = new Properties();
        properties.load(new FileInputStream(CONFIG_FILE));
        PropertyParser propertyParser = new PropertyParser();
        Properties properties2 = propertyParser.parse("conf" + File.separator + "ClassList.xml");
        int n3 = Integer.parseInt(properties.getProperty("NUMBER_OF_FABRIC"));
        int n4 = 10000060;
        int n5 = 10000060;
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        String string = Integer.toString(Integer.parseInt(FABRIC_NAME_SUFFIX, 16) + IDGenerator.getRandomKey("4"), 16).toUpperCase();
        for (int i = 0; i < n3; ++i) {
            String string2;
            String string3 = Integer.toString(Integer.parseInt(string, 16) + 10 * i, 16).toUpperCase();
            String string4 = string2 = n4 + string3;
            deviceDataGenerator.getConfProperties().setProperty("FABRIC_NAME", string2);
            deviceDataGenerator2.getConfProperties().setProperty("FABRIC_NAME", string2);
            deviceDataGenerator2.getConfProperties().setProperty("NUMBER_OF_FABRIC", Integer.toString(1));
            deviceDataGenerator.getConfProperties().setProperty("NUMBER_OF_FABRIC", Integer.toString(1));
            String[] stringArray = properties2.getProperty("INTEROP_FABRIC_CLASS_LIST").split(",");
            LinkedList linkedList = new LinkedList();
            Collections.addAll(linkedList, stringArray);
            deviceDataGenerator.generateData(linkedList, dataGeneratorResponse);
            String[] stringArray2 = properties2.getProperty("FABRIC_CLASS_LIST").split(",");
            ArrayList arrayList2 = new ArrayList();
            Collections.addAll(arrayList2, stringArray2);
            deviceDataGenerator2.generateData(arrayList2, dataGeneratorResponse2);
            CIMInstance cIMInstance = (CIMInstance)dataGeneratorResponse2.getInstanceMap().get("/root/brocade1:Brocade_Fabric");
            int n6 = Integer.parseInt(properties.getProperty("NUMBER_OF_SWITCHES"));
            stringArray = properties2.getProperty("INTEROP_SWITCH_CLASS_LIST").split(",");
            linkedList.clear();
            Collections.addAll(linkedList, stringArray);
            stringArray2 = properties2.getProperty("SWITCH_CLASS_LIST").split(",");
            arrayList2.clear();
            Collections.addAll(arrayList2, stringArray2);
            deviceDataGenerator2.getConfProperties().setProperty("NUMBER_OF_SWITCHES", Integer.toString(1));
            deviceDataGenerator.getConfProperties().setProperty("NUMBER_OF_SWITCHES", Integer.toString(1));
            int n7 = 0;
            while (n7 < n6) {
                String string5 = Integer.toString(1001 + n7 + 100 * i);
                deviceDataGenerator.getConfProperties().setProperty("SWITCH_ID", string5);
                deviceDataGenerator.getConfProperties().setProperty("SWITCH_NAME", string4);
                deviceDataGenerator.getConfProperties().setProperty("SWITCH_ELEMENT_NAME", "SimulatedSwitch_" + string5);
                deviceDataGenerator.generateData(linkedList, dataGeneratorResponse);
                deviceDataGenerator2.getConfProperties().setProperty("SWITCH_ID", string5);
                deviceDataGenerator2.getConfProperties().setProperty("SWITCH_NAME", string4);
                deviceDataGenerator2.getConfProperties().setProperty("SWITCH_ELEMENT_NAME", "SimulatedSwitch_" + string5);
                deviceDataGenerator2.getConfProperties().setProperty("SWITCH_PORT_PREFIX", string4.substring(4, string4.length()));
                deviceDataGenerator2.generateData(arrayList2, dataGeneratorResponse2);
                string4 = n5 + ++n7 + 100 * i + string3;
            }
            dataGeneratorResponse2.getInstanceMap().remove("/root/brocade1:Brocade_Fabric");
            arrayList.add(cIMInstance);
        }
        dataGeneratorResponse2.addInstances("/root/brocade1:Brocade_Fabric", arrayList);
        Map map = deviceDataGenerator2.getParserResponse().getClassMap();
        DatabaseManager.getDbManager().persistInstances(n2, dataGeneratorResponse2.getInstanceMap(), map);
        map = deviceDataGenerator.getParserResponse().getClassMap();
        DatabaseManager.getDbManager().persistInstances(n, dataGeneratorResponse.getInstanceMap(), map);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Jai Baberi");
        BrocadeCIMOMDataGenerator brocadeCIMOMDataGenerator = new BrocadeCIMOMDataGenerator();
        brocadeCIMOMDataGenerator.generateData();
        System.out.println("Program Completed");
    }
}

