/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.base;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.eclipse.aperi.simulator.SimulatorConfig;
import org.eclipse.aperi.simulator.SimulatorException;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;

public abstract class BaseSnapshotMaker
extends Thread {
    protected CIMOM cimom;
    protected Connection con;

    public BaseSnapshotMaker(CIMOM cIMOM) throws SimulatorException {
        this.cimom = cIMOM;
        try {
            this.con = DriverManager.getConnection(SimulatorConfig.dbUrl);
        }
        catch (Exception exception) {
            throw new SimulatorException("", "", exception);
        }
    }

    public void takeSnapshot() throws SimulatorException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new SimulatorException(exception.getMessage(), "", exception);
        }
    }

    public abstract void run();

    protected synchronized void insert_CIMOM_INFO(int n, String string, String string2, String string3, String string4, String string5) throws Exception {
        String string6 = "INSERT INTO SIM.CIMOM_INFO (CIMOM_TYPE, DETAILS, URL, INTOP_NS, USERID, PWDID) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = this.con.prepareStatement(string6);
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, "SUN WBEM CIMOM");
        preparedStatement.setString(3, string2);
        preparedStatement.setString(4, string3);
        if (string4 != null) {
            preparedStatement.setString(5, string4);
        } else {
            preparedStatement.setNull(5, 12);
        }
        if (string5 != null) {
            preparedStatement.setString(6, string5);
        } else {
            preparedStatement.setNull(6, 12);
        }
        preparedStatement.executeUpdate();
        this.con.commit();
        preparedStatement.close();
    }

    protected synchronized void insert_NS_INFO(int n, String string) throws Exception {
        String string2 = "INSERT INTO SIM.NS_INFO(CIMOM_INFO_ID, NAMESPACE) VALUES (?, ?)";
        PreparedStatement preparedStatement = this.con.prepareStatement(string2);
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        this.con.commit();
        preparedStatement.close();
    }

    protected synchronized void insert_CIM_CLASS(int n, String string) throws Exception {
        String string2 = "INSERT INTO SIM.CIM_CLASS(NS_INFO_ID, CLASS_NAME) VALUES (?, ?)";
        PreparedStatement preparedStatement = this.con.prepareStatement(string2);
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        this.con.commit();
        preparedStatement.close();
    }

    protected int getMaxID(String string) throws Exception {
        int n = -1;
        String string2 = "SELECT MAX(ID) FROM " + string;
        PreparedStatement preparedStatement = this.con.prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    protected synchronized void snapshotClassInstances(String string, int n) throws Exception {
    }

    protected synchronized void snapshotClasses(String string, int n) throws Exception {
    }

    protected synchronized void insert_CIM_ASSOC(int n, int n2, int n3) throws Exception {
        String string = "INSERT INTO SIM.CIM_ASC(CIM_DATA_ASC_ID, CIM_DATA_FRM_ID, CIM_DATA_TO_ID) VALUES (?, ?, ?)";
        PreparedStatement preparedStatement = this.con.prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        preparedStatement.setInt(3, n3);
        preparedStatement.executeUpdate();
        this.con.commit();
        preparedStatement.close();
    }

    static {
        try {
            Class.forName(SimulatorConfig.dbDriverName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

