/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.ExpressionParser;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimPropertyPreSuf;
import org.eclipse.aperi.simulator.cimom.common.generator.SimRandomProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimReferProperty;
import org.eclipse.aperi.simulator.cimom.common.generator.SimValue;

public class InstanceCreator {
    private String namespace;
    private Properties confProperties;
    private int count = 0;

    public InstanceCreator() {
    }

    public InstanceCreator(String string) {
        this.namespace = string;
    }

    public CIMInstance createAssociationInstance(SimClass simClass, CIMInstance cIMInstance, CIMInstance cIMInstance2) {
        CIMObjectPath cIMObjectPath = this.getObjectPath(cIMInstance, ((SimAssociationClass)simClass).getAntecedentNS());
        CIMObjectPath cIMObjectPath2 = this.getObjectPath(cIMInstance2, ((SimAssociationClass)simClass).getDependentNS());
        return this.createAssociationInstance(simClass, cIMObjectPath, cIMObjectPath2);
    }

    public CIMInstance createAssociationInstance(SimClass simClass, CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setClassName(simClass.getName());
        cIMInstance.setName(simClass.getName());
        List list = simClass.getProperties();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        CIMProperty cIMProperty = new CIMProperty(((SimAssociationClass)simClass).getAntecedentName());
        cIMProperty.setName(((SimAssociationClass)simClass).getAntecedentName());
        cIMProperty.setType(new CIMDataType(((SimAssociationClass)simClass).getAntecedentClassName()));
        cIMObjectPath.setNameSpace(((SimAssociationClass)simClass).getAntecedentNS());
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath));
        cIMProperty.setKey(((SimAssociationClass)simClass).isAntecedentKey());
        vector.add(cIMProperty);
        cIMProperty = new CIMProperty(((SimAssociationClass)simClass).getDependentName());
        cIMProperty.setName(((SimAssociationClass)simClass).getDependentName());
        CIMDataType cIMDataType = new CIMDataType(((SimAssociationClass)simClass).getDependentClassName());
        cIMProperty.setType(cIMDataType);
        cIMObjectPath2.setNameSpace(((SimAssociationClass)simClass).getDependentNS());
        cIMProperty.setValue(new CIMValue((Object)cIMObjectPath2));
        cIMProperty.setKey(((SimAssociationClass)simClass).isDependentKey());
        vector.add(cIMProperty);
        for (int i = 0; i < list.size(); ++i) {
            SimProperty simProperty = (SimProperty)list.get(i);
            cIMProperty = new CIMProperty(simProperty.getName());
            cIMProperty.setName(simProperty.getName());
            cIMProperty.setType(simProperty.getCIMDataType());
            this.setPropertyValue(cIMProperty, simProperty.getValue());
            cIMProperty.setKey(simProperty.isKey());
            vector.add(cIMProperty);
        }
        cIMInstance.setProperties(vector);
        this.setObjectPath(cIMInstance, simClass.getNamespace());
        System.out.println("Create  association instance : " + ++this.count);
        return cIMInstance;
    }

    public List createAssociationInstances(SimClass simClass, CIMInstance cIMInstance, Object[] objectArray) {
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(this.createAssociationInstance(simClass, cIMInstance, (CIMInstance)objectArray[i]));
        }
        return arrayList;
    }

    public List createAssociationInstances(SimClass simClass, Object[] objectArray, CIMInstance cIMInstance) {
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(this.createAssociationInstance(simClass, (CIMInstance)objectArray[i], cIMInstance));
        }
        return arrayList;
    }

    public List createAssociationInstances(SimClass simClass, Object[] objectArray, Object[] objectArray2) {
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        if (objectArray.length != objectArray2.length) {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(this.createAssociationInstance(simClass, (CIMInstance)objectArray[i], (CIMInstance)objectArray2[i]));
        }
        return arrayList;
    }

    public List createInstances(SimClass simClass, Map map) {
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        int n = simClass.getNumberOfInstances();
        for (int i = 0; i < n; ++i) {
            CIMInstance cIMInstance = new CIMInstance();
            cIMInstance.setName(simClass.getName());
            cIMInstance.setClassName(simClass.getName());
            Iterator iterator = simClass.getProperties().iterator();
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            while (iterator.hasNext()) {
                SimProperty simProperty = (SimProperty)iterator.next();
                CIMProperty cIMProperty = new CIMProperty(simProperty.getName());
                cIMProperty.setName(simProperty.getName());
                cIMProperty.setType(simProperty.getCIMDataType());
                cIMProperty.setKey(simProperty.isKey());
                Object object = null;
                if (simProperty.isRefer()) {
                    if (((SimReferProperty)simProperty).isExternal()) {
                        this.setPropertyValue(cIMProperty, this.getExternalReferProperty(simProperty, map, vector, i));
                    } else {
                        this.setPropertyValue(cIMProperty, this.getReferProperty(simProperty, vector));
                    }
                } else if (simProperty.isMultiple()) {
                    object = this.handleMultipleValueProperty(simProperty, i);
                } else if (simProperty.isRandom()) {
                    object = IDGenerator.getRandomKey(simProperty);
                    object = SimProperty.getTypedValue(object, simProperty.getDataType());
                } else {
                    object = simProperty.isIncremental() ? new Integer(simProperty.getIncremental() + i) : (simProperty.isMultiple() ? simProperty.getValues(i) : simProperty.getValue());
                }
                this.setPropertyValue(cIMProperty, object);
                vector.add(cIMProperty);
            }
            cIMInstance.setProperties(vector);
            this.setObjectPath(cIMInstance, simClass.getNamespace());
            arrayList.add(cIMInstance);
        }
        return arrayList;
    }

    public CIMInstance createInstance(SimClass simClass, Map map) {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setName(simClass.getName());
        cIMInstance.setClassName(simClass.getName());
        Iterator iterator = simClass.getProperties().iterator();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        while (iterator.hasNext()) {
            SimProperty simProperty = (SimProperty)iterator.next();
            CIMProperty cIMProperty = new CIMProperty(simProperty.getName());
            cIMProperty.setName(simProperty.getName());
            cIMProperty.setType(simProperty.getCIMDataType());
            cIMProperty.setKey(simProperty.isKey());
            Object object = null;
            if (simProperty.isRefer()) {
                if (((SimReferProperty)simProperty).isExternal()) {
                    this.setPropertyValue(cIMProperty, this.getExternalReferProperty(simProperty, map, vector, 0));
                } else {
                    this.setPropertyValue(cIMProperty, this.getReferProperty(simProperty, vector));
                }
            } else if (simProperty.isMultiple()) {
                object = this.handleMultipleValueProperty(simProperty, 0);
            } else if (simProperty.isRandom()) {
                object = IDGenerator.getRandomKey(simProperty);
                object = SimProperty.getTypedValue(object, simProperty.getDataType());
            } else {
                object = simProperty.isIncremental() ? new Integer(simProperty.getIncremental()) : simProperty.getValue();
            }
            this.setPropertyValue(cIMProperty, object);
            vector.add(cIMProperty);
        }
        cIMInstance.setProperties(vector);
        this.setObjectPath(cIMInstance, simClass.getNamespace());
        return cIMInstance;
    }

    private String handleMultipleValueProperty(SimProperty simProperty, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (simProperty instanceof SimPropertyPreSuf) {
            stringBuffer.append(((SimPropertyPreSuf)simProperty).getPrefix());
        }
        List list = simProperty.getValues();
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Object e = list.get(i);
            if (e instanceof SimValue) {
                stringBuffer.append(((SimValue)e).getPrefix());
                if (((SimValue)e).isCurrentDate()) {
                    stringBuffer.append(new Long(System.currentTimeMillis()));
                } else if (((SimValue)e).isConfiguration()) {
                    stringBuffer.append(ExpressionParser.parseConfExp(this.confProperties, ((SimValue)e).getValue()));
                } else if (((SimValue)e).isConfProp()) {
                    stringBuffer.append(this.confProperties.getProperty(((SimValue)e).getValue()));
                } else if (((SimValue)e).isIncremental()) {
                    stringBuffer.append(((SimValue)e).getIncremental() + n);
                }
                stringBuffer.append(((SimValue)e).getSuffix());
                continue;
            }
            if (simProperty.isRandom()) {
                if (i == 0) continue;
                stringBuffer.append(((SimRandomProperty)simProperty).getSeperator());
                stringBuffer.append(IDGenerator.getRandomKey((String)e));
                continue;
            }
            stringBuffer.append(list.get(n));
            break;
        }
        if (simProperty instanceof SimPropertyPreSuf) {
            stringBuffer.append(((SimPropertyPreSuf)simProperty).getSuffix());
        }
        return stringBuffer.toString();
    }

    private void setPropertyValue(CIMProperty cIMProperty, Object object) {
        if (null != object) {
            if (cIMProperty.getType().isArrayType()) {
                Vector<Object> vector = new Vector<Object>();
                String[] stringArray = object.toString().split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (cIMProperty.getType().toString().equals("uint8") || cIMProperty.getType().equals((Object)"uint8[]")) {
                        try {
                            vector.add(new UnsignedInt8(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    } else if (cIMProperty.getType().toString().equals("uint16") || cIMProperty.getType().equals((Object)"uint16[]")) {
                        try {
                            vector.add(new UnsignedInt16(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    } else if (cIMProperty.getType().toString().equals("uint32") || cIMProperty.getType().equals((Object)"uint32[]")) {
                        try {
                            vector.add(new UnsignedInt32(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    } else if (cIMProperty.getType().toString().equals("uint64") || cIMProperty.getType().equals((Object)"uint64[]")) {
                        try {
                            vector.add(new UnsignedInt64(stringArray[i]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    } else if (cIMProperty.getType().toString().equals("boolean") || cIMProperty.getType().toString().equals("boolean[]")) {
                        vector.add(new Boolean(stringArray[i]));
                        continue;
                    }
                    vector.add(stringArray[i]);
                }
                cIMProperty.setValue(new CIMValue(vector));
            } else {
                Object object2 = null;
                if (object instanceof SimValue) {
                    if (((SimValue)object).isCurrentDate()) {
                        object2 = new Long(System.currentTimeMillis());
                    } else if (((SimValue)object).isConfiguration()) {
                        object2 = new Integer(ExpressionParser.parseConfExp(this.confProperties, ((SimValue)object).getValue()));
                    } else if (((SimValue)object).isConfProp()) {
                        object2 = this.confProperties.getProperty(((SimValue)object).getValue());
                        object2 = SimProperty.getTypedValue(object2, cIMProperty.getType().toString());
                    }
                } else {
                    object2 = object;
                }
                cIMProperty.setValue(new CIMValue(object2));
            }
        }
    }

    private String getReferProperty(SimProperty simProperty, Vector vector) {
        String string;
        if (simProperty.isMultiple()) {
            List list = simProperty.getValues();
            Iterator iterator = list.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                SimValue simValue = (SimValue)iterator.next();
                String string2 = simValue.getValue();
                stringBuffer.append(simValue.getPrefix());
                stringBuffer.append(this.getPropertyValue(vector, string2));
                stringBuffer.append(simValue.getSuffix());
            }
            string = stringBuffer.toString();
        } else {
            String string3 = ((SimReferProperty)simProperty).getRefersProperty();
            string = ((SimPropertyPreSuf)simProperty).getPrefix() + this.getPropertyValue(vector, string3) + ((SimPropertyPreSuf)simProperty).getSuffix();
        }
        return string;
    }

    private String getExternalReferProperty(SimProperty simProperty, Map map, Vector vector, int n) {
        String string = null;
        if (simProperty.isMultiple()) {
            List list = simProperty.getValues();
            Iterator iterator = list.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                SimValue simValue = (SimValue)iterator.next();
                stringBuffer.append(simValue.getPrefix());
                if (simValue.isExternal()) {
                    if (simProperty.isRandom()) {
                        stringBuffer.append(this.getExternalPropertyValue(simValue.getExternal(), simValue.getValue(), map, -1));
                    } else {
                        stringBuffer.append(this.getExternalPropertyValue(simValue.getExternal(), simValue.getValue(), map, n));
                    }
                } else {
                    stringBuffer.append(this.getPropertyValue(vector, simValue.getValue()));
                }
                stringBuffer.append(simValue.getSuffix());
            }
            string = stringBuffer.toString();
        } else {
            String string2 = ((SimReferProperty)simProperty).getRefersProperty();
            String string3 = ((SimReferProperty)simProperty).getExternalClassName();
            Object object = simProperty.isRandom() ? this.getExternalPropertyValue(string3, string2, map, -1) : this.getExternalPropertyValue(string3, string2, map, n);
            string = ((SimPropertyPreSuf)simProperty).getPrefix() + object + ((SimPropertyPreSuf)simProperty).getSuffix();
        }
        return string;
    }

    private Object getPropertyValue(Vector vector, String string) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.get(i);
            if (!cIMProperty.getName().equals(string)) continue;
            Object object = cIMProperty.getValue().getValue();
            return object;
        }
        return null;
    }

    private Object getExternalPropertyValue(String string, String string2, Map map, int n) {
        CIMProperty cIMProperty;
        Object v = map.get(this.namespace + ":" + string);
        if (v instanceof CIMInstance) {
            cIMProperty = ((CIMInstance)v).getProperty(string2);
        } else if (n == -1) {
            int n2 = new Random().nextInt(((List)v).size());
            cIMProperty = ((CIMInstance)((List)v).get(n2)).getProperty(string2);
        } else {
            cIMProperty = ((CIMInstance)((List)v).get(n)).getProperty(string2);
        }
        return cIMProperty.getValue().getValue();
    }

    private void setObjectPath(CIMInstance cIMInstance, String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        cIMObjectPath.setObjectName(cIMInstance.getClassName());
        cIMObjectPath.setNameSpace(string);
        cIMObjectPath.setKeys(cIMInstance.getKeys());
        cIMInstance.setObjectPath(cIMObjectPath);
    }

    private CIMObjectPath getObjectPath(CIMInstance cIMInstance, String string) {
        CIMObjectPath cIMObjectPath = null;
        if (cIMInstance != null) {
            cIMObjectPath = cIMInstance.getObjectPath();
            cIMObjectPath.setNameSpace(string);
            cIMObjectPath.setKeys(cIMInstance.getKeys());
        }
        return cIMObjectPath;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Properties getConfProperties() {
        return this.confProperties;
    }

    public void setConfProperties(Properties properties) {
        this.confProperties = properties;
    }

    public CIMInstance createDefaultInstance(SimClass simClass) {
        CIMInstance cIMInstance = new CIMInstance();
        cIMInstance.setName(simClass.getName());
        cIMInstance.setClassName(simClass.getName());
        Iterator iterator = simClass.getProperties().iterator();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        while (iterator.hasNext()) {
            SimProperty simProperty = (SimProperty)iterator.next();
            CIMProperty cIMProperty = new CIMProperty(simProperty.getName());
            cIMProperty.setName(simProperty.getName());
            cIMProperty.setType(simProperty.getCIMDataType());
            cIMProperty.setKey(simProperty.isKey());
            Object object = null;
            if (simProperty.isRandom() && !simProperty.isRefer()) {
                object = IDGenerator.getRandomKey(simProperty);
                object = SimProperty.getTypedValue(object, simProperty.getDataType());
            } else {
                object = simProperty.isIncremental() ? new Integer(simProperty.getIncremental()) : simProperty.getValue();
            }
            this.setPropertyValue(cIMProperty, object);
            vector.add(cIMProperty);
        }
        cIMInstance.setProperties(vector);
        this.setObjectPath(cIMInstance, simClass.getNamespace());
        return cIMInstance;
    }
}

