/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.util.ArrayList;
import java.util.List;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import org.eclipse.aperi.simulator.cimom.common.generator.SimValue;

public class SimProperty {
    private String name;
    private String dataType;
    private Object value;
    private List values;
    private boolean isRandom;
    private boolean isMultiple;
    private boolean isKey;
    private boolean isRefer;
    private int incremental = -1;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public Object getValue() {
        if (null != this.value && !(this.value instanceof SimValue)) {
            return SimProperty.getTypedValue(this.value, this.dataType);
        }
        return this.value;
    }

    public List getValues() {
        return this.values;
    }

    public Object getValues(int n) {
        Object object = this.values.get(n);
        if (null != object) {
            object = SimProperty.getTypedValue(object, this.dataType);
        }
        return object;
    }

    public static Object getTypedValue(Object object, String string) {
        if (string.equals("uint8") || string.equals("uint8[]")) {
            UnsignedInt8 unsignedInt8;
            try {
                unsignedInt8 = new UnsignedInt8((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            return unsignedInt8;
        }
        if (string.equals("uint16") || string.equals("uint16[]")) {
            UnsignedInt16 unsignedInt16;
            try {
                unsignedInt16 = new UnsignedInt16((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            return unsignedInt16;
        }
        if (string.equals("uint32") || string.equals("uint32[]")) {
            UnsignedInt32 unsignedInt32;
            try {
                unsignedInt32 = new UnsignedInt32((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return object;
            }
            return unsignedInt32;
        }
        if (string.equals("uint64") || string.equals("uint64[]")) {
            UnsignedInt64 unsignedInt64;
            try {
                unsignedInt64 = new UnsignedInt64((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                return object;
            }
            return unsignedInt64;
        }
        if (string.equals("boolean") || string.equals("boolean[]")) {
            Boolean bl = new Boolean((String)object);
            return bl;
        }
        return object;
    }

    public void setValues(List list) {
        this.values = list;
    }

    public void addValue(Object object) {
        if (null == this.values) {
            this.values = new ArrayList();
        }
        this.values.add(object);
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public void setRandom(boolean bl) {
        this.isRandom = bl;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public void setMultiple(boolean bl) {
        this.isMultiple = bl;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean bl) {
        this.isKey = bl;
    }

    public boolean isRefer() {
        return this.isRefer;
    }

    public void setRefer(boolean bl) {
        this.isRefer = bl;
    }

    public int getIncremental() {
        return this.incremental;
    }

    public void setIncremental(int n) {
        this.incremental = n;
    }

    public boolean isIncremental() {
        return this.incremental > -1;
    }

    public CIMDataType getCIMDataType() {
        if (this.dataType.equalsIgnoreCase("string")) {
            return new CIMDataType(8);
        }
        if (this.dataType.equalsIgnoreCase("REF")) {
            return new CIMDataType(28);
        }
        if (this.dataType.equalsIgnoreCase("uint8")) {
            return new CIMDataType(0);
        }
        if (this.dataType.equalsIgnoreCase("uint16")) {
            return new CIMDataType(2);
        }
        if (this.dataType.equalsIgnoreCase("uint32")) {
            return new CIMDataType(4);
        }
        if (this.dataType.equalsIgnoreCase("uint64")) {
            return new CIMDataType(6);
        }
        if (this.dataType.equalsIgnoreCase("sint8")) {
            return new CIMDataType(1);
        }
        if (this.dataType.equalsIgnoreCase("sint16")) {
            return new CIMDataType(3);
        }
        if (this.dataType.equalsIgnoreCase("sint32")) {
            return new CIMDataType(5);
        }
        if (this.dataType.equalsIgnoreCase("sint64")) {
            return new CIMDataType(7);
        }
        if (this.dataType.equalsIgnoreCase("real32")) {
            return new CIMDataType(10);
        }
        if (this.dataType.equalsIgnoreCase("real64")) {
            return new CIMDataType(11);
        }
        if (this.dataType.equalsIgnoreCase("boolean")) {
            return new CIMDataType(9);
        }
        if (this.dataType.equalsIgnoreCase("datetime")) {
            return new CIMDataType(12);
        }
        if (this.dataType.equalsIgnoreCase("string[]")) {
            return new CIMDataType(22);
        }
        if (this.dataType.equalsIgnoreCase("REF[]")) {
            return new CIMDataType(42);
        }
        if (this.dataType.equalsIgnoreCase("uint8[]")) {
            return new CIMDataType(14);
        }
        if (this.dataType.equalsIgnoreCase("uint16[]")) {
            return new CIMDataType(16);
        }
        if (this.dataType.equalsIgnoreCase("uint32[]")) {
            return new CIMDataType(18);
        }
        if (this.dataType.equalsIgnoreCase("uint64[]")) {
            return new CIMDataType(20);
        }
        if (this.dataType.equalsIgnoreCase("sint8[]")) {
            return new CIMDataType(15);
        }
        if (this.dataType.equalsIgnoreCase("sint16[]")) {
            return new CIMDataType(17);
        }
        if (this.dataType.equalsIgnoreCase("sint32[]")) {
            return new CIMDataType(19);
        }
        if (this.dataType.equalsIgnoreCase("sint64[]")) {
            return new CIMDataType(21);
        }
        if (this.dataType.equalsIgnoreCase("real32[]")) {
            return new CIMDataType(24);
        }
        if (this.dataType.equalsIgnoreCase("real64[]")) {
            return new CIMDataType(25);
        }
        if (this.dataType.equalsIgnoreCase("boolean[]")) {
            return new CIMDataType(23);
        }
        if (this.dataType.equalsIgnoreCase("datetime[]")) {
            return new CIMDataType(26);
        }
        return null;
    }
}

