/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionConfig;
import org.eclipse.aperi.simulator.cimom.connection.SourceConnection;
import org.eclipse.aperi.simulator.cimom.connection.SourceDBConnection;
import org.eclipse.aperi.simulator.cimom.connection.TargetCIMConnection;
import org.eclipse.aperi.simulator.cimom.connection.TargetConnection;
import org.eclipse.aperi.simulator.cimom.connection.TargetDBConnection;

public class ConnectionDataGenerator {
    private static final String CONFIG_FILE = "resources/ConnectionSimulation.Properties";
    private static final String BROCADE_CONNECT_XML = "XML/Connectivity.Switch/ConnectivityClasses.xml";
    private static final String NAMESPACE_ROOT_BROCADE1 = "/root/brocade1";
    private DeviceDataGenerator dataGenerator;
    private DataGeneratorResponse response;
    private SourceConnection switchClient;
    private TargetConnection targetDevcieClient;
    private CIMValue sourceFabricName;

    private void persistData(DataGeneratorResponse dataGeneratorResponse) throws Exception {
        String string = NAMESPACE_ROOT_BROCADE1;
        int n = DatabaseManager.getDbManager().getNamespaceID(string);
        Map map = this.dataGenerator.getParserResponse().getClassMap();
        DatabaseManager.getDbManager().persistInstances(n, dataGeneratorResponse.getInstanceMap(), map);
        System.out.println("Connection Data Stored");
    }

    public void generateData() throws IOException, Exception {
        this.dataGenerator = new DeviceDataGenerator(BROCADE_CONNECT_XML, CONFIG_FILE);
        ConnectionConfig.loadProperties();
        this.sourceFabricName = new CIMValue((Object)ConnectionConfig.getProperty("SOURCE_FABRIC_ID"));
        this.switchClient = new SourceDBConnection();
        this.switchClient.init();
        if (ConnectionConfig.getProperty("SWITCH_CONNECTED_TO").equals("Switch")) {
            this.connectSwitchToSwitch();
        }
        if (ConnectionConfig.getProperty("SWITCH_CONNECTED_TO").equals("Storage")) {
            if (ConnectionConfig.getProperty("TARGET_DEVICE_CLIENT").equals("CIM Client")) {
                this.targetDevcieClient = new TargetCIMConnection();
            } else if (ConnectionConfig.getProperty("TARGET_DEVICE_CLIENT").equals("DB Client")) {
                this.targetDevcieClient = new TargetDBConnection();
            }
            this.connectSwitchToStorage();
        } else if (ConnectionConfig.getProperty("SWITCH_CONNECTED_TO").equals("Host")) {
            this.connectSwitchToHost();
        }
        ConnectionConfig.closeProperties();
    }

    private void connectSwitchToHost() throws Exception {
    }

    private void connectSwitchToSwitch() throws Exception {
        CIMInstance cIMInstance;
        this.response = this.dataGenerator.generateData(NAMESPACE_ROOT_BROCADE1);
        String string = this.dataGenerator.getConfProperties().getProperty("PORT_CONNECTIVITY");
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length) {
            cIMInstance = stringArray[n].split(":");
            stringArray2[n2] = cIMInstance[0].substring(cIMInstance[0].indexOf("(") + 1, cIMInstance[0].indexOf(")"));
            stringArray3[n2] = cIMInstance[1].substring(cIMInstance[1].indexOf("(") + 1, cIMInstance[1].indexOf(")"));
            ++n;
            ++n2;
        }
        CIMInstance cIMInstance2 = this.switchClient.getInstance("Brocade_Fabric", "Name", this.sourceFabricName);
        String string2 = "/root/brocade1:Brocade_Fabric";
        this.response.addInstances(string2, cIMInstance2);
        cIMInstance = this.switchClient.getInstance("Brocade_LogicalNetwork", "InstanceID", this.sourceFabricName);
        String string3 = "/root/brocade1:Brocade_LogicalNetwork";
        this.response.addInstances(string3, cIMInstance);
        SimClass simClass = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get("Brocade_SANActiveConnection");
        for (int i = 0; i < stringArray.length; ++i) {
            CIMValue cIMValue = new CIMValue((Object)stringArray2[i]);
            if (cIMValue == null) {
                System.out.println("Specified Port Number Does not exist !");
                System.exit(0);
            }
            CIMInstance cIMInstance3 = this.switchClient.getInstance("Brocade_SwitchFCPort", "DeviceID", cIMValue);
            CIMInstance cIMInstance4 = this.createSANPEndPoint("Switch", cIMInstance3);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANProtocolEndPoint", cIMInstance4);
            this.createAssociationInst(this.response, "Brocade_FabricHostedSANAccessPoint", cIMInstance2, cIMInstance4);
            this.createAssociationInst(this.response, "Brocade_FCPortSANProtocolEndPoint", cIMInstance3, cIMInstance4);
            this.createAssociationInst(this.response, "Brocade_InLogicalNetwork", cIMInstance, cIMInstance4);
            CIMValue cIMValue2 = new CIMValue((Object)stringArray3[i]);
            if (cIMValue2 == null) {
                System.out.println("Specified Port Number Does not exist !");
                System.exit(0);
            }
            cIMInstance3 = this.switchClient.getInstance("Brocade_SwitchFCPort", "DeviceID", cIMValue2);
            CIMInstance cIMInstance5 = this.createSANPEndPoint("Switch", cIMInstance3);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANProtocolEndPoint", cIMInstance5);
            this.createAssociationInst(this.response, "Brocade_FabricHostedSANAccessPoint", cIMInstance2, cIMInstance5);
            this.createAssociationInst(this.response, "Brocade_FCPortSANProtocolEndPoint", cIMInstance3, cIMInstance5);
            this.createAssociationInst(this.response, "Brocade_InLogicalNetwork", cIMInstance, cIMInstance5);
            CIMInstance cIMInstance6 = this.dataGenerator.getCreator().createAssociationInstance(simClass, cIMInstance4, cIMInstance5);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANActiveConnection", cIMInstance6);
        }
        this.response.getInstanceMap().remove("/root/brocade1:Brocade_Fabric");
        this.response.getInstanceMap().remove("/root/brocade1:Brocade_LogicalNetwork");
        this.printInstanceMap(this.response);
        this.persistData(this.response);
    }

    private void connectSwitchToStorage() throws Exception, IOException {
        CIMInstance cIMInstance;
        CIMValue cIMValue;
        CIMInstance cIMInstance2;
        Object object;
        CIMValue cIMValue2;
        int n;
        CIMInstance cIMInstance3;
        this.targetDevcieClient.init();
        this.response = this.dataGenerator.generateData(NAMESPACE_ROOT_BROCADE1);
        Properties properties = new Properties();
        properties.load(new FileInputStream(CONFIG_FILE));
        String string = this.dataGenerator.getConfProperties().getProperty("PORT_CONNECTIVITY");
        String[] stringArray = string.split(",");
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < stringArray.length) {
            cIMInstance3 = stringArray[n3].split(":");
            stringArray2[n4] = cIMInstance3[0].substring(cIMInstance3[0].indexOf("(") + 1, cIMInstance3[0].indexOf(")"));
            stringArray3[n4] = cIMInstance3[1].substring(cIMInstance3[1].indexOf("(") + 1, cIMInstance3[1].indexOf(")"));
            ++n3;
            ++n4;
        }
        CIMInstance cIMInstance4 = this.switchClient.getInstance("Brocade_Fabric", "Name", this.sourceFabricName);
        String string2 = "/root/brocade1:Brocade_Fabric";
        this.response.addInstances(string2, cIMInstance4);
        cIMInstance3 = this.switchClient.getInstance("Brocade_LogicalNetwork", "InstanceID", this.sourceFabricName);
        String string3 = "/root/brocade1:Brocade_LogicalNetwork";
        this.response.addInstances(string3, cIMInstance3);
        SimClass simClass = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get("Brocade_Node");
        CIMInstance cIMInstance5 = this.dataGenerator.getCreator().createDefaultInstance(simClass);
        cIMInstance5.getProperty("Name").setValue(cIMInstance5.getProperty("InstanceID").getValue());
        this.addInstancesToResponse(this.response, simClass.getName(), cIMInstance5);
        this.createAssociationInst(this.response, "Brocade_NodeInFabric", cIMInstance4, cIMInstance5);
        for (n = 0; n < n2; ++n) {
            cIMValue2 = new CIMValue((Object)stringArray2[n]);
            if (cIMValue2 == null) {
                System.out.println("Specified Port Number Does not exist !");
                System.exit(0);
            }
            object = this.switchClient.getInstance("Brocade_SwitchFCPort", "DeviceID", cIMValue2);
            cIMInstance2 = this.createSANPEndPoint("Switch", (CIMInstance)object);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANProtocolEndPoint", cIMInstance2);
            this.createAssociationInst(this.response, "Brocade_FabricHostedSANAccessPoint", cIMInstance4, cIMInstance2);
            this.createAssociationInst(this.response, "Brocade_FCPortSANProtocolEndPoint", (CIMInstance)object, cIMInstance2);
            this.createAssociationInst(this.response, "Brocade_InLogicalNetwork", cIMInstance3, cIMInstance2);
        }
        for (n = 0; n < n2; ++n) {
            cIMValue2 = new CIMValue((Object)stringArray3[n]);
            if (cIMValue2 == null) {
                System.out.println("Specified Port Number Does not exist !");
                System.exit(0);
            }
            object = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get("Brocade_NodeFCPort");
            cIMInstance2 = this.dataGenerator.getCreator().createDefaultInstance((SimClass)object);
            cIMInstance2.getProperty("DeviceID").setValue(cIMValue2);
            cIMInstance2.getObjectPath().getKey("DeviceID").setValue(cIMInstance2.getProperty("DeviceID").getValue());
            cIMValue = cIMInstance5.getProperty("Name").getValue();
            cIMInstance2.getProperty("SystemName").setValue(cIMValue);
            cIMInstance2.getObjectPath().getKey("SystemName").setValue(cIMInstance2.getProperty("SystemName").getValue());
            cIMInstance2.getProperty("PermanentAddress").setValue(cIMInstance2.getProperty("DeviceID").getValue());
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_NodeFCPort", cIMInstance2);
            this.createAssociationInst(this.response, "Brocade_PortInNode", cIMInstance5, cIMInstance2);
            this.createAssociationInst(this.response, "Brocade_NodePortInFabric", cIMInstance4, cIMInstance2);
            cIMInstance = this.createSANPEndPoint("Storage", cIMInstance2);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANProtocolEndPoint", cIMInstance);
            this.createAssociationInst(this.response, "Brocade_FabricHostedSANAccessPoint", cIMInstance4, cIMInstance);
            this.createAssociationInst(this.response, "Brocade_FCPortSANProtocolEndPoint", cIMInstance2, cIMInstance);
            this.createAssociationInst(this.response, "Brocade_InLogicalNetwork", cIMInstance3, cIMInstance);
        }
        this.response.getInstanceMap().remove("/root/brocade1:Brocade_Fabric");
        this.response.getInstanceMap().remove("/root/brocade1:Brocade_LogicalNetwork");
        SimClass simClass2 = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get("Brocade_SANActiveConnection");
        for (int i = 0; i < stringArray.length; ++i) {
            cIMValue2 = new CIMValue((Object)stringArray2[i]);
            object = new CIMValue((Object)stringArray3[i]);
            cIMValue = this.getInstanceFromMap("Brocade_SANProtocolEndPoint", "Name", cIMValue2);
            cIMInstance = this.getInstanceFromMap("Brocade_SANProtocolEndPoint", "Name", (CIMValue)object);
            CIMInstance cIMInstance6 = this.dataGenerator.getCreator().createAssociationInstance(simClass2, (CIMInstance)cIMValue, cIMInstance);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANActiveConnection", cIMInstance6);
        }
        this.printInstanceMap(this.response);
        this.persistData(this.response);
    }

    private void printInstanceMap(DataGeneratorResponse dataGeneratorResponse) {
        Set set = dataGeneratorResponse.getInstanceMap().keySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            String string = (String)iterator.next();
            System.out.println("CIM Class: " + dataGeneratorResponse.getInstanceMap().get(string));
        }
    }

    private void createAssociationInst(DataGeneratorResponse dataGeneratorResponse, String string, CIMInstance cIMInstance, CIMInstance cIMInstance2) {
        SimClass simClass = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get(string);
        CIMInstance cIMInstance3 = this.dataGenerator.getCreator().createAssociationInstance(simClass, cIMInstance, cIMInstance2);
        this.addInstancesToResponse(dataGeneratorResponse, "/root/brocade1:" + string, cIMInstance3);
    }

    private CIMInstance createSANPEndPoint(String string, CIMInstance cIMInstance) throws CIMException {
        String string2 = "Brocade_SANProtocolEndPoint";
        CIMValue cIMValue = cIMInstance.getProperty("DeviceID").getValue();
        CIMValue cIMValue2 = cIMInstance.getProperty("SystemName").getValue();
        SimClass simClass = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get(string2);
        CIMInstance cIMInstance2 = this.dataGenerator.getCreator().createDefaultInstance(simClass);
        cIMInstance2.getProperty("Name").setValue(cIMValue);
        cIMInstance2.getObjectPath().getKey("Name").setValue(cIMInstance2.getProperty("Name").getValue());
        cIMInstance2.getProperty("SystemName").setValue(cIMValue2);
        cIMInstance2.getObjectPath().getKey("SystemName").setValue(cIMInstance2.getProperty("SystemName").getValue());
        if (string.equalsIgnoreCase("Switch")) {
            cIMInstance2.getProperty("SystemCreationClassName").setValue(new CIMValue((Object)"Brocade_Switch"));
        } else if (string.equalsIgnoreCase("Storage")) {
            cIMInstance2.getProperty("SystemCreationClassName").setValue(new CIMValue((Object)"Brocade_Node"));
        }
        cIMInstance2.getObjectPath().getKey("SystemCreationClassName").setValue(cIMInstance2.getProperty("SystemCreationClassName").getValue());
        return cIMInstance2;
    }

    private CIMInstance getInstanceFromMap(String string, String string2, CIMValue cIMValue) {
        Object v = this.response.getInstanceMap().get("/root/brocade1:" + string);
        if (v instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)v;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                CIMInstance cIMInstance = (CIMInstance)iterator.next();
                CIMValue cIMValue2 = cIMInstance.getProperty(string2).getValue();
                if (!cIMValue2.equals((Object)cIMValue)) continue;
                return cIMInstance;
            }
        } else {
            return (CIMInstance)v;
        }
        return null;
    }

    private void addInstancesToResponse(DataGeneratorResponse dataGeneratorResponse, String string, Object object) {
        Object v = dataGeneratorResponse.getInstanceMap().get(string);
        if (v == null) {
            dataGeneratorResponse.addInstances(string, object);
        } else if (v instanceof List) {
            ((List)v).add(object);
            dataGeneratorResponse.addInstances(string, v);
        } else if (v instanceof CIMInstance) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v);
            arrayList.add(object);
            dataGeneratorResponse.addInstances(string, arrayList);
        }
    }
}

