/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.security.Principal;
import java.util.Enumeration;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.cimom.connection.SourceConnection;

public class SourceCIMConnection
implements SourceConnection {
    private CIMClient cimClient;
    private CIMNameSpace cimNamespace;
    private UserPrincipal principal;
    private PasswordCredential credential;
    private String HostUrl;
    private String NameSpace;
    private String Protocol;
    private String UserName;
    private String PassWord;
    private String Port;

    private void initArguments() {
    }

    public void init() {
        this.connect();
    }

    public void connect() {
        this.initArguments();
        try {
            if (this.HostUrl != null && this.NameSpace != null) {
                try {
                    this.cimNamespace = new CIMNameSpace(this.Protocol + "://" + this.HostUrl + ":" + this.Port, this.NameSpace);
                    if (this.UserName != null) {
                        this.principal = new UserPrincipal(this.UserName);
                    }
                    if (this.PassWord != null) {
                        this.credential = new PasswordCredential(this.PassWord);
                    }
                    this.cimClient = new CIMClient(this.cimNamespace, (Principal)this.principal, (Object)this.credential);
                    System.out.println("CIMOM connection successful");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Unable To Connect to CIMOM [" + this.HostUrl + "]" + exception.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CIMValue getPortWWN(int n, String string) throws Exception {
        CIMValue cIMValue;
        CIMInstance cIMInstance = null;
        boolean bl = false;
        CIMObjectPath cIMObjectPath = new CIMObjectPath("Brocade_SwitchFCPort");
        Enumeration enumeration = this.cimClient.enumerateInstances(cIMObjectPath, true, false, true);
        while (enumeration.hasMoreElements()) {
            CIMValue cIMValue2;
            cIMInstance = (CIMInstance)enumeration.nextElement();
            cIMValue = cIMInstance.getProperty("ElementName").getValue();
            if (!cIMValue.getValue().equals(string) || Integer.parseInt((cIMValue2 = cIMInstance.getProperty("PortNumber").getValue()).toString()) != n) continue;
            bl = true;
            break;
        }
        if (bl) {
            cIMValue = cIMInstance.getProperty("DeviceID").getValue();
            return cIMValue;
        }
        return null;
    }

    public CIMInstance getInstance(String string, String string2, CIMValue cIMValue) throws Exception {
        CIMValue cIMValue2;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
        Enumeration enumeration = this.cimClient.enumerateInstances(cIMObjectPath, true, false, true);
        while (enumeration.hasMoreElements() && !(cIMValue2 = (cIMInstance = (CIMInstance)enumeration.nextElement()).getProperty(string2).getValue()).equals((Object)cIMValue)) {
        }
        return cIMInstance;
    }

    public CIMValue getFabricId(String string) throws Exception {
        CIMObjectPath cIMObjectPath = new CIMObjectPath("Brocade_Switch");
        Enumeration enumeration = this.cimClient.enumerateInstances(cIMObjectPath, true, false, true);
        CIMValue cIMValue = null;
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            if (!cIMInstance.getProperty("ElementName").getValue().getValue().equals(string)) continue;
            cIMValue = cIMInstance.getProperty("Name").getValue();
            break;
        }
        return cIMValue;
    }
}

