/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.security.Principal;
import java.util.Enumeration;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionConfig;
import org.eclipse.aperi.simulator.cimom.connection.TargetConnection;

public class TargetCIMConnection
implements TargetConnection {
    private CIMClient cimClient;
    private String HostUrl;
    private String NameSpace;
    private String Protocol;
    private String UserName;
    private String PassWord;
    private String Port;
    private String deviceType;

    private void initArguments() {
        this.HostUrl = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_URL");
        this.Port = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_PORT");
        this.UserName = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_URL");
        this.PassWord = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_PASSWORD");
        this.NameSpace = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_NAMESPACE");
        this.Protocol = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_PROTOCOL");
        this.connect(this.HostUrl, this.Port, this.NameSpace, this.PassWord, this.NameSpace, this.Protocol);
    }

    public void init() {
        this.initArguments();
        try {
            this.findDevicetype();
            this.connectToCIMClient();
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
    }

    public void connect(String string, String string2, String string3, String string4, String string5, String string6) {
        UserPrincipal userPrincipal = null;
        PasswordCredential passwordCredential = null;
        try {
            if (string != null && string5 != null) {
                try {
                    CIMNameSpace cIMNameSpace = new CIMNameSpace(string6 + "://" + string + ":" + string2, string5);
                    if (string3 != null) {
                        userPrincipal = new UserPrincipal(string3);
                    }
                    if (string4 != null) {
                        passwordCredential = new PasswordCredential(string4);
                    }
                    this.cimClient = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
                    System.out.println("CIMOM connection successful");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Unable To Connect to CIMOM [" + string + "]" + exception.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CIMValue getDeviceID(int n, String string) throws CIMException {
        CIMValue cIMValue;
        CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_FCPort");
        CIMInstance cIMInstance = null;
        boolean bl = false;
        Enumeration enumeration = this.cimClient.enumerateInstances(cIMObjectPath, true, false, true);
        while (enumeration.hasMoreElements()) {
            CIMValue cIMValue2;
            cIMInstance = (CIMInstance)enumeration.nextElement();
            cIMValue = cIMInstance.getProperty("ElementName").getValue();
            if (!cIMValue.getValue().equals(string) || Integer.parseInt((cIMValue2 = cIMInstance.getProperty("PortNumber").getValue()).toString()) != n) continue;
            bl = true;
            break;
        }
        if (bl) {
            cIMValue = cIMInstance.getProperty("DeviceID").getValue();
            return cIMValue;
        }
        return null;
    }

    private void connectToCIMClient() throws CIMException {
        this.cimClient.close();
        if (this.deviceType.equals("DS4K")) {
            this.connect(this.HostUrl, this.Port, this.NameSpace, this.PassWord, "/root/lsissi11", this.Protocol);
        } else if (this.deviceType.equals("DS6K")) {
            this.connect(this.HostUrl, this.Port, this.UserName, this.PassWord, "/root/ibm", this.Protocol);
        }
    }

    private void findDevicetype() throws CIMException {
        this.deviceType = ConnectionConfig.getProperty("STORAGE_DEVICE_CATEGORY");
    }
}

