/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sblim;

import java.security.Principal;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.wbem.cim.CIMObjectPath;
import org.eclipse.aperi.simulator.SimulatorException;
import org.eclipse.aperi.simulator.cimom.common.CIMConverter;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.base.BaseSnapshotMaker;
import org.eclipse.aperi.simulator.cimom.sblim.util.DiscoveryUtil;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.CIMDataBLOB;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;

public class SnapshotMaker
extends BaseSnapshotMaker {
    private CIMClient cimClient;
    private CIMNameSpace cimNamespace;
    private UserPrincipal principal;
    private PasswordCredential credential;

    public SnapshotMaker(CIMOM cIMOM) throws SimulatorException {
        super(cIMOM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Start Snapshot");
        try {
            String string = this.cimom.getServiceURL();
            String string2 = this.cimom.getUserID();
            String string3 = this.cimom.getPassword();
            String string4 = this.cimom.getNamespace();
            if (string != null && string4 != null) {
                try {
                    this.cimNamespace = new CIMNameSpace(string, string4);
                    if (string2 != null) {
                        this.principal = new UserPrincipal(string2);
                    }
                    if (string3 != null) {
                        this.credential = new PasswordCredential(string3.toCharArray());
                    }
                    this.cimClient = new CIMClient(this.cimNamespace, (Principal)this.principal, (Object)this.credential);
                }
                catch (Exception exception) {
                    System.out.println("Unable To Connect to CIMOM [" + string + "]" + exception.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
            string4 = SimulatorUtility.fixNamespaceSlashIssue(string4);
            this.insert_CIMOM_INFO(this.cimom.getCimomVendorType(), this.cimom.getCimomVendor(), string, string4, string2, string3);
            int n = this.getMaxID("SIM.CIMOM_INFO");
            ArrayList arrayList = new ArrayList();
            arrayList.add(string4);
            arrayList = DiscoveryUtil.getNamespaces(this.cimClient, arrayList, this.cimom.getCimomType());
            for (int i = 0; i < arrayList.size(); ++i) {
                String string5 = (String)arrayList.get(i);
                string5 = SimulatorUtility.fixNamespaceSlashIssue(string5);
                this.insert_NS_INFO(n, string5);
                int n2 = this.getMaxID("SIM.NS_INFO");
                this.snapshotClasses(string5, n2);
            }
            if (this.cimClient != null) {
                this.cimClient.close();
            }
            this.cimClient = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.cimClient != null) {
                    this.cimClient.close();
                }
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.cimClient = null;
            this.con = null;
        }
    }

    private synchronized void insert_CIM_DATA(int n, CIMInstance cIMInstance) throws Exception {
        javax.wbem.cim.CIMInstance cIMInstance2 = CIMConverter.convertInstanceWBEMStyle(cIMInstance);
        org.sblim.wbem.cim.CIMObjectPath cIMObjectPath = cIMInstance.getObjectPath();
        CIMObjectPath cIMObjectPath2 = CIMConverter.convertCIMOPWBEMStyle(cIMObjectPath);
        cIMObjectPath2.setHost(cIMObjectPath.getHost());
        cIMObjectPath2.setNameSpace(cIMObjectPath.getNameSpace());
        CIMDataBLOB cIMDataBLOB = new CIMDataBLOB(cIMInstance2);
        int n2 = (int)cIMDataBLOB.length();
        CIMDataBLOB cIMDataBLOB2 = new CIMDataBLOB(cIMObjectPath2);
        int n3 = (int)cIMDataBLOB2.length();
        String string = "INSERT INTO SIM.CIM_DATA (CIM_CLASS_ID, CIM_OP, CIM_INST) VALUES (?, ?, ?)";
        PreparedStatement preparedStatement = this.con.prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.setBinaryStream(2, cIMDataBLOB2.getBinaryStream(), n3);
        preparedStatement.setBinaryStream(3, cIMDataBLOB.getBinaryStream(), n2);
        preparedStatement.executeUpdate();
        this.con.commit();
        preparedStatement.close();
    }

    protected synchronized void snapshotClasses(String string, int n) throws Exception {
        this.cimClient = null;
        this.cimNamespace = null;
        this.cimNamespace = new CIMNameSpace(this.cimom.getServiceURL(), string);
        this.cimClient = new CIMClient(this.cimNamespace, (Principal)new UserPrincipal(this.cimom.getUserID()), (Object)new PasswordCredential(this.cimom.getPassword().toCharArray()));
        org.sblim.wbem.cim.CIMObjectPath cIMObjectPath = new org.sblim.wbem.cim.CIMObjectPath();
        Enumeration enumeration = this.cimClient.enumerateClasses(cIMObjectPath, true, false, false, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            CIMClass cIMClass = (CIMClass)enumeration.nextElement();
            arrayList.add(cIMClass.getName());
        }
        enumeration = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2;
            int n2;
            String string3 = (String)arrayList.get(i);
            ArrayList arrayList2 = this.cimom.getLeafClassNamePrefixes();
            boolean bl = false;
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                string2 = (String)arrayList2.get(n2);
                if (!string3.startsWith(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            try {
                this.insert_CIM_CLASS(n, (String)arrayList.get(i));
                n2 = this.getMaxID("SIM.CIM_CLASS");
                string2 = new org.sblim.wbem.cim.CIMObjectPath((String)arrayList.get(i));
                Enumeration enumeration2 = this.cimClient.enumerateInstances((org.sblim.wbem.cim.CIMObjectPath)string2, true, false, false, true, null);
                while (enumeration2.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration2.nextElement();
                    this.insert_CIM_DATA(n2, cIMInstance);
                    System.out.println("NS = [" + string + "], CLS = [" + (String)arrayList.get(i) + "]");
                }
                enumeration2 = null;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.cimClient.close();
        this.cimClient = null;
    }
}

