/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sblim.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.base.BaseMOFGenerator;
import org.eclipse.aperi.simulator.cimom.sblim.util.DiscoveryUtil;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;

public class MOFGenerator
extends BaseMOFGenerator {
    private UserPrincipal principal;
    private PasswordCredential credential;
    private CIMClient cimClient;

    public MOFGenerator(CIMOM cIMOM) {
        super(cIMOM);
    }

    public void generateDataForNameSpace(String string, String string2) throws Exception {
        this.cimClient = null;
        CIMNameSpace cIMNameSpace = new CIMNameSpace(this.cimom.getServiceURL(), string);
        this.cimClient = new CIMClient(cIMNameSpace, (Principal)this.principal, (Object)this.credential);
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        Enumeration enumeration = this.cimClient.enumerateClasses(cIMObjectPath, true, false, false, true);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        block0: while (enumeration.hasMoreElements()) {
            CIMClass cIMClass = (CIMClass)enumeration.nextElement();
            String string3 = cIMClass.getName();
            if (arrayList.contains(string3)) continue;
            if (this.isOnlyLeaf) {
                Iterator iterator = this.cimom.getLeafClassNamePrefixes().iterator();
                while (iterator.hasNext()) {
                    if (!string3.startsWith((String)iterator.next())) continue;
                    this.addClassWithReferences(arrayList, cIMClass, arrayList2);
                    continue block0;
                }
                continue;
            }
            this.addClassWithReferences(arrayList, cIMClass, arrayList2);
        }
        this.printData(string, string2, arrayList, arrayList2);
        this.cimClient.close();
        this.cimClient = null;
    }

    private void printData(String string, String string2, List list, List list2) throws IOException {
        CIMClass cIMClass = new CIMClass();
        String string3 = this.createNewWriter(string, string2);
        System.out.println("File created for namespace : " + string + " is : " + string3);
        this.writeDataToFile("#pragma namespace (\"" + string + "\")");
        this.writeDataToFile("#pragma Locale (\"en-US\")");
        HashMap hashMap = this.getQualifierDatatype();
        this.printQualifierData(list2, hashMap);
        CIMObjectPath cIMObjectPath = null;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                cIMObjectPath = new CIMObjectPath((String)list.get(i));
                cIMClass = this.cimClient.getClass(cIMObjectPath);
                this.doAdditionalChanges(cIMClass);
                this.writeDataToFile("// " + cIMClass.getName());
                this.writeDataToFile(cIMClass.toString());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error for class " + cIMObjectPath);
                this.writeDataToFile("// " + cIMClass.getName());
                this.writeDataToFile(cIMClass.toString());
                System.out.println(exception.getMessage());
            }
        }
        this.closeFile();
    }

    private void doAdditionalChanges(CIMClass cIMClass) {
        Object object;
        Object object2;
        Object object3;
        Cloneable cloneable;
        CIMMethod cIMMethod;
        CIMQualifier cIMQualifier;
        String string = cIMClass.getName();
        Vector vector = cIMClass.getQualifiers();
        Vector<CIMQualifier> vector2 = new Vector<CIMQualifier>();
        Iterator iterator = vector.iterator();
        int n = 0;
        Iterator iterator2 = this.cimom.getLeafClassNamePrefixes().iterator();
        while (iterator2.hasNext()) {
            if (!string.startsWith((String)iterator2.next())) continue;
            cIMQualifier = new CIMQualifier("Provider");
            cIMQualifier.setValue(new CIMValue((Object)"java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider", new CIMDataType(8)));
            vector2.add(n++, cIMQualifier);
        }
        while (iterator.hasNext()) {
            cIMQualifier = (CIMQualifier)iterator.next();
            vector2.add(n++, cIMQualifier);
        }
        cIMClass.setQualifiers(vector2);
        cIMQualifier = new CIMClass();
        cIMQualifier.setName(cIMClass.getName());
        cIMQualifier.setObjectPath(cIMClass.getObjectPath());
        cIMQualifier.setProperties(cIMClass.getProperties());
        cIMQualifier.setQualifiers(cIMClass.getQualifiers());
        cIMQualifier.setIsAssociation(cIMClass.isAssociation());
        cIMQualifier.setSuperClass(cIMClass.getSuperClass());
        Vector vector3 = cIMClass.getAllMethods();
        for (int i = 0; i < vector3.size(); ++i) {
            cIMMethod = (CIMMethod)vector3.get(i);
            cloneable = cIMMethod.getParameters();
            for (int j = 0; j < ((Vector)cloneable).size(); ++j) {
                object3 = (CIMParameter)((Vector)cloneable).get(j);
                object2 = object3.getType().toString();
                if (!((String)object2).contains("[] ref")) continue;
                object = new CIMDataType(object3.getType().toString().replace("[] ref", ""));
                object3.setType((CIMDataType)object);
                object3.setName(object3.getName() + "[]");
            }
            cIMQualifier.addMethod(cIMMethod);
        }
        cIMClass.equals((Object)cIMQualifier);
        Vector vector4 = cIMClass.getAllProperties();
        iterator = vector4.iterator();
        while (iterator.hasNext()) {
            cIMMethod = (CIMProperty)iterator.next();
            if (cIMMethod.getType().getStringType().equalsIgnoreCase("datetime")) {
                cIMMethod.setValue(null);
                continue;
            }
            if (!cIMMethod.isReference()) continue;
            cIMMethod.setValue(null);
        }
        cloneable = new Properties();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            ((Properties)cloneable).load(new FileInputStream("conf/remove_override.txt"));
            object3 = ((Properties)cloneable).keySet();
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                arrayList.add(object2);
            }
            if (arrayList.contains(cIMClass.getName())) {
                object2 = ((Properties)cloneable).getProperty(cIMClass.getName());
                object = ((String)object2).split(",");
                for (int i = 0; i < ((String[])object).length; ++i) {
                    CIMProperty cIMProperty = cIMClass.getProperty(object[i]);
                    cIMProperty.removeQualifier("Override");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        cloneable = new Properties();
        arrayList = new ArrayList();
        try {
            ((Properties)cloneable).load(new FileInputStream("conf/remove_key.txt"));
            object2 = ((Properties)cloneable).keySet();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                arrayList.add(object);
            }
            if (arrayList.contains(cIMClass.getName())) {
                object = ((Properties)cloneable).getProperty(cIMClass.getName());
                String[] stringArray = ((String)object).split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    CIMProperty cIMProperty = cIMClass.getProperty(stringArray[i]);
                    cIMProperty.removeQualifier("Key");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (cIMClass.getName().equalsIgnoreCase("IBMTSDS_StorageReplicationCapabilities")) {
            object2 = new CIMValue((Object)"SupportedAsynchronousActions");
            cIMClass.getProperty("SupportedAsynchronousActions").getQualifier("Override").setValue((CIMValue)object2);
        }
        if (cIMClass.getName().equalsIgnoreCase("IBMTSDS_StorageConfigurationService")) {
            cIMClass.getProperty("SystemName").removeQualifier("Propogated");
        }
    }

    private void printAdditional6kQualifiers() throws IOException {
        this.writeDataToFile("//Provider");
        this.writeDataToFile("Qualifier Provider : String = null,\n\tScope( any\n);");
        this.writeDataToFile("//Octetstring");
        this.writeDataToFile("Qualifier Octetstring : boolean = false,\n\tScope( property,\n\t method,\n\t parameter\n),\n\tFlavor(\tDisableOverride\n);");
    }

    private void printQualifierData(List list, HashMap hashMap) {
        Collections.sort(list);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.setLength(0);
            try {
                string = (String)list.get(i);
                CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
                CIMQualifierType cIMQualifierType = this.cimClient.getQualifierType(cIMObjectPath);
                String string2 = cIMQualifierType.toString();
                String string3 = hashMap.get(string.toUpperCase()).toString();
                string2 = string2.replace(": ,", ": " + string3 + ',');
                if (string2.indexOf(91, string2.indexOf("Scope(")) != -1) {
                    stringBuffer.append(string2.substring(0, string2.indexOf("Scope(") + "Scope(".length()));
                    string2 = string2.substring(string2.indexOf("Scope(") + "Scope(".length() + 1);
                    string2 = string2.replace('[', ' ');
                    string2 = string2.replace(']', ' ');
                    if (string2.indexOf(91, string2.indexOf("Flavor(")) != -1) {
                        stringBuffer.append(string2.substring(0, string2.indexOf("Flavor(") + "Flavor(".length()));
                        string2 = string2.substring(string2.indexOf("Flavor(") + "Flavor(".length() + 1);
                        string2 = string2.replace('[', ' ');
                        string2 = string2.replace(']', ' ');
                    }
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append(string2);
                }
                if (bl && string.toUpperCase().equals("REQUIRED")) continue;
                this.writeDataToFile("// " + string);
                this.writeDataToFile(stringBuffer.toString());
                if (!string.toUpperCase().equals("REQUIRED")) continue;
                bl = true;
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error for qualifier " + string);
                System.out.println(exception.getMessage());
            }
        }
        try {
            this.printAdditional6kQualifiers();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private HashMap getQualifierDatatype() throws IOException {
        FileInputStream fileInputStream = new FileInputStream("conf//datatype.txt");
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = bufferedReader.readLine();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (string != null) {
            String string2 = string.substring(string.indexOf(32) + 1, string.indexOf(58) - 1);
            String string3 = string.substring(string.indexOf(32, string.indexOf(58)), string.indexOf(44));
            hashMap.put(string2.toUpperCase(), string3);
            string = bufferedReader.readLine();
        }
        bufferedReader.close();
        inputStreamReader.close();
        fileInputStream.close();
        return hashMap;
    }

    private void addClassWithReferences(List list, CIMClass cIMClass, List list2) throws CIMException {
        String string;
        Object object;
        Vector vector;
        String string2 = cIMClass.getSuperClass();
        if (string2 != null && !string2.trim().equals("") && !list.contains(string2)) {
            vector = new CIMObjectPath(string2);
            this.addClassWithReferences(list, this.cimClient.getClass((CIMObjectPath)vector), list2);
        }
        vector = cIMClass.getAllProperties();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object = (CIMProperty)iterator.next();
            this.addQualifiersToList(list2, object.getQualifiers());
            if (!object.isReference() || list.contains(string = object.getType().getRefClassName())) continue;
            try {
                this.addClassWithReferences(list, this.cimClient.getClass(new CIMObjectPath(string)), list2);
            }
            catch (Exception exception) {
                list.add(cIMClass.getName());
            }
        }
        this.addClassQualifier(cIMClass, list2);
        if (this.isOnlyLeaf) {
            object = this.cimom.getLeafClassNamePrefixes().iterator();
            string = cIMClass.getName();
            while (object.hasNext()) {
                if (!string.startsWith((String)object.next())) continue;
                list.add(string);
                break;
            }
        } else {
            list.add(cIMClass.getName());
        }
    }

    private void addClassQualifier(CIMClass cIMClass, List list) {
        this.addQualifiersToList(list, cIMClass.getQualifiers());
        Vector vector = cIMClass.getAllMethods();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMMethod cIMMethod = (CIMMethod)iterator.next();
            this.addMethodQualifier(cIMMethod, list);
        }
    }

    private void addMethodQualifier(CIMMethod cIMMethod, List list) {
        this.addQualifiersToList(list, cIMMethod.getQualifiers());
        Vector vector = cIMMethod.getParameters();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMParameter cIMParameter = (CIMParameter)iterator.next();
            this.addQualifiersToList(list, cIMParameter.getQualifiers());
        }
    }

    private void addQualifiersToList(List list, Vector vector) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMQualifier cIMQualifier = (CIMQualifier)iterator.next();
            if (list.contains(cIMQualifier.getName())) continue;
            list.add(cIMQualifier.getName());
        }
    }

    protected void createCIMClient(String string, String string2, String string3, String string4) {
        try {
            if (string != null && string4 != null) {
                CIMNameSpace cIMNameSpace = new CIMNameSpace(string, string4);
                if (string2 != null) {
                    this.principal = new UserPrincipal(string2);
                }
                if (string3 != null) {
                    this.credential = new PasswordCredential(string3.toCharArray());
                }
                this.cimClient = new CIMClient(cIMNameSpace, (Principal)this.principal, (Object)this.credential);
            } else {
                System.err.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
    }

    protected void generateData(String string, ArrayList arrayList) throws Exception {
        DiscoveryUtil.getNamespaces(this.cimClient, arrayList, this.cimom.getCimomType());
        for (int i = 0; i < arrayList.size(); ++i) {
            this.generateDataForNameSpace((String)arrayList.get(i), string);
        }
        if (this.cimClient != null) {
            try {
                this.cimClient.close();
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
        }
        this.cimClient = null;
    }
}

