/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.SimulatorException;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.base.BaseSnapshotMaker;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.CIMDataBLOB;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.DiscoveryUtil;

public class SnapshotMakerWithAssociation
extends BaseSnapshotMaker {
    private CIMClient cimClient;
    private CIMNameSpace cimNamespace;
    private UserPrincipal principal;
    private PasswordCredential credential;
    private PreparedStatement psEnumInstanceNamesWithString;
    private PreparedStatement psEnumInstanceNamesWithID;
    private PreparedStatement psCimDataInsert;
    private ArrayList classListAssoc = new ArrayList();

    public SnapshotMakerWithAssociation(CIMOM cIMOM) throws SimulatorException {
        super(cIMOM);
        this.prepareAllStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Start Snapshot");
        try {
            String string = this.cimom.getServiceURL();
            String string2 = this.cimom.getUserID();
            String string3 = this.cimom.getPassword();
            String string4 = this.cimom.getNamespace();
            if (string != null && string4 != null) {
                try {
                    this.cimNamespace = new CIMNameSpace(string, string4);
                    if (string2 != null) {
                        this.principal = new UserPrincipal(string2);
                    }
                    if (string3 != null) {
                        this.credential = new PasswordCredential(string3);
                    }
                    this.cimClient = new CIMClient(this.cimNamespace, (Principal)this.principal, (Object)this.credential);
                }
                catch (Exception exception) {
                    System.out.println("Unable To Connect to CIMOM [" + string + "]" + exception.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
            this.insert_CIMOM_INFO(this.cimom.getCimomVendorType(), this.cimom.getCimomType(), string, string4, string2, string3);
            int n = this.getMaxID("SIM.CIMOM_INFO");
            ArrayList arrayList = new ArrayList();
            arrayList.add(string4);
            arrayList = DiscoveryUtil.getNamespaces(this.cimClient, arrayList, this.cimom.getCimomType());
            for (int i = 0; i < arrayList.size(); ++i) {
                this.insert_NS_INFO(n, (String)arrayList.get(i));
                int n2 = this.getMaxID("SIM.NS_INFO");
                this.snapshotClasses((String)arrayList.get(i), n2);
            }
            this.buildAssociationIndexes();
            if (this.cimClient != null) {
                this.cimClient.close();
            }
            this.cimClient = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.cimClient != null) {
                    this.cimClient.close();
                }
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.cimClient = null;
            this.con = null;
        }
    }

    private synchronized void insert_CIM_DATA(int n, CIMInstance cIMInstance) throws Exception {
        CIMInstance cIMInstance2 = this.removeQualifiers(cIMInstance);
        CIMDataBLOB cIMDataBLOB = new CIMDataBLOB(cIMInstance2);
        int n2 = (int)cIMDataBLOB.length();
        CIMDataBLOB cIMDataBLOB2 = new CIMDataBLOB(cIMInstance2.getObjectPath());
        int n3 = (int)cIMDataBLOB2.length();
        this.psCimDataInsert.setInt(1, n);
        this.psCimDataInsert.setBinaryStream(2, cIMDataBLOB2.getBinaryStream(), n3);
        this.psCimDataInsert.setBinaryStream(3, cIMDataBLOB.getBinaryStream(), n2);
        this.psCimDataInsert.executeUpdate();
        this.con.commit();
    }

    private CIMInstance removeQualifiers(CIMInstance cIMInstance) {
        CIMInstance cIMInstance2 = new CIMInstance();
        cIMInstance2.setClassName(cIMInstance.getClassName());
        cIMInstance2.setAlias(cIMInstance.getAlias());
        cIMInstance2.setObjectPath(cIMInstance.getObjectPath());
        Vector vector = cIMInstance.getProperties();
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            CIMProperty cIMProperty = (CIMProperty)iterator.next();
            CIMProperty cIMProperty2 = new CIMProperty();
            cIMProperty2.setKey(cIMProperty.isKey());
            cIMProperty2.setName(cIMProperty.getName());
            cIMProperty2.setValue(cIMProperty.getValue());
            cIMProperty2.setType(cIMProperty.getType());
            vector2.add(cIMProperty2);
        }
        cIMInstance2.setProperties(vector2);
        return cIMInstance2;
    }

    protected synchronized void snapshotClassInstances(String string, int n) throws Exception {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
        Enumeration enumeration = this.cimClient.enumerateInstances(cIMObjectPath, true, false, false, true, null);
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            int n2 = -1;
            if (!bl) {
                this.insert_CIM_CLASS(n, cIMInstance.getClassName());
                n2 = this.getMaxID("SIM.CIM_CLASS");
                bl = true;
            }
            this.insert_CIM_DATA(n2, cIMInstance);
            System.out.println("NS = [" + this.cimom.getNamespace() + "], CLS = [" + string + "]");
        }
        enumeration = null;
    }

    protected synchronized void snapshotClasses(String string, int n) throws Exception {
        this.cimClient = null;
        this.cimNamespace = null;
        this.cimNamespace = new CIMNameSpace(this.cimom.getServiceURL(), string);
        this.cimClient = new CIMClient(this.cimNamespace, (Principal)new UserPrincipal(this.cimom.getUserID()), (Object)new PasswordCredential(this.cimom.getPassword()));
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        Enumeration enumeration = this.cimClient.enumerateClasses(cIMObjectPath, true, false, true, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            CIMClass cIMClass = (CIMClass)enumeration.nextElement();
            if (!this.isClassSnapshotable(cIMClass.getName())) continue;
            arrayList.add(cIMClass.getName());
            if (!cIMClass.isAssociation()) continue;
            this.classListAssoc.add(n + "/" + cIMClass.getName());
        }
        enumeration = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            try {
                this.insert_CIM_CLASS(n, string2);
                int n2 = this.getMaxID("SIM.CIM_CLASS");
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string2);
                Enumeration enumeration2 = this.cimClient.enumerateInstances(cIMObjectPath2, true, false, false, true, null);
                while (enumeration2.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration2.nextElement();
                    this.insert_CIM_DATA(n2, cIMInstance);
                    System.out.println("NS = [" + string + "], CLS = [" + (String)arrayList.get(i) + "]");
                }
                enumeration2 = null;
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.cimClient.close();
        this.cimClient = null;
    }

    private void buildAssociationIndexes() {
        for (int i = 0; i < this.classListAssoc.size(); ++i) {
            String string = (String)this.classListAssoc.get(i);
            int n = Integer.parseInt(string.substring(0, string.indexOf("/")));
            string = string.substring(string.indexOf("/") + 1, string.length());
            try {
                this.psEnumInstanceNamesWithID.setString(1, string);
                this.psEnumInstanceNamesWithID.setInt(2, n);
                ResultSet resultSet = this.psEnumInstanceNamesWithID.executeQuery();
                while (resultSet.next()) {
                    int n2;
                    InputStream inputStream = resultSet.getBinaryStream(1);
                    ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                    Object object = objectInputStream.readObject();
                    CIMObjectPath cIMObjectPath = (CIMObjectPath)object;
                    String string2 = SimulatorUtility.fixNamespaceSlashIssue(cIMObjectPath.getNameSpace());
                    Vector vector = cIMObjectPath.getKeys();
                    CIMObjectPath cIMObjectPath2 = null;
                    CIMObjectPath cIMObjectPath3 = null;
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n2);
                        if (cIMProperty.getType().getType() != 28 || cIMObjectPath2 != null) continue;
                        cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
                        cIMObjectPath3 = SimulatorUtility.getResultOP(vector, n2);
                        break;
                    }
                    n2 = resultSet.getInt(2);
                    int n3 = this.getInstanceID(cIMObjectPath2);
                    int n4 = this.getInstanceID(cIMObjectPath3);
                    if (n3 == -1 || n4 == -1) continue;
                    this.insert_CIM_ASSOC(n2, n3, n4);
                }
                resultSet.close();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean isClassSnapshotable(String string) {
        ArrayList arrayList = this.cimom.getLeafClassNamePrefixes();
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (!string.startsWith(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void prepareAllStatements() {
        try {
            this.psEnumInstanceNamesWithString = this.con.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
            this.psEnumInstanceNamesWithID = this.con.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.CLASS_NAME=? AND CLS.NS_INFO_ID=?");
            String string = "INSERT INTO SIM.CIM_DATA (CIM_CLASS_ID, CIM_OP, CIM_INST) VALUES (?, ?, ?)";
            this.psCimDataInsert = this.con.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private int getInstanceID(CIMObjectPath cIMObjectPath) {
        int n = -1;
        try {
            String string = cIMObjectPath.getObjectName();
            String string2 = SimulatorUtility.fixNamespaceSlashIssue(cIMObjectPath.getNameSpace());
            this.psEnumInstanceNamesWithString.setString(1, string);
            this.psEnumInstanceNamesWithString.setString(2, string2);
            ResultSet resultSet = this.psEnumInstanceNamesWithString.executeQuery();
            while (resultSet.next()) {
                ObjectInputStream objectInputStream;
                Object object;
                CIMObjectPath cIMObjectPath2;
                InputStream inputStream = resultSet.getBinaryStream(1);
                if (inputStream == null || !SimulatorUtility.equalsCIMObjectPath(cIMObjectPath2 = (CIMObjectPath)(object = (objectInputStream = new ObjectInputStream(inputStream)).readObject()), cIMObjectPath)) continue;
                n = resultSet.getInt(2);
                break;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }
}

