/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.generator.ClassXMLParser;
import org.eclipse.aperi.simulator.cimom.common.generator.InstanceCreator;
import org.eclipse.aperi.simulator.cimom.common.generator.ParserRespose;
import org.eclipse.aperi.simulator.cimom.common.generator.SimAssociationClass;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;

public final class DS6kExtrinsicMethods {
    private static final String NAMESPACE_ROOT_IBM = "/root/ibm";
    private static final String CLASS_IBMTSESS_STORAGE_SYSTEM = "IBMTSESS_StorageSystem";
    private static final String CLASS_IBMTSESS_PRIMORDIAL_STORAGE_POOL = "IBMTSESS_PrimordialStoragePool";
    private static final String DS6K_XML_FILE_PATH = "XML\\Storage\\IBM\\DS6K\\DS6K_Root_IBM.xml";
    private static final String CLASS_IBMTSESS_STORAGE_VOLUME = "IBMTSESS_Volume";
    private static final String CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL = "IBMTSESS_AllocatedFromStoragePool";
    private static final String CLASS_IBMTSESS_BASED_ON = "IBMTSESS_BasedOn";
    private static final String CLASS_IBMTSESS_STORAGE_POOL = "IBMTSESS_VolumeSpace";
    private static final String CLASS_IBMTSESS_COMPONENT = "IBMTSESS_Component";
    private static final String CLASS_IBMTSESS_STORAGE_EXTENT = "IBMTSESS_StorageExtent";
    private static final String CLASS_IBMTSESS_STORAGE_CAPABILITIES = "IBMTSESS_StorageCapabilities";
    private static final String CLASS_IBMTSESS_ELEMENT_CAPABILITIES = "IBMTSESS_ElementCapabilities";
    private static final String CLASS_IBMTSESS_HOSTED_STORAGE_POOL = "IBMTSESS_HostedStoragePool";

    public static CIMValue createOrModifyElementFromStoragePool(CIMObjectPath cIMObjectPath, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) {
        CIMValue cIMValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (CreateOrModifyElementFromStoragePool) Called");
        try {
            String string;
            CIMObjectPath cIMObjectPath2;
            DatabaseManager databaseManager = DatabaseManager.getDbManager();
            List list = databaseManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
            Iterator iterator = list.iterator();
            CIMObjectPath cIMObjectPath3 = null;
            String string2 = (String)cIMObjectPath.getKey("SystemName").getValue().getValue();
            while (iterator.hasNext()) {
                cIMObjectPath2 = (CIMObjectPath)iterator.next();
                string = (String)cIMObjectPath2.getKey("Name").getValue().getValue();
                if (!string.equalsIgnoreCase(string2)) continue;
                cIMObjectPath3 = cIMObjectPath2;
                break;
            }
            cIMObjectPath2 = (CIMObjectPath)cIMArgumentArray[3].getValue().getValue();
            string = databaseManager.getInstance(cIMObjectPath2);
            Boolean bl = (Boolean)string.getProperty("Primordial").getValue().getValue();
            if (cIMObjectPath3 != null && !bl.booleanValue()) {
                UnsignedInt64 unsignedInt64;
                UnsignedInt64 unsignedInt642 = (UnsignedInt64)string.getProperty("RemainingManagedSpace").getValue().getValue();
                if (unsignedInt642.compareTo((Object)(unsignedInt64 = (UnsignedInt64)cIMArgumentArray[4].getValue().getValue())) == 1) {
                    CIMArgument cIMArgument;
                    ClassXMLParser classXMLParser = new ClassXMLParser();
                    ParserRespose parserRespose = classXMLParser.parse(DS6K_XML_FILE_PATH);
                    InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
                    SimClass simClass = (SimClass)parserRespose.getClassMap().get(CLASS_IBMTSESS_STORAGE_VOLUME);
                    CIMInstance cIMInstance = instanceCreator.createDefaultInstance(simClass);
                    cIMInstance.setProperty("ElementName", cIMArgumentArray[0].getValue());
                    cIMInstance.setProperty("Name", new CIMValue((Object)("0000000000000000000000000000" + cIMInstance.getProperty("DeviceID").getValue().getValue()), CIMDataType.getPredefinedType((int)8)));
                    cIMInstance.setProperty("SystemName", new CIMValue((Object)string2));
                    cIMInstance.getObjectPath().getKey("DeviceID").setValue(cIMInstance.getProperty("DeviceID").getValue());
                    cIMInstance.getObjectPath().getKey("SystemName").setValue(cIMInstance.getProperty("SystemName").getValue());
                    float f = new Float(unsignedInt64.toString()).floatValue();
                    cIMInstance.setProperty("cap", new CIMValue((Object)new Float(f), CIMDataType.getPredefinedType((int)10)));
                    simClass = (SimClass)parserRespose.getClassMap().get(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL);
                    ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_POOL);
                    ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_VOLUME);
                    CIMInstance cIMInstance2 = instanceCreator.createAssociationInstance(simClass, cIMObjectPath2, cIMInstance.getObjectPath());
                    cIMInstance2.setProperty("SpaceConsumed", new CIMValue((Object)unsignedInt64));
                    unsignedInt642 = new UnsignedInt64(unsignedInt642.bigIntValue().subtract(unsignedInt64.bigIntValue()));
                    string.setProperty("RemainingManagedSpace", new CIMValue((Object)unsignedInt642));
                    string.setProperty("LogicalFree", new CIMValue((Object)unsignedInt642));
                    databaseManager.createInstance(cIMInstance);
                    databaseManager.createInstance(cIMInstance2);
                    databaseManager.updateInstance(string.getObjectPath(), (CIMInstance)string);
                    System.out.println("Volume Creation successful");
                    cIMValue = new CIMValue((Object)new UnsignedInt16(0));
                    cIMArgumentArray2[0] = cIMArgument = new CIMArgument("Job");
                    cIMArgumentArray2[1] = cIMArgumentArray[4];
                    CIMArgument cIMArgument2 = new CIMArgument("TheElement");
                    cIMArgument2.setValue(new CIMValue((Object)cIMInstance.getObjectPath()));
                    cIMArgumentArray2[2] = cIMArgument2;
                } else {
                    System.out.println("Remaining space is not sufficient to create the requested volume");
                    cIMValue = new CIMValue((Object)new UnsignedInt16(8));
                }
            } else {
                System.out.println("Pool supplied is primordial or system path is null");
                cIMValue = new CIMValue((Object)new UnsignedInt16(4));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cIMValue;
    }

    public static CIMValue createOrModifyStoragePool(CIMObjectPath cIMObjectPath, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) {
        CIMValue cIMValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (CreateOrModifyStoragePool) Called");
        try {
            String string;
            Object object;
            Iterator iterator;
            DatabaseManager databaseManager = DatabaseManager.getDbManager();
            CIMObjectPath[] cIMObjectPathArray = null;
            UnsignedInt64 unsignedInt64 = null;
            CIMValue cIMValue2 = null;
            CIMArgument cIMArgument = null;
            for (int i = 0; i < cIMArgumentArray.length; ++i) {
                if (cIMArgumentArray[i].getName().equalsIgnoreCase("InExtents")) {
                    iterator = new Vector();
                    iterator = (Vector)cIMArgumentArray[i].getValue().getValue();
                    cIMObjectPathArray = new CIMObjectPath[((Vector)((Object)iterator)).size()];
                    for (int j = 0; j < ((Vector)((Object)iterator)).size(); ++j) {
                        cIMObjectPathArray[j] = new CIMObjectPath((String)((Vector)((Object)iterator)).get(j));
                    }
                    continue;
                }
                if (cIMArgumentArray[i].getName().equalsIgnoreCase("Size")) {
                    unsignedInt64 = (UnsignedInt64)cIMArgumentArray[i].getValue().getValue();
                    cIMArgument = cIMArgumentArray[i];
                    continue;
                }
                if (!cIMArgumentArray[i].getName().equalsIgnoreCase("ElementName")) continue;
                cIMValue2 = cIMArgumentArray[i].getValue();
            }
            List list = databaseManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
            iterator = list.iterator();
            Object object2 = null;
            String string2 = (String)cIMObjectPath.getKey("SystemName").getValue().getValue();
            while (iterator.hasNext()) {
                object = (CIMObjectPath)iterator.next();
                string = (String)object.getKey("Name").getValue().getValue();
                if (!string.equalsIgnoreCase(string2)) continue;
                object2 = object;
                break;
            }
            if (object2 != null) {
                Object object3;
                object = databaseManager.enumerateInstances(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_PRIMORDIAL_STORAGE_POOL);
                iterator = object.iterator();
                string = null;
                while (iterator.hasNext() && !((String)(object3 = (String)(string = (CIMInstance)iterator.next()).getObjectPath().getKey("InstanceID").getValue().getValue())).equals(string2)) {
                }
                object3 = (UnsignedInt64)string.getProperty("RemainingManagedSpace").getValue().getValue();
                if (object3.compareTo((Object)unsignedInt64) == 1) {
                    CIMArgument cIMArgument2;
                    ClassXMLParser classXMLParser = new ClassXMLParser();
                    ParserRespose parserRespose = classXMLParser.parse(DS6K_XML_FILE_PATH);
                    InstanceCreator instanceCreator = new InstanceCreator(NAMESPACE_ROOT_IBM);
                    SimClass simClass = (SimClass)parserRespose.getClassMap().get(CLASS_IBMTSESS_STORAGE_POOL);
                    CIMInstance cIMInstance = instanceCreator.createDefaultInstance(simClass);
                    cIMInstance.setProperty("ElementName", cIMValue2);
                    CIMValue cIMValue3 = new CIMValue((Object)(string2 + "-" + cIMValue2.getValue().toString()), CIMDataType.getPredefinedType((int)8));
                    cIMInstance.setProperty("InstanceID", cIMValue3);
                    cIMInstance.setProperty("RemainingManagedSpace", new CIMValue((Object)unsignedInt64));
                    cIMInstance.setProperty("LogicalFree", new CIMValue((Object)unsignedInt64));
                    cIMInstance.setProperty("TotalManagedSpace", new CIMValue((Object)unsignedInt64));
                    cIMInstance.getObjectPath().getKey("InstanceID").setValue(cIMValue3);
                    object3 = new UnsignedInt64(object3.bigIntValue().subtract(unsignedInt64.bigIntValue()));
                    string.setProperty("RemainingManagedSpace", new CIMValue(object3));
                    CIMInstance[] cIMInstanceArray = new CIMInstance[cIMObjectPathArray.length];
                    simClass = (SimClass)parserRespose.getClassMap().get(CLASS_IBMTSESS_COMPONENT);
                    ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_POOL);
                    ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_EXTENT);
                    for (int i = 0; i < cIMObjectPathArray.length; ++i) {
                        cIMInstanceArray[i] = instanceCreator.createAssociationInstance(simClass, cIMInstance.getObjectPath(), cIMObjectPathArray[i]);
                    }
                    List list2 = databaseManager.enumerateInstances(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_CAPABILITIES);
                    iterator = list2.iterator();
                    CIMInstance cIMInstance2 = null;
                    while (iterator.hasNext()) {
                        cIMInstance2 = (CIMInstance)iterator.next();
                    }
                    simClass = (SimClass)parserRespose.getClassMap().get(CLASS_IBMTSESS_ELEMENT_CAPABILITIES);
                    ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_CAPABILITIES);
                    ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_POOL);
                    CIMInstance cIMInstance3 = instanceCreator.createAssociationInstance(simClass, cIMInstance2.getObjectPath(), cIMInstance.getObjectPath());
                    simClass = (SimClass)parserRespose.getClassMap().get(CLASS_IBMTSESS_HOSTED_STORAGE_POOL);
                    ((SimAssociationClass)simClass).setAntecedentClassName(CLASS_IBMTSESS_STORAGE_SYSTEM);
                    ((SimAssociationClass)simClass).setDependentClassName(CLASS_IBMTSESS_STORAGE_POOL);
                    CIMInstance cIMInstance4 = instanceCreator.createAssociationInstance(simClass, (CIMObjectPath)object2, cIMInstance.getObjectPath());
                    databaseManager.createInstance(cIMInstance);
                    databaseManager.updateInstance(string.getObjectPath(), (CIMInstance)string);
                    for (int i = 0; i < cIMInstanceArray.length; ++i) {
                        databaseManager.createInstance(cIMInstanceArray[i]);
                    }
                    databaseManager.createInstance(cIMInstance3);
                    databaseManager.createInstance(cIMInstance4);
                    cIMArgumentArray2[0] = cIMArgument2 = new CIMArgument("Job");
                    CIMArgument cIMArgument3 = new CIMArgument("Pool");
                    cIMArgument3.setValue(new CIMValue((Object)cIMInstance.getObjectPath()));
                    cIMArgumentArray2[1] = cIMArgument3;
                    cIMArgumentArray2[2] = cIMArgument;
                    cIMValue = new CIMValue((Object)new UnsignedInt16(0));
                    System.out.println("Storage Pool Created Successfully");
                } else {
                    cIMValue = new CIMValue((Object)new UnsignedInt16(8));
                    System.out.println("Requested Size is not available for pool creation");
                }
            } else {
                cIMValue = new CIMValue((Object)new UnsignedInt16(4));
                System.out.println("Specified Storage System could not be found");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cIMValue;
    }

    public static CIMValue createSetting(CIMObjectPath cIMObjectPath, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) {
        CIMValue cIMValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (CreateSetting) Called");
        cIMValue = new CIMValue((Object)new UnsignedInt16(2));
        cIMArgumentArray2[0] = null;
        return cIMValue;
    }

    public static CIMValue deleteStoragePool(CIMObjectPath cIMObjectPath, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) {
        CIMValue cIMValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (DeleteStoragePool) Called");
        try {
            Object object;
            CIMObjectPath[] cIMObjectPathArray;
            DatabaseManager databaseManager = DatabaseManager.getDbManager();
            boolean bl = false;
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMArgumentArray[0].getValue().getValue();
            CIMInstance cIMInstance = databaseManager.getInstance(cIMObjectPath2);
            CIMObjectPath[] cIMObjectPathArray2 = null;
            List list = databaseManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
            Iterator iterator = list.iterator();
            String string = (String)cIMObjectPath.getKey("SystemName").getValue().getValue();
            while (iterator.hasNext()) {
                cIMObjectPathArray = (CIMObjectPath[])iterator.next();
                object = (String)cIMObjectPathArray.getKey("Name").getValue().getValue();
                if (!((String)object).equalsIgnoreCase(string)) continue;
                cIMObjectPathArray2 = cIMObjectPathArray;
                break;
            }
            if (cIMObjectPathArray2 != null && cIMInstance != null) {
                Object object2;
                cIMObjectPathArray = new CIMObjectPath[]{new CIMObjectPath(CLASS_IBMTSESS_COMPONENT, NAMESPACE_ROOT_IBM), new CIMObjectPath(CLASS_IBMTSESS_ELEMENT_CAPABILITIES, NAMESPACE_ROOT_IBM), new CIMObjectPath(CLASS_IBMTSESS_HOSTED_STORAGE_POOL, NAMESPACE_ROOT_IBM), new CIMObjectPath(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL, NAMESPACE_ROOT_IBM)};
                object = new ArrayList();
                for (int i = 0; i < 4; ++i) {
                    object2 = databaseManager.references(cIMObjectPathArray[i], cIMObjectPath2);
                    object.addAll(object2);
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    CIMInstance cIMInstance2 = (CIMInstance)iterator.next();
                    if (!cIMInstance2.getClassName().equalsIgnoreCase(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL)) continue;
                    bl = true;
                }
                if (!bl) {
                    CIMArgument cIMArgument;
                    Object object3;
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        CIMInstance cIMInstance3 = (CIMInstance)iterator.next();
                        object2 = cIMInstance3.getClassName();
                        if (!((String)object2).equalsIgnoreCase(CLASS_IBMTSESS_COMPONENT) && !((String)object2).equalsIgnoreCase(CLASS_IBMTSESS_ELEMENT_CAPABILITIES) && !((String)object2).equalsIgnoreCase(CLASS_IBMTSESS_HOSTED_STORAGE_POOL)) continue;
                        databaseManager.deleteInstance(cIMInstance3.getObjectPath());
                    }
                    List list2 = databaseManager.enumerateInstances(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_PRIMORDIAL_STORAGE_POOL);
                    iterator = list2.iterator();
                    object2 = null;
                    while (iterator.hasNext() && !((String)(object3 = (String)(object2 = (CIMInstance)iterator.next()).getObjectPath().getKey("InstanceID").getValue().getValue())).equals(string)) {
                    }
                    object3 = (UnsignedInt64)cIMInstance.getProperty("TotalManagedSpace").getValue().getValue();
                    UnsignedInt64 unsignedInt64 = (UnsignedInt64)object2.getProperty("RemainingManagedSpace").getValue().getValue();
                    unsignedInt64 = new UnsignedInt64(unsignedInt64.bigIntValue().add(object3.bigIntValue()));
                    object2.setProperty("RemainingManagedSpace", new CIMValue((Object)unsignedInt64));
                    databaseManager.updateInstance(object2.getObjectPath(), (CIMInstance)object2);
                    databaseManager.deleteInstance(cIMObjectPath2);
                    cIMArgumentArray2[0] = cIMArgument = new CIMArgument("Job");
                    cIMValue = new CIMValue((Object)new UnsignedInt16(0));
                    System.out.println("Storage Pool deleted successfully");
                } else {
                    cIMValue = new CIMValue((Object)new UnsignedInt16(6));
                    System.out.println("Pool to be deleted in in use");
                }
            } else {
                cIMValue = new CIMValue((Object)new UnsignedInt16(4));
                System.out.println("Storage System or Pool does not exist");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cIMValue;
    }

    public static CIMValue returnToStoragePool(CIMObjectPath cIMObjectPath, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) {
        CIMValue cIMValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (ReturnToStoragePool) Called");
        try {
            Object object;
            CIMObjectPath[] cIMObjectPathArray;
            DatabaseManager databaseManager = DatabaseManager.getDbManager();
            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMArgumentArray[0].getValue().getValue();
            CIMInstance cIMInstance = databaseManager.getInstance(cIMObjectPath2);
            CIMObjectPath[] cIMObjectPathArray2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            CIMInstance cIMInstance2 = null;
            List list = databaseManager.enumerateInstanceNames(NAMESPACE_ROOT_IBM, CLASS_IBMTSESS_STORAGE_SYSTEM);
            Iterator iterator = list.iterator();
            String string = (String)cIMObjectPath.getKey("SystemName").getValue().getValue();
            while (iterator.hasNext()) {
                cIMObjectPathArray = (CIMObjectPath[])iterator.next();
                object = (String)cIMObjectPathArray.getKey("Name").getValue().getValue();
                if (!((String)object).equalsIgnoreCase(string)) continue;
                cIMObjectPathArray2 = cIMObjectPathArray;
                break;
            }
            if (cIMObjectPathArray2 != null && cIMInstance != null) {
                CIMObjectPath cIMObjectPath4;
                CIMProperty cIMProperty;
                Object object2;
                Object object3;
                cIMObjectPathArray = new CIMObjectPath[]{new CIMObjectPath(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL, NAMESPACE_ROOT_IBM), new CIMObjectPath(CLASS_IBMTSESS_BASED_ON, NAMESPACE_ROOT_IBM)};
                object = new ArrayList();
                for (int i = 0; i < 2; ++i) {
                    object3 = databaseManager.references(cIMObjectPathArray[i], cIMObjectPath2);
                    object.addAll(object3);
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    CIMInstance cIMInstance3 = (CIMInstance)iterator.next();
                    if (cIMInstance3.getClassName().equalsIgnoreCase(CLASS_IBMTSESS_ALLOCATED_FROM_STORAGE_POOL)) {
                        object3 = cIMInstance3.getKeys();
                        object2 = ((Vector)object3).iterator();
                        while (object2.hasNext()) {
                            cIMProperty = (CIMProperty)object2.next();
                            cIMObjectPath4 = (CIMObjectPath)cIMProperty.getValue().getValue();
                            if (!cIMObjectPath4.getObjectName().equalsIgnoreCase(CLASS_IBMTSESS_STORAGE_POOL)) continue;
                            cIMObjectPath3 = cIMObjectPath4;
                        }
                    }
                    databaseManager.deleteInstance(cIMInstance3.getObjectPath());
                }
                cIMInstance2 = databaseManager.getInstance(cIMObjectPath3);
                UnsignedInt64 unsignedInt64 = (UnsignedInt64)cIMInstance2.getProperty("RemainingManagedSpace").getValue().getValue();
                object3 = (Float)cIMInstance.getProperty("cap").getValue().getValue();
                object2 = new BigInteger(new Long(((Float)object3).longValue()).toString());
                cIMProperty = new UnsignedInt64(unsignedInt64.bigIntValue().add((BigInteger)object2));
                cIMInstance2.setProperty("RemainingManagedSpace", new CIMValue((Object)cIMProperty));
                cIMInstance2.setProperty("LogicalFree", new CIMValue((Object)cIMProperty));
                databaseManager.updateInstance(cIMObjectPath3, cIMInstance2);
                databaseManager.deleteInstance(cIMObjectPath2);
                cIMObjectPath4 = new CIMArgument("Job");
                cIMArgumentArray2[0] = cIMObjectPath4;
                cIMValue = new CIMValue((Object)new UnsignedInt16(0));
                System.out.println("Volume deleted successfully");
            } else {
                cIMValue = new CIMValue((Object)new UnsignedInt16(4));
                System.out.println("Storage System or volume does not exist");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cIMValue;
    }

    public static CIMValue getSupportedSizeRange(CIMObjectPath cIMObjectPath, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) {
        CIMValue cIMValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (GetSupportedSizeRange) Called");
        try {
            CIMInstance cIMInstance = DatabaseManager.getDbManager().getInstance(cIMObjectPath);
            if (cIMInstance != null) {
                UnsignedInt64 unsignedInt64 = (UnsignedInt64)cIMInstance.getProperty("RemainingManagedSpace").getValue().getValue();
                CIMArgument cIMArgument = new CIMArgument("MaximumVolumeSize");
                cIMArgument.setValue(new CIMValue((Object)unsignedInt64, CIMDataType.getPredefinedType((int)6)));
                cIMArgumentArray2[0] = cIMArgument;
                UnsignedInt64 unsignedInt642 = new UnsignedInt64("0");
                CIMArgument cIMArgument2 = new CIMArgument("MinimumVolumeSize");
                cIMArgument2.setValue(new CIMValue((Object)unsignedInt642, CIMDataType.getPredefinedType((int)6)));
                cIMArgumentArray2[1] = cIMArgument2;
                UnsignedInt64 unsignedInt643 = new UnsignedInt64("1024");
                CIMArgument cIMArgument3 = new CIMArgument("VolumeSizeDivisor");
                cIMArgument3.setValue(new CIMValue((Object)unsignedInt643, CIMDataType.getPredefinedType((int)6)));
                cIMArgumentArray2[2] = cIMArgument3;
                cIMValue = new CIMValue((Object)new UnsignedInt16(0));
            } else {
                cIMValue = new CIMValue((Object)new UnsignedInt16(32792));
                System.out.println("Invalid Pool");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cIMValue;
    }

    public static CIMValue getSupportedSizes(CIMObjectPath cIMObjectPath, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) {
        CIMValue cIMValue = null;
        System.out.println("[SIMULATOR]: DS6k Extrinsic Method (GetSupportedSizes) Called");
        cIMValue = new CIMValue((Object)new UnsignedInt16(2));
        cIMArgumentArray2[0] = null;
        return cIMValue;
    }
}

