/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CheckPreRequisites {
    private Logger logger = Logger.getLogger((Class)CheckPreRequisites.class);

    protected boolean CheckPort(int n) {
        boolean bl = false;
        if (this.checkPortAvailablity(n)) {
            try {
                if (this.setPortForCIMOM(n)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.logger.error((Object)exception);
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean checkJavaVersion(String string) {
        this.logger.info((Object)"Checking whether Java Version is 5.0 or greater");
        String string2 = null;
        string2 = System.getProperty("java.version");
        String[] stringArray = this.spiltVersion(string2.toCharArray());
        this.logger.info((Object)("Java Version Set to: " + string2));
        if (Integer.parseInt(stringArray[1]) >= Integer.parseInt(string)) {
            this.logger.info((Object)"Java version higher than JDK 5");
            return true;
        }
        this.logger.debug((Object)"Java version is smaller than JDK 5");
        return false;
    }

    private String[] spiltVersion(char[] cArray) {
        String[] stringArray = new String[cArray.length / 2];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '.') {
                if (stringArray[n] == null) {
                    stringArray[n] = "" + cArray[i];
                    continue;
                }
                int n2 = n;
                stringArray[n2] = stringArray[n2] + cArray[i];
                continue;
            }
            ++n;
        }
        return stringArray;
    }

    public boolean checkJavaHome(String string) {
        this.logger.info((Object)"Check whether JAVA_HOME is set");
        if (this.checkJavaVersion(string)) {
            String string2 = null;
            try {
                Properties properties = this.getEnvProperties();
                string2 = properties.getProperty("JAVA_HOME");
                this.logger.debug((Object)("JAVA_HOME is set to " + string2));
            }
            catch (Exception exception) {
                this.logger.error((Object)exception);
                exception.printStackTrace();
            }
            if (string2 == null) {
                this.logger.error((Object)"JAVA_HOME environment variable not set");
                JOptionPane.showMessageDialog(null, "The JAVA_HOME environment variable must be set to an existing copy of the Java SDK.", "JAVA_HOME Error", 0);
                System.exit(0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "JAVA SDK version installed on your machine is smaller than SDK 5.0.", "Java Version Incompatible", 0);
            System.exit(0);
        }
        return true;
    }

    private boolean checkPortAvailablity(int n) {
        this.logger.info((Object)"Check port availability");
        boolean bl = true;
        String string = "localhost";
        Socket socket = null;
        try {
            socket = new Socket(string, n);
            this.logger.debug((Object)("Port check for " + socket.getInetAddress() + ":" + socket.getPort()));
            bl = false;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            this.logger.info((Object)"Port availability Successful");
        }
        if (!bl) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                this.logger.error((Object)iOException);
                System.out.println(iOException);
            }
            JOptionPane.showMessageDialog(null, "Port " + n + " is currently in use.Close application that might be using that port !", "Port 5988 In Use", 0);
        }
        return bl;
    }

    private boolean setPortForCIMOM(int n) throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream("san_simulator_cimom.properties");
        FileOutputStream fileOutputStream = new FileOutputStream("san_simulator_cimom.properties");
        properties.load(fileInputStream);
        properties.setProperty("HTTP_PORT", Integer.toString(n));
        properties.setProperty("DATABASE", "db2");
        properties.setProperty("DB_USERNAME", "admin");
        properties.setProperty("DB_PASSWORD", "admin");
        properties.setProperty("DB_NAME", "SIMDB");
        properties.setProperty("DB_LOCATION", "localhost");
        properties.store(fileOutputStream, "SAN Simulator Properties");
        fileOutputStream.close();
        fileInputStream.close();
        return true;
    }

    private Properties getEnvProperties() throws Exception {
        Properties properties = new Properties();
        File file = File.createTempFile("temp", ".properties");
        file.deleteOnExit();
        String string = this.createTempFile(file.getAbsolutePath(), "set");
        Process process = Runtime.getRuntime().exec(string);
        Thread.sleep(500L);
        FileInputStream fileInputStream = new FileInputStream(file.getAbsoluteFile());
        properties.load(fileInputStream);
        fileInputStream.close();
        return properties;
    }

    private String createTempFile(String string, String string2) throws IOException {
        File file = File.createTempFile("temp", ".bat");
        file.deleteOnExit();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(string2 + " > " + string);
        bufferedWriter.flush();
        bufferedWriter.close();
        return file.getAbsolutePath();
    }
}

