/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;
import org.eclipse.aperi.simulator.ui.StartCimom;

public class CompileMOF {
    protected static String startCimomCommand;
    private static String compileMofFileCommand;
    private Logger logger = Logger.getLogger((Class)CompileMOF.class);

    private int executeCommand(String string) {
        this.logger.debug((Object)("Compile MOF Command is: " + string));
        int n = 0;
        try {
            String string2;
            final Process process = Runtime.getRuntime().exec(string, null, new File(SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM") + "\\wbemservices\\bin"));
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        String string;
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        while (null != (string = bufferedReader.readLine())) {
                            CompileMOF.this.logger.warn((Object)("Compile MOF Error: " + string));
                        }
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        CompileMOF.this.logger.error((Object)iOException);
                        iOException.printStackTrace();
                    }
                }
            });
            thread.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (null != (string2 = bufferedReader.readLine())) {
                if (string2.equals("Compilation succeeded.")) {
                    n = 1;
                }
                this.logger.debug((Object)("Compilation Output: " + string2));
            }
            bufferedReader.close();
            process.waitFor();
        }
        catch (IOException iOException) {
            this.logger.error((Object)iOException);
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            this.logger.error((Object)interruptedException);
            interruptedException.printStackTrace();
        }
        return n;
    }

    private void createBat() {
        String string = "cd " + SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM");
        this.logger.info((Object)("CIMOM executed from path " + string));
        String string2 = SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM").substring(0, 2);
        try {
            FileWriter fileWriter = new FileWriter("resources/RUN_CIMOM.bat");
            fileWriter.write("echo \"Started Execution of start_cimom.bat\"");
            fileWriter.write("\n");
            fileWriter.write(string2);
            fileWriter.write("\n");
            fileWriter.write(string);
            fileWriter.write("\n");
            fileWriter.write("start simulator_start_cimom.bat");
            fileWriter.write("\n");
            fileWriter.write("echo \"Execution Stopped\"");
            fileWriter.write("\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int compile() {
        CompileMOF compileMOF = new CompileMOF();
        int n = -1;
        if (compileMOF.startCimom() && compileMOF.compileMof()) {
            n = 1;
        }
        return n;
    }

    private boolean startCimom() {
        boolean bl = false;
        startCimomCommand = "resources" + File.separator + "RUN_CIMOM.bat";
        this.createBat();
        StartCimom startCimom = new StartCimom();
        startCimom.start();
        try {
            Thread.sleep(20000L);
            bl = true;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return bl;
    }

    private boolean compileMof() {
        boolean bl = true;
        File file = new File(SetupWizardUtility.getProperty("MOF_FILE_PATH"));
        if (file.isDirectory()) {
            int n;
            File[] fileArray = file.listFiles();
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].getAbsoluteFile().toString().contains("Interop")) continue;
                compileMofFileCommand = "\"" + SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM") + "\\wbemservices\\bin\\mofcomp.bat" + "\"" + "  -u administrator -p passw0rd " + "\"" + fileArray[n].getAbsolutePath();
                this.logger.debug((Object)("Compile Mof Command: " + compileMofFileCommand));
                if (this.executeCommand(compileMofFileCommand) == 1) continue;
                return false;
            }
            for (n = 0; n < fileArray.length; ++n) {
                if (fileArray[n].getAbsoluteFile().toString().contains("Interop")) continue;
                compileMofFileCommand = "\"" + SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM") + "\\wbemservices\\bin\\mofcomp.bat" + "\"" + "  -u administrator -p passw0rd " + "\"" + fileArray[n].getAbsolutePath();
                this.logger.debug((Object)("Compile Mof Command: " + compileMofFileCommand));
                if (this.executeCommand(compileMofFileCommand) == 1) continue;
                return false;
            }
        }
        return bl;
    }
}

