/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.cimom.DS4K.DS4KCimomDataGenerator;
import org.eclipse.aperi.simulator.cimom.DS6K.DS6KCimomDataGenerator;
import org.eclipse.aperi.simulator.cimom.DS8K.DS8KGenerator;
import org.eclipse.aperi.simulator.cimom.brocade.BrocadeCIMOMDataGenerator;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class ConfigDataGenerator {
    private Logger logger = Logger.getLogger((Class)ConfigDataGenerator.class);

    public void generator(String string, String string2) {
        DS6KCimomDataGenerator dS6KCimomDataGenerator;
        if (string2.equalsIgnoreCase("DS6K_5.1.0.40")) {
            this.logger.debug((Object)"Generating data for DS6K_5.1.0.40");
            dS6KCimomDataGenerator = new DS6KCimomDataGenerator();
            dS6KCimomDataGenerator.generateData(string);
        }
        if (string2.equalsIgnoreCase("DS8K_5.1.0.40")) {
            this.logger.debug((Object)"Generating data for DS8K_5.1.0.40");
            dS6KCimomDataGenerator = new DS8KGenerator();
            dS6KCimomDataGenerator.generateData(string);
        } else if (string2.equalsIgnoreCase("DS4K_9.16.G0.06")) {
            this.logger.debug((Object)"Generating data for DS4K_9.16.G0.06");
            dS6KCimomDataGenerator = new DS4KCimomDataGenerator();
            dS6KCimomDataGenerator.generateData(string);
        } else if (string2.equalsIgnoreCase("Brocade_110.4.0a")) {
            this.logger.debug((Object)"Generating data for Brocade_110.4.0a");
            dS6KCimomDataGenerator = new BrocadeCIMOMDataGenerator();
            try {
                dS6KCimomDataGenerator.generateData();
            }
            catch (Exception exception) {
                this.logger.error((Object)("Error in Data Generatiion for Brocade: " + exception));
            }
        }
    }

    public void ConfigureDBForConfiguration() {
        Properties properties = new Properties();
        properties.setProperty("DATABASE", "db2");
        properties.setProperty("DB_NAME", SetupWizardUtility.getProperty("DB_NAME"));
        properties.setProperty("DB_USERNAME", SetupWizardUtility.getProperty("DB_USER_NAME"));
        properties.setProperty("DB_PASSWORD", SetupWizardUtility.getProperty("DB_PASSWORD"));
        properties.setProperty("DB_LOCATION", SetupWizardUtility.getProperty("DB_HOST_URL"));
        try {
            File file = File.createTempFile("setupwizard", ".config");
            file.deleteOnExit();
            properties.store(new FileOutputStream(file), "SETUP WIZARD PROPERTIES");
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", file.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

