/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.wbem.cim.CIMException;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.RemoteCIMClient;
import org.eclipse.aperi.simulator.ui.TargetDeviceDBClient;
import org.eclipse.aperi.simulator.ui.TestDBConnection;
import org.eclipse.aperi.simulator.ui.TestWbemCimomConnection;

public final class ConnectionScreens
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GridBagLayout layout = new GridBagLayout();
    private JTextField jtfCIMOMUrl;
    private JTextField jtfCIMOMNmSpace;
    private JTextField jtfCIMOMPort;
    private JTextField jtfCIMOMUserName;
    private JPasswordField jpfCIMOMPassword;
    private JComboBox jcbCIMOMProtocol;
    private JTextField jtfDBUrl;
    private JTextField jtfDBName;
    private JTextField jtfDBUid;
    private JPasswordField jtfDBPwd;
    private JList switchPortList;
    private JList portConnList;
    private JList otherDevicePortList;
    private JComboBox jcbSwitches;
    private JComboBox jcbOtherDevices;
    private JComboBox jcbSourcefabric;
    private JComboBox jcbDestFabric;
    private boolean deviceConncted = false;
    private JComboBox jcbSwitchOption;
    private JComboBox jcbStorageOption;
    private JComboBox jcbHostOption;
    private JRadioButton jrbSwitchToSwitch;
    private JRadioButton jrbSwitchToStorage;
    private JRadioButton jrbSwitchToHost;
    private boolean isConnectOptionSet;
    private boolean isSwitchDBConfig;
    private boolean isTargetDevcieDBConfig;
    private boolean isCIMOMConfig;
    private Logger logger = Logger.getLogger((Class)ConnectionScreens.class);

    public JPanel getConnectionOption() {
        JPanel jPanel = new JPanel(this.layout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        String[] stringArray = new String[]{ConnectionUtility.DB_CLIENT, ConnectionUtility.CIM_CLIENT};
        String[] stringArray2 = new String[]{ConnectionUtility.SWITCH_CLIENT};
        String[] stringArray3 = new String[]{ConnectionUtility.DB_CLIENT, ConnectionUtility.CIM_CLIENT};
        JLabel jLabel = new JLabel("<html><b>Please specify Device Connectivity</b><br><br> <br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        this.addComponent(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1);
        JPanel jPanel2 = new JPanel(this.layout);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Connect Option"));
        this.jrbSwitchToSwitch = new JRadioButton("Switch To Switch Connection");
        this.jrbSwitchToStorage = new JRadioButton("Switch To Storage Connection");
        this.jrbSwitchToHost = new JRadioButton("Switch To Host Connection");
        this.jrbSwitchToHost.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbSwitchToSwitch);
        buttonGroup.add(this.jrbSwitchToStorage);
        buttonGroup.add(this.jrbSwitchToHost);
        this.jrbSwitchToSwitch.addItemListener(new RadioButtonHandler("ToSwitch"));
        this.jrbSwitchToStorage.addItemListener(new RadioButtonHandler("ToStorage"));
        this.jrbSwitchToHost.addItemListener(new RadioButtonHandler("ToHost"));
        this.jcbSwitchOption = new JComboBox<String>(stringArray2);
        this.jcbSwitchOption.setEnabled(false);
        this.jcbStorageOption = new JComboBox<String>(stringArray);
        this.jcbStorageOption.setEnabled(false);
        this.jcbHostOption = new JComboBox<String>(stringArray3);
        this.jcbHostOption.setEnabled(false);
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.insets.left = 10;
        this.addComponent(jPanel2, this.jrbSwitchToSwitch, gridBagConstraints, 0, 0, 1, 1);
        this.addComponent(jPanel2, this.jcbSwitchOption, gridBagConstraints, 0, 1, 1, 1);
        this.addComponent(jPanel2, this.jrbSwitchToStorage, gridBagConstraints, 1, 0, 1, 1);
        this.addComponent(jPanel2, this.jcbStorageOption, gridBagConstraints, 1, 1, 1, 1);
        this.addComponent(jPanel2, this.jrbSwitchToHost, gridBagConstraints, 2, 0, 1, 1);
        this.addComponent(jPanel2, this.jcbHostOption, gridBagConstraints, 2, 1, 1, 1);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        this.addComponent(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        if (this.isConnectOptionSet) {
            if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_SWITCH)) {
                this.jrbSwitchToSwitch.doClick();
                this.jcbSwitchOption.setSelectedItem(ConnectionUtility.ConnectMedium);
            } else if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_ARRAY)) {
                this.jrbSwitchToStorage.doClick();
                this.jcbStorageOption.setSelectedItem(ConnectionUtility.ConnectMedium);
            }
        }
        return jPanel;
    }

    public JPanel getDeviceConnected() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Please specify device Connectivity</b><br><br><br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        this.addComponent(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1);
        JPanel jPanel2 = new JPanel(this.layout);
        JLabel jLabel2 = new JLabel("Source Fabric");
        ConnectionUtility.initDeviceConnect();
        this.jcbSourcefabric = new JComboBox(ConnectionUtility.getFabricNames());
        this.jcbSourcefabric.setSelectedIndex(0);
        this.jcbSourcefabric.setPreferredSize(new Dimension(150, 20));
        this.jcbSourcefabric.addItemListener(new SourceFabricSelect());
        JLabel jLabel3 = new JLabel("Destination Fabric");
        this.jcbDestFabric = new JComboBox(ConnectionUtility.getFabricNames());
        this.jcbDestFabric.setEnabled(false);
        this.jcbDestFabric.setPreferredSize(new Dimension(150, 20));
        JLabel jLabel4 = new JLabel("Connect Switch");
        this.jcbSwitches = new JComboBox(ConnectionUtility.switchnamesVector);
        this.jcbSwitches.setPreferredSize(new Dimension(150, 20));
        this.jcbSwitches.setEnabled(false);
        JLabel jLabel5 = new JLabel("Target Device");
        this.jcbOtherDevices = new JComboBox(ConnectionUtility.otherDevicesvector);
        this.jcbOtherDevices.setPreferredSize(new Dimension(150, 20));
        this.jcbOtherDevices.setEnabled(false);
        this.jcbSwitches.addItemListener(new DeviceSelect());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Device Connection"));
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.insets.bottom = 25;
        this.addComponent(jPanel2, jLabel2, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.insets.right = 20;
        this.addComponent(jPanel2, this.jcbSourcefabric, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.insets.right = 0;
        this.addComponent(jPanel2, jLabel3, gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.insets.right = 20;
        this.addComponent(jPanel2, this.jcbDestFabric, gridBagConstraints, 0, 4, 1, 1);
        this.addComponent(jPanel2, jLabel4, gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.insets.right = 20;
        this.addComponent(jPanel2, this.jcbSwitches, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.insets.right = 0;
        this.addComponent(jPanel2, jLabel5, gridBagConstraints, 1, 3, 1, 1);
        gridBagConstraints.insets.right = 0;
        this.addComponent(jPanel2, this.jcbOtherDevices, gridBagConstraints, 1, 4, 1, 1);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.right = 0;
        this.addComponent(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        return jPanel;
    }

    public JPanel getDBInfoForSwitchScreen() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Enter the database details For Simulated Switch</b><br><br>If local database is used and current logged in user has admin permissions on the database, then \ufffdUser Name\ufffd and \ufffdPassword\ufffd fields can be left blank.<br>You can test the connection to the database using <b>\ufffdTest DB Connection\ufffd</b> button.<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        this.addComponent(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1);
        JPanel jPanel2 = new JPanel(this.layout);
        jPanel2.setBorder(BorderFactory.createTitledBorder("DB Inputs"));
        this.jtfDBUrl = new JTextField(20);
        JLabel jLabel2 = new JLabel("DB URL");
        this.jtfDBUrl.setText("localhost");
        this.jtfDBName = new JTextField(20);
        JLabel jLabel3 = new JLabel("DB Name");
        this.jtfDBName.setText("SIMDB");
        this.jtfDBName.setEditable(false);
        this.jtfDBUid = new JTextField(20);
        JLabel jLabel4 = new JLabel("User Name");
        this.jtfDBPwd = new JPasswordField(16);
        JLabel jLabel5 = new JLabel("Password");
        JButton jButton = new JButton("Test DB Connection");
        jButton.setActionCommand("TestDB");
        jButton.addActionListener(new ButtonListener());
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.fill = 0;
        this.addComponent(jPanel2, jLabel2, gridBagConstraints, 0, 0, 1, 1);
        this.addComponent(jPanel2, this.jtfDBUrl, gridBagConstraints, 0, 1, 1, 1);
        this.addComponent(jPanel2, jLabel3, gridBagConstraints, 1, 0, 1, 1);
        this.addComponent(jPanel2, this.jtfDBName, gridBagConstraints, 1, 1, 1, 1);
        this.addComponent(jPanel2, jLabel4, gridBagConstraints, 2, 0, 1, 1);
        this.addComponent(jPanel2, this.jtfDBUid, gridBagConstraints, 2, 1, 1, 1);
        this.addComponent(jPanel2, jLabel5, gridBagConstraints, 3, 0, 1, 1);
        this.addComponent(jPanel2, this.jtfDBPwd, gridBagConstraints, 3, 1, 1, 1);
        this.addComponent(jPanel2, jButton, gridBagConstraints, 4, 1, 1, 1);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 2;
        this.addComponent(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        if (this.isSwitchDBConfig) {
            this.jtfDBUrl.setText(ConnectionUtility.switchDBUrl);
            this.jtfDBName.setText(ConnectionUtility.switchDBName);
            this.jtfDBUid.setText(ConnectionUtility.switchDBUserid);
            this.jtfDBPwd.setText(ConnectionUtility.switchDBPassword);
        }
        return jPanel;
    }

    public JPanel getDBInfoForTargetrDeviceScreen() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Enter the database details For Simulated Target Device</b><br><br>If local database is used and current logged in user has admin permissions on the database, then \ufffdUser Name\ufffd and \ufffdPassword\ufffd fields can be left blank.<br>You can test the connection to the database using <b>\ufffdTest DB Connection\ufffd</b> button.<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        this.addComponent(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1);
        JPanel jPanel2 = new JPanel(this.layout);
        jPanel2.setBorder(BorderFactory.createTitledBorder("DB Inputs"));
        this.jtfDBUrl = new JTextField(20);
        JLabel jLabel2 = new JLabel("DB URL");
        this.jtfDBName = new JTextField(20);
        JLabel jLabel3 = new JLabel("DB Name");
        this.jtfDBName.setText("SIMDB");
        this.jtfDBName.setEditable(false);
        this.jtfDBUid = new JTextField(20);
        JLabel jLabel4 = new JLabel("User Name");
        this.jtfDBPwd = new JPasswordField(16);
        JLabel jLabel5 = new JLabel("Password");
        JButton jButton = new JButton("Test DB Connection");
        jButton.setActionCommand("TestDB");
        jButton.addActionListener(new ButtonListener());
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.fill = 0;
        this.addComponent(jPanel2, jLabel2, gridBagConstraints, 0, 0, 1, 1);
        this.addComponent(jPanel2, this.jtfDBUrl, gridBagConstraints, 0, 1, 1, 1);
        this.addComponent(jPanel2, jLabel3, gridBagConstraints, 1, 0, 1, 1);
        this.addComponent(jPanel2, this.jtfDBName, gridBagConstraints, 1, 1, 1, 1);
        this.addComponent(jPanel2, jLabel4, gridBagConstraints, 2, 0, 1, 1);
        this.addComponent(jPanel2, this.jtfDBUid, gridBagConstraints, 2, 1, 1, 1);
        this.addComponent(jPanel2, jLabel5, gridBagConstraints, 3, 0, 1, 1);
        this.addComponent(jPanel2, this.jtfDBPwd, gridBagConstraints, 3, 1, 1, 1);
        this.addComponent(jPanel2, jButton, gridBagConstraints, 4, 1, 1, 1);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 2;
        this.addComponent(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        if (this.isTargetDevcieDBConfig) {
            this.jtfDBUrl.setText(ConnectionUtility.targetDevcieDBUrl);
            this.jtfDBName.setText(ConnectionUtility.targetDevcieDBName);
            this.jtfDBUid.setText(ConnectionUtility.targetDevcieDBUserid);
            this.jtfDBPwd.setText(ConnectionUtility.targetDevcieDBPassword);
        }
        return jPanel;
    }

    public JPanel getCIMOMInfoScreen() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = new String[]{"http", "https"};
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Please specify CIMOM Configuration</b><br><br><br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        this.addComponent(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1);
        JPanel jPanel2 = new JPanel(this.layout);
        jPanel2.setBorder(BorderFactory.createTitledBorder("CIMOM Inputs"));
        this.jtfCIMOMUrl = new JTextField(20);
        JLabel jLabel2 = new JLabel("Host URL");
        this.jtfCIMOMPort = new JTextField(20);
        JLabel jLabel3 = new JLabel("Port");
        this.jtfCIMOMUserName = new JTextField(20);
        JLabel jLabel4 = new JLabel("User Name");
        this.jpfCIMOMPassword = new JPasswordField(16);
        JLabel jLabel5 = new JLabel("Password");
        this.jtfCIMOMNmSpace = new JTextField(20);
        JLabel jLabel6 = new JLabel("NameSpace");
        this.jcbCIMOMProtocol = new JComboBox<String>(stringArray);
        JLabel jLabel7 = new JLabel("Protocol");
        this.jcbCIMOMProtocol.setPreferredSize(new Dimension(166, 20));
        JButton jButton = new JButton("Test CIMOM COnnection");
        jButton.setActionCommand("TestCIMOM");
        jButton.addActionListener(new ButtonListener());
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.fill = 0;
        this.addComponent(jPanel2, this.jtfCIMOMUrl, gridBagConstraints, 0, 1, 1, 1);
        this.addComponent(jPanel2, this.jtfCIMOMPort, gridBagConstraints, 1, 1, 1, 1);
        this.addComponent(jPanel2, this.jtfCIMOMUserName, gridBagConstraints, 2, 1, 1, 1);
        this.addComponent(jPanel2, this.jpfCIMOMPassword, gridBagConstraints, 3, 1, 1, 1);
        this.addComponent(jPanel2, this.jtfCIMOMNmSpace, gridBagConstraints, 4, 1, 1, 1);
        this.addComponent(jPanel2, this.jcbCIMOMProtocol, gridBagConstraints, 5, 1, 1, 1);
        this.addComponent(jPanel2, jLabel3, gridBagConstraints, 1, 0, 1, 1);
        this.addComponent(jPanel2, jLabel2, gridBagConstraints, 0, 0, 1, 1);
        this.addComponent(jPanel2, jLabel4, gridBagConstraints, 2, 0, 1, 1);
        this.addComponent(jPanel2, jLabel5, gridBagConstraints, 3, 0, 1, 1);
        this.addComponent(jPanel2, jLabel6, gridBagConstraints, 4, 0, 1, 1);
        this.addComponent(jPanel2, jLabel7, gridBagConstraints, 5, 0, 1, 1);
        this.addComponent(jPanel2, jButton, gridBagConstraints, 6, 1, 1, 1);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.fill = 2;
        this.addComponent(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        if (this.isCIMOMConfig) {
            this.jtfCIMOMUrl.setText(ConnectionUtility.CIMOMHostUrl);
            this.jtfCIMOMPort.setText(ConnectionUtility.CIMOMPort);
            this.jtfCIMOMUserName.setText(ConnectionUtility.CIMOMUserName);
            this.jtfCIMOMNmSpace.setText(ConnectionUtility.CIMOMNameSpace);
            this.jpfCIMOMPassword.setText(ConnectionUtility.CIMOMPassword);
            this.jcbCIMOMProtocol.setSelectedItem(ConnectionUtility.CIMOMProtocol);
        }
        return jPanel;
    }

    public JPanel getPortConnection() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Please specify Port Connections between devices</b><br><br><br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        this.addComponent(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel3 = new JPanel(new FlowLayout());
        this.switchPortList = new JList(ConnectionUtility.getSwitchPorts());
        this.switchPortList.setVisibleRowCount(5);
        this.switchPortList.setSelectionMode(0);
        jPanel3.add(new JScrollPane(this.switchPortList, 20, 32));
        jPanel3.setBorder(BorderFactory.createTitledBorder("SwitchPorts"));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.otherDevicePortList = new JList(ConnectionUtility.getTargetDevicePorts());
        this.otherDevicePortList.setVisibleRowCount(5);
        this.otherDevicePortList.setSelectionMode(0);
        jPanel4.add(new JScrollPane(this.otherDevicePortList, 22, 32));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Other DevicePort"));
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(this.layout);
        JButton jButton = new JButton("Add >");
        JButton jButton2 = new JButton("Remove <");
        jButton.setActionCommand("Add");
        jButton2.setActionCommand("Remove");
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        this.addComponent(jPanel5, jButton, gridBagConstraints, 2, 0, 1, 1);
        this.addComponent(jPanel5, jButton2, gridBagConstraints, 4, 0, 1, 1);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        this.portConnList = new JList(ConnectionUtility.getPortConnections());
        this.portConnList.setSelectionMode(0);
        this.portConnList.setVisibleRowCount(5);
        jPanel6.setBorder(BorderFactory.createTitledBorder("Port Connections"));
        jPanel6.add(new JScrollPane(this.portConnList));
        jButton.addActionListener(new ButtonListener());
        jButton2.addActionListener(new ButtonListener());
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        this.addComponent(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        this.addComponent(jPanel, jPanel6, gridBagConstraints, 2, 0, 1, 1);
        return jPanel;
    }

    private void addComponent(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.layout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
    }

    private ConnectionScreens() {
        super("SAN Simulation Installer");
        this.setDefaultCloseOperation(3);
    }

    public boolean connectionConfigSet() {
        boolean bl = false;
        if (this.jrbSwitchToSwitch.isSelected() || this.jrbSwitchToHost.isSelected() || this.jrbSwitchToStorage.isSelected()) {
            bl = true;
        }
        return bl;
    }

    public boolean isSwitchDBConfig() {
        boolean bl = true;
        if (this.jtfDBUrl.getText().equals("localhost") || this.jtfDBUrl.getText().equals("127.0.0.1")) {
            ConnectionUtility.isSwitchDBLocal = true;
            return bl;
        }
        String string = this.jtfDBUrl.getText();
        String string2 = this.jtfDBName.getText();
        String string3 = this.jtfDBUid.getText();
        String string4 = new String(this.jtfDBPwd.getPassword());
        if (string.equals("")) {
            bl = false;
        } else if (string2.equals("")) {
            bl = false;
        } else if (string3.equals("")) {
            bl = false;
        } else if (string4.equals("")) {
            bl = false;
        }
        if (bl && !ConnectionUtility.isSwitchDBLocal) {
            if (new TestDBConnection().testConnection(string2, string3, string4, string) == 0) {
                JOptionPane.showMessageDialog(null, "Remote database does not exist ! Please create DB at remote machine first", "Remote DB Fail", 0);
                System.exit(0);
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isTargetDevcieDBConfig() {
        boolean bl = true;
        if (this.jtfDBUrl.getText().equals("localhost") || this.jtfDBUrl.getText().equals("127.0.0.1")) {
            ConnectionUtility.isOtherDBLocal = true;
            return bl;
        }
        if (this.jtfDBUrl.getText().equals("")) {
            bl = false;
        } else if (this.jtfDBName.getText().equals("")) {
            bl = false;
        } else if (this.jtfDBUid.getText().equals("")) {
            bl = false;
        } else if (new String(this.jtfDBPwd.getPassword()).equals("")) {
            bl = false;
        }
        return bl;
    }

    public boolean isCIMOMConfig() {
        boolean bl = true;
        if (this.jtfCIMOMUrl.getText().equals("")) {
            bl = false;
        } else if (this.jtfCIMOMPort.getText().equals("")) {
            bl = false;
        } else if (this.jtfCIMOMNmSpace.getText().equals("")) {
            bl = false;
        } else if (this.jtfCIMOMUserName.getText().equals("")) {
            bl = false;
        } else if (new String(this.jpfCIMOMPassword.getPassword()).equals("")) {
            bl = false;
        }
        if (bl) {
            String string = this.jtfCIMOMUrl.getText();
            String string2 = this.jtfCIMOMPort.getText();
            String string3 = this.jtfCIMOMNmSpace.getText();
            String string4 = this.jtfCIMOMUserName.getText();
            String string5 = new String(this.jpfCIMOMPassword.getPassword());
            String string6 = (String)this.jcbCIMOMProtocol.getSelectedItem();
            try {
                if (new TestWbemCimomConnection().testConnection(string, string2, string4, string5, string3, string6) == 0) {
                    JOptionPane.showMessageDialog(null, "CIMOM Connection Failed.Please Check CIMOM Configuration", "CIMOM Connection", 0);
                    this.logger.info((Object)"CIMOM Connection Falied");
                    bl = false;
                }
            }
            catch (CIMException cIMException) {
                this.logger.error((Object)("CIMOM Test Connection Exception: " + (Object)((Object)cIMException)));
            }
        }
        return bl;
    }

    public boolean deviceConfigSet() {
        boolean bl = true;
        if (ConnectionUtility.isLocal) {
            return bl;
        }
        if (this.jtfCIMOMUrl.getText() == "") {
            bl = false;
        } else if (this.jtfCIMOMPort.getText() == "") {
            bl = false;
        } else if (this.jtfCIMOMUserName.getText() == "") {
            bl = false;
        } else if (this.jtfCIMOMNmSpace.getText() == "") {
            bl = false;
        } else if (new String(this.jpfCIMOMPassword.getPassword()).equals("")) {
            bl = false;
        }
        return bl;
    }

    public boolean isPortConnected() {
        boolean bl = true;
        if (ConnectionUtility.portConnections.size() == 0) {
            bl = false;
        }
        return bl;
    }

    public boolean isDevcieConnected() {
        boolean bl = true;
        if (this.jcbSwitches.getSelectedItem() == "" || this.jcbOtherDevices.getSelectedItem() == "") {
            bl = false;
            this.deviceConncted = false;
        }
        return bl;
    }

    public void saveDeviceConnection() {
        ConnectionUtility.switchName = (String)this.jcbSwitches.getSelectedItem();
        ConnectionUtility.deviceName = (String)this.jcbOtherDevices.getSelectedItem();
        ConnectionUtility.sourceFabric = (String)this.jcbSourcefabric.getSelectedItem();
        ConnectionUtility.destFabric = (String)this.jcbDestFabric.getSelectedItem();
        this.deviceConncted = true;
        this.logger.debug((Object)("Device Connectivity: " + ConnectionUtility.switchName + " " + ConnectionUtility.deviceName));
    }

    public void savePortConnections() {
        Iterator iterator = ConnectionUtility.portConnections.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = string.split(" --> ");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            ConnectionUtility.switchPortConnected.add(string2);
            ConnectionUtility.oDevicePortConnected.add(string3);
        }
    }

    public void saveConnectionConf() {
        ConnectionUtility.ConnectMedium = this.jrbSwitchToSwitch.isSelected() ? (String)this.jcbSwitchOption.getSelectedItem() : (this.jrbSwitchToStorage.isSelected() ? (String)this.jcbStorageOption.getSelectedItem() : (String)this.jcbHostOption.getSelectedItem());
        this.logger.debug((Object)("Connection specified: " + ConnectionUtility.ConnectMedium));
        this.isConnectOptionSet = true;
    }

    public void saveSwitchDBConfiguration() {
        ConnectionUtility.switchDBUrl = this.jtfDBUrl.getText();
        ConnectionUtility.switchDBName = this.jtfDBName.getText();
        ConnectionUtility.switchDBUserid = this.jtfDBUid.getText();
        ConnectionUtility.switchDBPassword = new String(this.jtfDBPwd.getPassword());
        this.isSwitchDBConfig = true;
        this.logger.debug((Object)("Switch DB Configuration: " + ConnectionUtility.switchDBUrl + " " + ConnectionUtility.switchDBName + " " + ConnectionUtility.switchDBUserid + " " + ConnectionUtility.switchDBPassword));
    }

    public void saveTargetDevcieDBConfiguration() {
        ConnectionUtility.targetDevcieDBUrl = this.jtfDBUrl.getText();
        ConnectionUtility.targetDevcieDBName = this.jtfDBName.getText();
        ConnectionUtility.targetDevcieDBUserid = this.jtfDBUid.getText();
        ConnectionUtility.targetDevcieDBPassword = new String(this.jtfDBPwd.getPassword());
        this.isTargetDevcieDBConfig = true;
        this.logger.debug((Object)("Target Device DB Configuration: " + ConnectionUtility.targetDevcieDBUrl + " " + ConnectionUtility.targetDevcieDBName + " " + ConnectionUtility.targetDevcieDBUserid + " " + ConnectionUtility.targetDevcieDBPassword));
    }

    public void saveCIMOMConfiguration() {
        ConnectionUtility.CIMOMHostUrl = this.jtfCIMOMUrl.getText();
        ConnectionUtility.CIMOMPort = this.jtfCIMOMPort.getText();
        ConnectionUtility.CIMOMNameSpace = this.jtfCIMOMNmSpace.getText();
        ConnectionUtility.CIMOMUserName = this.jtfCIMOMUserName.getText();
        ConnectionUtility.CIMOMPassword = new String(this.jpfCIMOMPassword.getPassword());
        ConnectionUtility.CIMOMProtocol = (String)this.jcbCIMOMProtocol.getSelectedItem();
        this.logger.debug((Object)("CIMOM Configuration specified: " + ConnectionUtility.CIMOMHostUrl + " " + ConnectionUtility.CIMOMPort + " " + ConnectionUtility.CIMOMUserName + " " + ConnectionUtility.CIMOMPassword + " " + ConnectionUtility.CIMOMNameSpace + ConnectionUtility.CIMOMProtocol));
        this.isCIMOMConfig = true;
    }

    public static ConnectionScreens getInstance() {
        return ConnectionScreenHandler.instance;
    }

    public void saveConnectionPropToFile() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("resources" + File.separator + "ConnectionSimulation.Properties");
            Properties properties = new Properties();
            String string = "SWITCH[" + ConnectionUtility.switchName + "]";
            String string2 = null;
            if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_SWITCH)) {
                string2 = "SWITCH[" + ConnectionUtility.deviceName + "]";
                properties.setProperty("SWITCH_CONNECTED_TO", "Switch");
            }
            properties.setProperty("SOURCE_FABRIC_ID", ConnectionUtility.sourceFabric);
            properties.setProperty("DESTINATION_FABRIC_ID", ConnectionUtility.destFabric);
            properties.setProperty("SWITCH_DB_NAME", ConnectionUtility.switchDBName);
            properties.setProperty("SWITCH_DB_URL", ConnectionUtility.switchDBUrl);
            if (!ConnectionUtility.switchDBPassword.equals("")) {
                properties.setProperty("SWITCH_DB_USERNAME", ConnectionUtility.switchDBUserid);
                properties.setProperty("SWITCH_DB_PASSWORD", ConnectionUtility.switchDBPassword);
            } else {
                properties.setProperty("SWITCH_DB_USERNAME", "Default");
                properties.setProperty("SWITCH_DB_PASSWORD", "Default");
            }
            if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_ARRAY)) {
                properties.setProperty("SWITCH_CONNECTED_TO", "Storage");
                string2 = "STORAGE[" + ConnectionUtility.deviceName + "]";
                if (ConnectionUtility.ConnectMedium.equals(ConnectionUtility.CIM_CLIENT)) {
                    properties.setProperty("TARGET_DEVICE_CLIENT", "CIM Client");
                    properties.setProperty("STORAGE_DEVICE_CATEGORY", RemoteCIMClient.deviceType);
                    properties.setProperty("TARGET_DEVICE_CIMOM_URL", ConnectionUtility.CIMOMHostUrl);
                    properties.setProperty("TARGET_DEVICE_CIMOM_PORT", ConnectionUtility.CIMOMPort);
                    properties.setProperty("TARGET_DEVICE_CIMOM_URL", ConnectionUtility.CIMOMUserName);
                    properties.setProperty("TARGET_DEVICE_CIMOM_PASSWORD", ConnectionUtility.CIMOMPassword);
                    properties.setProperty("TARGET_DEVICE_CIMOM_NAMESPACE", ConnectionUtility.CIMOMNameSpace);
                    properties.setProperty("TARGET_DEVICE_CIMOM_PROTOCOL", ConnectionUtility.CIMOMProtocol);
                } else if (ConnectionUtility.ConnectMedium.equals(ConnectionUtility.DB_CLIENT)) {
                    properties.setProperty("TARGET_DEVICE_CLIENT", "DB Client");
                    properties.setProperty("STORAGE_DEVICE_CATEGORY", TargetDeviceDBClient.storageDeviceCategory);
                    properties.setProperty("TARGET_DEVICE_DB_NAME", ConnectionUtility.targetDevcieDBName);
                    properties.setProperty("TARGET_DEVICE_DB_URL", ConnectionUtility.targetDevcieDBUrl);
                    if (!ConnectionUtility.targetDevcieDBPassword.equals("")) {
                        properties.setProperty("TARGET_DEVICE_DB_USERNAME", ConnectionUtility.targetDevcieDBUserid);
                        properties.setProperty("TARGET_DEVICE_DB_PASSWORD", ConnectionUtility.targetDevcieDBPassword);
                    } else {
                        properties.setProperty("TARGET_DEVICE_DB_USERNAME", "Default");
                        properties.setProperty("TARGET_DEVICE_DB_PASSWORD", "Default");
                    }
                }
            }
            String string3 = string + ":" + string2;
            properties.setProperty("DEVICE_CONNECTIVTY", string3);
            Iterator iterator = ConnectionUtility.switchPortConnected.iterator();
            Iterator iterator2 = ConnectionUtility.oDevicePortConnected.iterator();
            String string4 = "";
            int n = 0;
            while (iterator.hasNext() && iterator2.hasNext()) {
                if (n != 0) {
                    string4 = string4 + ",";
                }
                String string5 = (String)iterator.next();
                String string6 = (String)iterator2.next();
                string4 = string4 + string5 + ":" + string6;
                ++n;
            }
            properties.setProperty("PORT_CONNECTIVITY", string4);
            properties.store(fileOutputStream, "SAN Simulator Properties");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static class ConnectionScreenHandler {
        private static ConnectionScreens instance = new ConnectionScreens();

        private ConnectionScreenHandler() {
        }
    }

    protected class ButtonListener
    implements ActionListener {
        protected ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "Add") {
                if (ConnectionScreens.this.switchPortList.isSelectionEmpty() || ConnectionScreens.this.otherDevicePortList.isSelectionEmpty()) {
                    JOptionPane.showMessageDialog(null, "Please select ports from both devices.", "Invalid Connection", 0);
                } else {
                    String string = ConnectionScreens.this.switchPortList.getSelectedValue() + " --> " + ConnectionScreens.this.otherDevicePortList.getSelectedValue();
                    ConnectionUtility.setPortConnections(string);
                    ConnectionUtility.switchPortAvailable.remove(ConnectionScreens.this.switchPortList.getSelectedValue());
                    ConnectionUtility.devicePortAvailable.remove(ConnectionScreens.this.otherDevicePortList.getSelectedValue());
                    ConnectionScreens.this.switchPortList.setListData(ConnectionUtility.switchPortAvailable);
                    ConnectionScreens.this.otherDevicePortList.setListData(ConnectionUtility.devicePortAvailable);
                    ConnectionScreens.this.portConnList.setListData(ConnectionUtility.getPortConnections());
                }
            } else if (actionEvent.getActionCommand() == "Remove") {
                String string = (String)ConnectionScreens.this.portConnList.getSelectedValue();
                String[] stringArray = string.split("-->");
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                ConnectionUtility.switchPortAvailable.add(string2);
                ConnectionUtility.devicePortAvailable.add(string3);
                ConnectionScreens.this.switchPortList.setListData(ConnectionUtility.switchPortAvailable);
                ConnectionScreens.this.otherDevicePortList.setListData(ConnectionUtility.devicePortAvailable);
                ConnectionUtility.portConnections.remove(ConnectionScreens.this.portConnList.getSelectedValue());
                ConnectionScreens.this.portConnList.setListData(ConnectionUtility.getPortConnections());
            } else if (actionEvent.getActionCommand() == "TestDB") {
                ConnectionScreens.this.setCursor(Cursor.getPredefinedCursor(3));
                String string = ConnectionScreens.this.jtfDBUrl.getText();
                String string4 = ConnectionScreens.this.jtfDBName.getText();
                String string5 = ConnectionScreens.this.jtfDBUid.getText();
                String string6 = new String(ConnectionScreens.this.jtfDBPwd.getPassword());
                if (string5.equals("")) {
                    string5 = "Default";
                }
                if (string6.equals("")) {
                    string6 = "Default";
                }
                if (new TestDBConnection().testConnection(string4, string5, string6, string) == 0) {
                    JOptionPane.showMessageDialog(null, "Database Connection Failed!", "DB Connection", 0);
                } else {
                    JOptionPane.showMessageDialog(null, "Databse Connection Successful", "DB Connection", 1);
                }
                ConnectionScreens.this.setCursor(Cursor.getDefaultCursor());
            } else if (actionEvent.getActionCommand() == "TestCIMOM") {
                ConnectionScreens.this.setCursor(Cursor.getPredefinedCursor(3));
                String string = ConnectionScreens.this.jtfCIMOMUrl.getText();
                String string7 = ConnectionScreens.this.jtfCIMOMPort.getText();
                String string8 = ConnectionScreens.this.jtfCIMOMUserName.getText();
                String string9 = ConnectionScreens.this.jtfCIMOMNmSpace.getText();
                String string10 = (String)ConnectionScreens.this.jcbCIMOMProtocol.getSelectedItem();
                String string11 = new String(ConnectionScreens.this.jpfCIMOMPassword.getPassword());
                try {
                    if (new TestWbemCimomConnection().testConnection(string, string7, string8, string11, string9, string10) == 0) {
                        JOptionPane.showMessageDialog(null, "CIMOM Connection Failed", "CIMOM Connection", 0);
                        ConnectionScreens.this.logger.info((Object)"CIMOM Connection Falied");
                    } else {
                        JOptionPane.showMessageDialog(null, "CIMOM Connection Successful", "CIMOM Connection", 1);
                        ConnectionScreens.this.logger.info((Object)"CIMOM Connection Successful");
                    }
                }
                catch (CIMException cIMException) {
                    ConnectionScreens.this.logger.error((Object)("CIMOM Test Connection Exception: " + actionEvent));
                }
                ConnectionScreens.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected class SourceFabricSelect
    implements ItemListener {
        protected SourceFabricSelect() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string = (String)ConnectionScreens.this.jcbSourcefabric.getSelectedItem();
                if (string != "") {
                    ConnectionScreens.this.jcbDestFabric.setEnabled(true);
                    ConnectionScreens.this.jcbDestFabric.setSelectedItem(string);
                    ConnectionScreens.this.jcbDestFabric.setEnabled(false);
                    ConnectionScreens.this.jcbSwitches.setEnabled(true);
                    ConnectionScreens.this.jcbOtherDevices.setEnabled(true);
                    ConnectionUtility.getSwitchNames(string);
                    ConnectionUtility.getDeviceToConnect();
                }
            } else {
                ConnectionUtility.resetSwitchNames();
                ConnectionUtility.resetOtherDeviceNames();
            }
        }
    }

    protected class DeviceSelect
    implements ItemListener {
        String prevSelected = null;

        protected DeviceSelect() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                ConnectionScreens.this.jcbOtherDevices.setSelectedIndex(0);
                String string = (String)ConnectionScreens.this.jcbSwitches.getSelectedItem();
                if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_SWITCH)) {
                    if (string != "") {
                        ConnectionUtility.otherDevicesvector.remove(string);
                    }
                    if (this.prevSelected != null && this.prevSelected != "") {
                        ConnectionUtility.otherDevicesvector.add(this.prevSelected);
                    }
                }
                this.prevSelected = string;
                ConnectionScreens.this.jcbOtherDevices.repaint();
            }
        }
    }

    protected class RadioButtonHandler
    implements ItemListener {
        private String option;

        public RadioButtonHandler(String string) {
            this.option = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (this.option.equals("ToSwitch")) {
                    ConnectionUtility.profileConnection = ConnectionUtility.SWITCH_TO_SWITCH;
                    ConnectionScreens.this.jcbStorageOption.setEnabled(false);
                    ConnectionScreens.this.jcbHostOption.setEnabled(false);
                    ConnectionScreens.this.jcbSwitchOption.setEnabled(true);
                } else if (this.option.equals("ToStorage")) {
                    ConnectionUtility.profileConnection = ConnectionUtility.SWITCH_TO_ARRAY;
                    ConnectionScreens.this.jcbStorageOption.setEnabled(true);
                    ConnectionScreens.this.jcbHostOption.setEnabled(false);
                    ConnectionScreens.this.jcbSwitchOption.setEnabled(false);
                } else if (this.option.equals("ToHost")) {
                    ConnectionUtility.profileConnection = ConnectionUtility.SWITCH_TO_HOST;
                    ConnectionScreens.this.jcbStorageOption.setEnabled(false);
                    ConnectionScreens.this.jcbHostOption.setEnabled(true);
                    ConnectionScreens.this.jcbSwitchOption.setEnabled(false);
                }
            }
        }
    }
}

