/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.ui.ButtonsPanel;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class CreateSetupScreen
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Container container = this.getContentPane();
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel jpMain = new JPanel(new BorderLayout());
    private JPanel jpBottom = new JPanel(new BorderLayout());
    private JPanel inputPanel;
    private JPanel buttonContainer;
    protected JProgressBar jProgressBar;
    protected JButton jbFinish;
    protected JButton jbCancel;
    protected JCheckBox jchbWbemInstall;
    protected JCheckBox jchbCreateMof;
    protected JCheckBox jchbDBCreated;
    protected JCheckBox jchbMofCompile;
    protected JLabel jlInfo;
    private Logger logger = Logger.getLogger((Class)CreateSetupScreen.class);

    public CreateSetupScreen() {
        super("SAN Simulator Setup Wizard");
        this.showPanel();
    }

    public void showPanel() {
        this.container = this.getContentPane();
        this.container.setLayout(this.layout);
        ButtonsPanel buttonsPanel = new ButtonsPanel();
        this.jbCancel = buttonsPanel.getCancelButton();
        this.jbFinish = buttonsPanel.getFinishButton();
        this.buttonContainer = new JPanel(new FlowLayout(2, 10, 5));
        this.buttonContainer.setBorder(BorderFactory.createEtchedBorder());
        this.jbCancel.setVisible(true);
        this.buttonContainer.add(this.jbCancel);
        this.jbFinish.setVisible(false);
        this.buttonContainer.add(this.jbFinish);
        this.inputPanel = ConnectionUtility.isSimConnection ? this.getConnectionSetupScreen() : this.getDeviceScreen();
        this.jpMain.add((Component)this.inputPanel, "Center");
        this.jpBottom.add((Component)this.buttonContainer, "South");
        ButtonHandler buttonHandler = new ButtonHandler();
        this.jbFinish.addActionListener(buttonHandler);
        this.jbCancel.addActionListener(buttonHandler);
        ImageIcon imageIcon = new ImageIcon("resources\\logo2_mm.gif");
        JLabel jLabel = new JLabel("", imageIcon, 2);
        this.addComponent(jLabel, 0, 0, 1, 5);
        this.constraints.weightx = 1000.0;
        this.constraints.fill = 2;
        this.jpMain.setBorder(BorderFactory.createEtchedBorder());
        this.addComponent(this.jpMain, 0, 1, 1, 1);
        this.constraints.fill = 1;
        this.addComponent(this.jpBottom, 4, 1, 1, 1);
        this.setSize(600, 450);
        this.setLocation(150, 150);
        this.setVisible(true);
    }

    private JPanel getConnectionSetupScreen() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html>&nbsp <b>SAN Simulator Setup </b><br><br><br><br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 0));
        this.jlInfo = new JLabel("<html><br><b>Please wait..This process may take some time</b><br><br><html>");
        jPanel3.add(this.jlInfo);
        jPanel2.add(jPanel3);
        this.jProgressBar = new JProgressBar(0, 10);
        this.jProgressBar.setSize(100, 10);
        this.jProgressBar.setValue(0);
        this.jProgressBar.setStringPainted(true);
        jPanel2.add((Component)this.jProgressBar, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.add(jPanel2);
        jPanel.add((Component)jPanel4, "Center");
        return jPanel;
    }

    private JPanel getDeviceScreen() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html>&nbsp <b>SAN Simulator Setup </b><br><br><br><br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 0));
        this.jlInfo = new JLabel("<html><br><b>Please wait..This process may take some time</b><br><br><html>");
        jPanel3.add(this.jlInfo);
        jPanel2.add(jPanel3);
        this.jProgressBar = new JProgressBar(0, 10);
        this.jProgressBar.setSize(100, 10);
        this.jProgressBar.setValue(0);
        this.jProgressBar.setStringPainted(true);
        jPanel2.add((Component)this.jProgressBar, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 0, 5));
        this.jchbWbemInstall = new JCheckBox();
        this.jchbWbemInstall.setEnabled(false);
        JLabel jLabel2 = new JLabel("<html>Create new CIMOM instance</html>", 2);
        jLabel2.setFont(new Font("Times New RomanSerif", 0, 12));
        jPanel4.add(this.jchbWbemInstall);
        jPanel4.add(jLabel2);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 0, 5));
        this.jchbCreateMof = new JCheckBox();
        this.jchbCreateMof.setEnabled(false);
        JLabel jLabel3 = new JLabel("<html>Create new MOF files </html>", 2);
        jLabel3.setFont(new Font("Times New RomanSerif", 0, 12));
        jPanel5.add(this.jchbCreateMof);
        jPanel5.add(jLabel3);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 0, 5));
        this.jchbDBCreated = new JCheckBox();
        this.jchbDBCreated.setEnabled(false);
        JLabel jLabel4 = new JLabel("<html>Populate database with simulated data</html>", 2);
        jLabel4.setFont(new Font("Times New RomanSerif", 0, 12));
        jPanel6.add(this.jchbDBCreated);
        jPanel6.add(jLabel4);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 0, 5));
        this.jchbMofCompile = new JCheckBox();
        this.jchbMofCompile.setEnabled(false);
        JLabel jLabel5 = new JLabel("<html>Start CIMOM and compile device MOF files</html>", 2);
        jLabel5.setFont(new Font("Times New RomanSerif", 0, 12));
        jPanel7.add(this.jchbMofCompile);
        jPanel7.add(jLabel5);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        jPanel2.add(jPanel7);
        jPanel2.add(jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createEtchedBorder());
        jPanel8.add(jPanel2);
        jPanel.add((Component)jPanel8, "Center");
        return jPanel;
    }

    private void addComponent(Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n2;
        this.constraints.gridy = n;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.layout.setConstraints(component, this.constraints);
        this.container.add(component);
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "Cancel") {
                int n = JOptionPane.showConfirmDialog(null, "If you Cancel the setup now, SAN Simulator will not be installed. Are you sure you want to exit?", "Cancel", 1);
                if (n == 0) {
                    JOptionPane.showMessageDialog(null, "Please close all Open Command Window before you exit", "Cancel", 1);
                    CreateSetupScreen.this.dispose();
                    System.exit(0);
                } else if (n == 1 || n == 2) {
                    // empty if block
                }
            }
            if (actionEvent.getActionCommand() == "Finish") {
                if (!ConnectionUtility.isSimConnection && SetupWizardUtility.isCompileMof) {
                    JOptionPane.showMessageDialog(null, "Start the CIMOM from " + SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM") + "\\wbemservices\\cimom\\bin\\start_cimom.bat for device discovery.", "Start Cimom", 1);
                }
                System.exit(0);
            }
        }
    }
}

