/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.ui.RestoreDB;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class DatabaseUtility {
    private static final String DB_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private static final String CREATE_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 create DB {0}";
    private static final String RUN_DDL_COMMAND_WITH_CREDENTIAL = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2batch.exe -d {0} -a {1}/{2} -f {3}";
    private static final String DDL_FILE_PATH = "resources" + File.separator + "SIM.DDL";
    private Logger logger = Logger.getLogger((Class)DatabaseUtility.class);

    public int CreateDatabase() {
        int n;
        String string = SetupWizardUtility.getProperty("SIMULATION_MODE");
        int n2 = 0;
        if (string.equals("Snapshot-based") && (n = (int)(SetupWizardUtility.getProperty("SNAPSHOT_SIMULATION_MODE").equals("Restore Backup DB") ? 1 : 0)) != 0) {
            if (this.restore()) {
                n2 = 2;
            } else {
                this.logger.error((Object)"Error occurred during restoring DB");
                n2 = 0;
            }
            return n2;
        }
        n = this.TestDB();
        if (n == 0) {
            this.logger.debug((Object)"Database does not exist!Create database !");
            if (this.create()) {
                n2 = 1;
            }
        } else if (n == 1) {
            n2 = 1;
        }
        return n2;
    }

    private boolean restore() {
        RestoreDB restoreDB = new RestoreDB();
        boolean bl = restoreDB.restore(SetupWizardUtility.getProperty("DB_NAME"), SetupWizardUtility.getProperty("BACK_UP_PATH"));
        if (bl) {
            this.logger.info((Object)("Database restored successfully: " + bl));
        } else {
            this.logger.info((Object)("Database restored failed: " + bl));
        }
        return bl;
    }

    private boolean create() {
        boolean bl = false;
        String string = SetupWizardUtility.getProperty("DB_USER_NAME");
        String string2 = SetupWizardUtility.getProperty("DB_PASSWORD");
        String string3 = SetupWizardUtility.getProperty("DB_NAME");
        if (string.equals("Default") || string2.equals("Default")) {
            string = JOptionPane.showInputDialog("Enter DB Username: ", (Object)"db2admin");
            string2 = JOptionPane.showInputDialog("Enter DB Password: ", (Object)"db2admin");
            if (string == null || string2 == null) {
                JOptionPane.showMessageDialog(null, "Database could not be created! So SetupWizard will abort", "DB Error", 0);
                System.exit(0);
            }
        }
        String string4 = MessageFormat.format(RUN_DDL_COMMAND_WITH_CREDENTIAL, string3, string, string2, DDL_FILE_PATH);
        try {
            if (this.runDBCreate() && this.ConfigDB(string4)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
            this.logger.error((Object)exception);
        }
        this.logger.info((Object)("Database created successfully: " + bl));
        return bl;
    }

    private boolean ConfigDB(String string) {
        boolean bl = false;
        this.logger.debug((Object)("DB Create Command: " + string));
        int n = this.executeCommand(string);
        bl = n == 0;
        return bl;
    }

    public boolean runDBCreate() throws Exception {
        String string = MessageFormat.format(CREATE_DB_COMMAND, SetupWizardUtility.getProperty("DB_NAME"));
        this.logger.debug((Object)("Create database command to execute: " + string));
        return this.executeCommand(string) == 0;
    }

    private int executeCommand(String string) {
        int n = -1;
        try {
            String string2;
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (null != (string2 = bufferedReader.readLine())) {
                this.logger.debug((Object)("Database create Output: " + string2));
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (null != (string2 = bufferedReader.readLine())) {
                this.logger.debug((Object)("Database Error: " + string2));
            }
            bufferedReader.close();
            n = process.waitFor();
        }
        catch (IOException iOException) {
            this.logger.error((Object)iOException);
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.logger.error((Object)interruptedException);
        }
        return n;
    }

    public int TestDB() {
        int n = 0;
        try {
            Class.forName(DB_DRIVER);
            String string = SetupWizardUtility.getProperty("DB_USER_NAME");
            String string2 = SetupWizardUtility.getProperty("DB_PASSWORD");
            String string3 = SetupWizardUtility.getProperty("DB_HOST_URL");
            if (string3.equalsIgnoreCase("localhost")) {
                if (string.equals("Default") || string2.equals("Default")) {
                    String string4 = "jdbc:db2:" + SetupWizardUtility.getProperty("DB_NAME");
                    Connection connection = DriverManager.getConnection(string4);
                    this.logger.debug((Object)"Database connection successful!");
                    connection.close();
                } else {
                    String string5 = SetupWizardUtility.getProperty("DB_NAME");
                    String string6 = "jdbc:db2://localhost:50000/" + string5;
                    this.logger.debug((Object)("DB_URL is " + string6));
                    Connection connection = DriverManager.getConnection(string6, string, string2);
                    this.logger.debug((Object)"Database connection successful!");
                    connection.close();
                }
                n = 1;
            } else {
                n = 1;
            }
        }
        catch (Exception exception) {
            this.logger.debug((Object)"Database with this name does not exist!");
        }
        return n;
    }
}

