/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.wbem.cim.CIMException;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.ui.CheckPreRequisites;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;
import org.eclipse.aperi.simulator.ui.TestDBConnection;
import org.eclipse.aperi.simulator.ui.TestWbemCimomConnection;

public class InputScreens {
    private static final String CREATE_DEVICE_MOF_VALUE = "Create device Mof";
    private static final String INTERACTIVE_VALUE = "Interactive";
    private static final String NON_INTERACTIVE_VALUE = "NonInteractive";
    private static final String SIMULATE_DEVICE_CHECK_VALUE = "Simulate Device";
    private static final String COMPILE_MOF_CHECK_VALUE = "Start CIMOM and Compile MOF files";
    private static final String CREATE_NEW_CIMOM_CHECK_VALUE = "Create New CIMOM";
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JButton jbBrowseDirPath;
    protected JTextField jtfdirName;
    private static final File DEFAULT_WBEM_DIR_PATH = new File("C:\\SAN_SIMULATOR");
    private static final File DEFAULT_PROPERTY_FILE_PATH = new File("C:\\SAN_SIMULATOR\\SANSimulator.Properties");
    private boolean wbemPropertiesSet;
    private String destinationPath;
    private File fileName;
    private JRadioButton jrbInterActive;
    private JRadioButton jrbNonInterActive;
    protected boolean nonInteractiveSetup;
    protected boolean interactiveSetup;
    protected boolean setupModeSet;
    protected boolean installModeClicked;
    private JRadioButton jrbSwitch;
    private JRadioButton jrbStorage;
    private JRadioButton jrbOthers;
    private JRadioButton jrbServer;
    private JComboBox jcbSwitch;
    private JComboBox jcbStorage;
    private JComboBox jcbOthers;
    private JComboBox jcbServer;
    protected boolean deviceClicked = false;
    private String[] switchTypes = new String[]{"Brocade_110.4.0a", "Cisco (Not Supported)", "McData (Not Supported)", "QLogic (Not Supported)"};
    private String[] storageTypes = new String[]{"DS4K_9.16.G0.06", "DS6K_5.1.0.40", "DS8K_5.1.0.40"};
    private String[] serverTypes = new String[]{"IBM AIX(Not Supported)", "Linux(Not Supported)", "Microsoft Windows(Not Supported)"};
    private String[] otherDevices = new String[]{"IBM Tape Library", "iSCSi Device(Not Supported)"};
    private ButtonGroup jbgradioGroup;
    private boolean devicePropSet;
    private boolean switchSelected;
    private boolean storageSelected;
    private boolean othersSelected;
    private boolean serverSelected;
    private String deviceCategory;
    private String deviceType = "Not Set";
    private JTextField jtfDBName;
    private JTextField jtfDBUserId;
    private JTextField jtfDBHostUrl;
    private JPasswordField jtfDBPasswd;
    private boolean databasePropSet;
    private String dbName;
    private String dbUserId;
    private String dbPassWord;
    private String dbHostUrl;
    private JComboBox jcbSimulation_mode;
    private String[] simulationTypes = new String[]{"Snapshot-based", "Configuaration-based"};
    private String simulationMode;
    private boolean simulationModeSet;
    private JRadioButton jrbFresh;
    private JRadioButton jrbRestore;
    protected boolean snapshotSetupMode = true;
    protected boolean restoreBackupDB;
    protected boolean startFreshSnapshot;
    protected boolean snapshotModeSet;
    protected boolean setupModeClicked;
    private JButton jbBrowseDBPath;
    protected boolean dbPathSet;
    protected JTextField jtfBackupDBPath;
    private String strdbPath;
    private String snapshot_type;
    private JTextField jtfCIMhost_url;
    private JTextField jtfCIMuid;
    private JTextField jtfCIMport;
    private JTextField jtfCIMnmspace;
    private JPasswordField jtfCIMpwd;
    private JComboBox jcbprotocols;
    private JComboBox jcbcimomTypes;
    private String[] cimomTypes = new String[]{"Sun WBEM", "SBLIM"};
    private String[] protocols = new String[]{"http", "https"};
    private String cimomHostUrl;
    private String cimomPort;
    private String cimomUid;
    private String cimomPwd;
    private String cimomNameSpace;
    private String cimomProtocol;
    private boolean cimomPropSet;
    private String cimomType;
    private JButton jbBrowseConfigFile;
    private boolean dbConnectionExist = false;
    private boolean dbConnectionTested = false;
    protected JTextField jtfConfigFilePath;
    private boolean configPropSet;
    private String strConfigFile;
    private File configFile;
    private JButton jbBrowsePropFile;
    protected JTextField jtfSANPropFilePath;
    private boolean nonInteractiveModeSet;
    protected static String SANPropPath;
    private File SANPropFile;
    protected JCheckBox jchbWbemInstall;
    private JCheckBox jchbCompileMof;
    private JCheckBox jchbSimulateDevice;
    private Logger logger = Logger.getLogger((Class)InputScreens.class);
    private JTextField jtfWbemInstallpathTxt;
    private JButton browseBt;
    private JTextField jtfCimomPathTxt;
    private JButton browseCimomDir;
    private JTextField jtfMofFilePathTxt;
    private JButton browseMofFile;
    private JCheckBox jchbCreateNewMof;
    private JButton browseMofLoc;
    private JTextField jtfMofFileTxt;

    protected JPanel createSetupModeSelectionScreen() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("<html><b>Please select the mode of Setup</b><br><br> Experts can choose a <b>\ufffdNon-interactive mode\ufffd</b> where user can give all the inputs through a single file.<br> It is recommended that new users choose <b>\ufffdInteractive mode\ufffd</b>.<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(272);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets.top = 15;
        gridBagConstraints2.insets.bottom = 10;
        JPanel jPanel2 = new JPanel(this.layout);
        this.jrbNonInterActive = new JRadioButton("Non-interactive Mode");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        jPanel2.add((Component)this.jrbNonInterActive, gridBagConstraints2);
        this.jrbInterActive = new JRadioButton("Interactive Mode");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        jPanel2.add((Component)this.jrbInterActive, gridBagConstraints2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbNonInterActive);
        buttonGroup.add(this.jrbInterActive);
        this.jrbInterActive.addItemListener(new InstallRadioHandler(INTERACTIVE_VALUE));
        this.jrbNonInterActive.addItemListener(new InstallRadioHandler(NON_INTERACTIVE_VALUE));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel2.setBorder(BorderFactory.createTitledBorder("Setup Mode"));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(this.layout);
        Component component = jPanel3.add(new JLabel("Select Option"));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        jPanel3.add(component, gridBagConstraints2);
        this.jcbSimulation_mode = new JComboBox<String>(this.simulationTypes);
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        jPanel3.add((Component)this.jcbSimulation_mode, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel3.setBorder(BorderFactory.createTitledBorder("Simulation Type"));
        jPanel.add((Component)jPanel3, gridBagConstraints);
        if (this.setupModeSet) {
            if (this.interactiveSetup) {
                this.jrbInterActive.doClick();
                if (this.snapshotSetupMode) {
                    this.jcbSimulation_mode.setSelectedIndex(0);
                } else {
                    this.jcbSimulation_mode.setSelectedIndex(1);
                }
            } else {
                this.jrbNonInterActive.doClick();
                this.jcbSimulation_mode.setEnabled(false);
            }
        } else {
            this.jrbInterActive.doClick();
        }
        return jPanel;
    }

    protected JPanel sanPropertyFilePathScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Properties File Path</b><br><br>Please specify the path for Properties file you want to use<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(this.layout);
        JLabel jLabel2 = new JLabel("<html>User Input File Path <html>");
        this.jtfSANPropFilePath = new JTextField(20);
        this.jbBrowsePropFile = new JButton("Browse");
        this.jbBrowsePropFile.setPreferredSize(new Dimension(30, 25));
        if (this.nonInteractiveModeSet) {
            this.jtfSANPropFilePath.setText(SANPropPath);
        }
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.addComponent(jPanel2, jLabel2, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jPanel2, this.jtfSANPropFilePath, 0, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jPanel2, this.jbBrowsePropFile, 0, 2, 1, 1);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        SANPropbrowseButtonHandler sANPropbrowseButtonHandler = new SANPropbrowseButtonHandler();
        this.jbBrowsePropFile.addActionListener(sANPropbrowseButtonHandler);
        return jPanel;
    }

    protected JPanel wbemInstallPathScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html>&nbsp <b>WBEM Services Installation Path</b><br><br>Please specify the path where wbemservices directory will get installed<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(this.layout);
        JLabel jLabel2 = new JLabel("<html>Directory Path<html>");
        this.jtfdirName = new JTextField(20);
        this.jtfdirName.setText("C:\\SAN_SIMULATOR\\");
        this.jbBrowseDirPath = new JButton("Browse");
        this.jbBrowseDirPath.setPreferredSize(new Dimension(25, 25));
        if (this.wbemPropertiesSet) {
            this.jtfdirName.setText(this.destinationPath);
        }
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 13;
        this.constraints.fill = 0;
        this.addComponent(jPanel2, jLabel2, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jPanel2, this.jtfdirName, 0, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jPanel2, this.jbBrowseDirPath, 0, 2, 1, 1);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.jbBrowseDirPath.addActionListener(new BrowseDirectoryListener(this.jtfdirName));
        return jPanel;
    }

    protected JPanel deviceSelectScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Device Selection</b><br><br>Please the device you want to simulate<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        jPanel3.add(new JLabel("<html><br><br><b>Device Selection Option</b><html>"));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbSwitch = new JRadioButton("Switch");
        jPanel4.add(this.jrbSwitch);
        this.jcbSwitch = new JComboBox<String>(this.switchTypes);
        this.jrbSwitch.setPreferredSize(new Dimension(75, 30));
        this.jcbSwitch.setEnabled(false);
        this.jcbSwitch.setPreferredSize(new Dimension(130, 20));
        jPanel4.add(this.jcbSwitch);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbStorage = new JRadioButton("Storage");
        this.jrbStorage.setPreferredSize(new Dimension(75, 30));
        jPanel5.add(this.jrbStorage);
        this.jcbStorage = new JComboBox<String>(this.storageTypes);
        this.jcbStorage.setEnabled(false);
        this.jcbStorage.setPreferredSize(new Dimension(130, 20));
        jPanel5.add(this.jcbStorage);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbServer = new JRadioButton("Server");
        this.jrbServer.setPreferredSize(new Dimension(75, 30));
        jPanel6.add(this.jrbServer);
        this.jcbServer = new JComboBox<String>(this.serverTypes);
        this.jcbServer.setEnabled(false);
        this.jcbServer.setPreferredSize(new Dimension(130, 20));
        jPanel6.add(this.jcbServer);
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbOthers = new JRadioButton("Others");
        this.jrbOthers.setPreferredSize(new Dimension(75, 30));
        jPanel7.add(this.jrbOthers);
        this.jcbOthers = new JComboBox<String>(this.otherDevices);
        this.jcbOthers.setEnabled(false);
        this.jcbOthers.setPreferredSize(new Dimension(130, 20));
        jPanel7.add(this.jcbOthers);
        jPanel2.add(jPanel7);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.jbgradioGroup = new ButtonGroup();
        this.jbgradioGroup.add(this.jrbSwitch);
        this.jbgradioGroup.add(this.jrbStorage);
        this.jbgradioGroup.add(this.jrbServer);
        this.jbgradioGroup.add(this.jrbOthers);
        this.jrbSwitch.addItemListener(new RadioButtonHandler("Switch"));
        this.jrbStorage.addItemListener(new RadioButtonHandler("Storage"));
        this.jrbServer.addItemListener(new RadioButtonHandler("Server"));
        this.jrbOthers.addItemListener(new RadioButtonHandler("Others"));
        this.jcbSwitch.addItemListener(new DeviceTypeHandler());
        this.jcbStorage.addItemListener(new DeviceTypeHandler());
        this.jcbOthers.addItemListener(new DeviceTypeHandler());
        this.jcbServer.addItemListener(new DeviceTypeHandler());
        if (this.devicePropSet) {
            if (this.switchSelected) {
                this.jrbSwitch.doClick();
                this.jcbSwitch.setSelectedItem(this.deviceType);
            }
            if (this.storageSelected) {
                this.jrbStorage.doClick();
                this.jcbStorage.setSelectedItem(this.deviceType);
            }
            if (this.serverSelected) {
                this.jrbServer.doClick();
                this.jcbServer.setSelectedItem(this.deviceType);
            }
            if (this.othersSelected) {
                this.jrbOthers.doClick();
                this.jcbOthers.setSelectedItem(this.deviceType);
            }
        }
        return jPanel;
    }

    protected JPanel dbInfoScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Enter the database details</b><br><br>If local database is used and current logged in user has admin permissions on the database, then \ufffdUser Name\ufffd and \ufffdPassword\ufffd fields can be left blank.<br>You can test the connection to the database using <b>\ufffdTest DB Connection\ufffd</b> button.<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(295);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jLabel2 = new JLabel("Host URL");
        jLabel2.setPreferredSize(new Dimension(75, 10));
        jPanel3.add(jLabel2);
        this.jtfDBHostUrl = new JTextField(10);
        this.jtfDBHostUrl.setText("localhost");
        this.jtfDBHostUrl.setPreferredSize(new Dimension(100, 20));
        jPanel3.add(this.jtfDBHostUrl);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jLabel3 = new JLabel("Databse name");
        jPanel4.add(jLabel3);
        jLabel3.setPreferredSize(new Dimension(75, 20));
        this.jtfDBName = new JTextField(10);
        this.jtfDBName.setPreferredSize(new Dimension(100, 20));
        this.jtfDBName.setText("SIMDB");
        this.jtfDBName.setEditable(false);
        jPanel4.add(this.jtfDBName);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jLabel4 = new JLabel("User ID");
        jLabel4.setPreferredSize(new Dimension(75, 10));
        jPanel5.add(jLabel4);
        this.jtfDBUserId = new JTextField(10);
        this.jtfDBUserId.setPreferredSize(new Dimension(100, 20));
        jPanel5.add(this.jtfDBUserId);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jLabel5 = new JLabel("Password");
        jPanel6.add(jLabel5);
        jLabel5.setPreferredSize(new Dimension(75, 10));
        this.jtfDBPasswd = new JPasswordField(8);
        this.jtfDBPasswd.setPreferredSize(new Dimension(100, 20));
        jPanel6.add(this.jtfDBPasswd);
        jPanel2.add(jPanel6);
        JButton jButton = new JButton("Test DB Connection");
        jButton.addActionListener(new TestDB());
        jPanel2.add((Component)jButton, "Center");
        if (this.databasePropSet) {
            this.jtfDBName.setText(this.dbName);
            this.jtfDBUserId.setText(this.dbUserId);
            this.jtfDBPasswd.setText(this.dbPassWord);
            this.jtfDBHostUrl.setText(this.dbHostUrl);
        }
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected boolean isModeSelectedSet() {
        return this.installModeClicked;
    }

    protected boolean isPropertyFileSet() {
        return !this.jtfSANPropFilePath.getText().equals("");
    }

    protected boolean isDeviceSelected() {
        return this.deviceClicked;
    }

    protected boolean isDBConfigured() {
        boolean bl = true;
        String string = this.jtfDBHostUrl.getText();
        String string2 = this.jtfDBName.getText();
        String string3 = this.jtfDBUserId.getText();
        String string4 = new String(this.jtfDBPasswd.getPassword());
        if (string.equals("localhost")) {
            return bl;
        }
        if (this.dbConnectionTested && this.dbConnectionExist) {
            return bl;
        }
        if (string3.equals("") || string4.equals("")) {
            bl = false;
        }
        if (bl && new TestDBConnection().testConnection(string2, string3, string4, string) == 0) {
            JOptionPane.showMessageDialog(null, "Database instance titled SIMDB does not exist.\n\n Please go to the machine where DB2 is installed and copy the folder named DBUtility. Run CreateDb.bat to create the SIMDB instance.", "DB Configuration Failed", 0);
            System.exit(0);
        }
        return bl;
    }

    protected boolean isWBEMPathSet() {
        return !this.jtfdirName.getText().equals("");
    }

    protected boolean isSnapshotModeSet() {
        return this.setupModeClicked;
    }

    protected boolean isConfigPathSet() {
        return !this.jtfConfigFilePath.getText().equals("");
    }

    protected boolean isBackupFilePathSet() {
        return !this.jtfBackupDBPath.getText().equals("");
    }

    protected JPanel simulationModeSelectScreen() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><b>Please select the method of simulation</b><br><br> Snapshot based method requires details of the live CIMOM of selected device to take the snapshot.<br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(292);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel2 = new JLabel("<html><br><br><br></html>", 2);
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(new JLabel("<html>Select Option&nbsp&nbsp&nbsp<br><html>"));
        this.jcbSimulation_mode = new JComboBox<String>(this.simulationTypes);
        jPanel3.add(this.jcbSimulation_mode);
        jPanel2.add(jPanel3);
        JLabel jLabel3 = new JLabel("<html><br><br><br></html>", 2);
        jPanel2.add(jLabel3);
        this.jcbSimulation_mode.addItemListener(new SimulationModeHandler());
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.add(jPanel2);
        jPanel.add((Component)jPanel4, "Center");
        if (this.simulationModeSet) {
            this.jcbSimulation_mode.setSelectedItem(this.simulationMode);
        }
        return jPanel;
    }

    protected JPanel snapshotModeSelectScreen() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("<html><b>Choose appropriate option for your snapshot</b><br><br> You can choose 'Restore Snapshot Backup' if you already have snapshot image of the device you want to simulate. Otherwise you can take a new snapshot by choosing 'Start Fresh Snapshot'</b>.<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(this.layout);
        JLabel jLabel2 = new JLabel("<html><br><br></html>", 2);
        jPanel2.add(jLabel2);
        this.jrbRestore = new JRadioButton("Restore Snapshot Backup");
        this.jrbFresh = new JRadioButton("Start Fresh Snapshot");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrbRestore);
        buttonGroup.add(this.jrbFresh);
        this.jrbRestore.addItemListener(new SnapshotRadioHandler("Restore"));
        this.jrbFresh.addItemListener(new SnapshotRadioHandler("Fresh"));
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.constraints.insets.top = 40;
        this.constraints.insets.bottom = 20;
        this.constraints.insets.left = 5;
        this.addComponent(jPanel2, this.jrbRestore, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets.top = 20;
        this.constraints.insets.left = 5;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.addComponent(jPanel2, this.jrbFresh, 1, 0, 1, 1);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (this.snapshotModeSet) {
            if (this.restoreBackupDB) {
                this.jrbRestore.doClick();
            } else if (this.startFreshSnapshot) {
                this.jrbFresh.doClick();
            }
        }
        return jPanel;
    }

    protected JPanel snapshotCIMOMInfoScreen() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Enter the live CIMOM information</b><br><br> You can test the connection to the CIMOM using the \ufffdTest CIMOM Connect\ufffd button.<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel2 = new JLabel("Host IP");
        jLabel2.setPreferredSize(new Dimension(100, 10));
        jPanel3.add(jLabel2);
        this.jtfCIMhost_url = new JTextField(10);
        jPanel3.add(this.jtfCIMhost_url);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel3 = new JLabel("Port");
        jLabel3.setPreferredSize(new Dimension(100, 10));
        jPanel4.add(jLabel3);
        this.jtfCIMport = new JTextField(10);
        this.jtfCIMport.setPreferredSize(new Dimension(100, 20));
        jPanel4.add(this.jtfCIMport);
        jPanel2.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel4 = new JLabel("User Name");
        jLabel4.setPreferredSize(new Dimension(100, 10));
        jPanel5.add(jLabel4);
        this.jtfCIMuid = new JTextField(10);
        this.jtfCIMuid.setPreferredSize(new Dimension(100, 20));
        jPanel5.add(this.jtfCIMuid);
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel5 = new JLabel("Password");
        jLabel5.setPreferredSize(new Dimension(100, 10));
        jPanel6.add(jLabel5);
        this.jtfCIMpwd = new JPasswordField(8);
        this.jtfCIMpwd.setPreferredSize(new Dimension(100, 20));
        jPanel6.add(this.jtfCIMpwd);
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel6 = new JLabel("Interop Namespace");
        jLabel6.setPreferredSize(new Dimension(100, 10));
        jPanel7.add(jLabel6);
        this.jtfCIMnmspace = new JTextField(10);
        this.jtfCIMnmspace.setPreferredSize(new Dimension(100, 20));
        jPanel7.add(this.jtfCIMnmspace);
        jPanel2.add(jPanel7);
        JPanel jPanel8 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jLabel7 = new JLabel("Protocol");
        jLabel7.setPreferredSize(new Dimension(100, 10));
        jPanel8.add(jLabel7);
        this.jcbprotocols = new JComboBox<String>(this.protocols);
        this.jcbprotocols.setPreferredSize(new Dimension(100, 20));
        jPanel8.add(this.jcbprotocols);
        jPanel2.add(jPanel8);
        JButton jButton = new JButton("Test CIMOM Connection");
        jButton.addActionListener(new TestCIMOM());
        jPanel2.add((Component)jButton, "Center");
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel9 = new JPanel(this.layout);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        this.jchbCreateNewMof = new JCheckBox();
        this.jchbCreateNewMof.setText("Create new MOF file for this device CIMOM");
        this.jchbCreateNewMof.setEnabled(true);
        this.jchbCreateNewMof.setFont(new Font("Times New RomanSerif", 0, 12));
        this.jchbCreateNewMof.addItemListener(new checkBoxListener(CREATE_DEVICE_MOF_VALUE));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        jPanel9.add((Component)this.jchbCreateNewMof, gridBagConstraints2);
        JPanel jPanel10 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel10.add(new JLabel("Directory path for MOF destination:               "));
        this.jtfMofFileTxt = new JTextField(20);
        this.jtfMofFileTxt.setEnabled(false);
        jPanel10.add(this.jtfMofFileTxt);
        this.browseMofLoc = new JButton("Browse");
        this.browseMofLoc.addActionListener(new BrowseDirectoryListener(this.jtfMofFileTxt));
        this.browseMofLoc.setEnabled(false);
        jPanel10.add(this.browseMofLoc);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets.left = 10;
        jPanel9.add((Component)jPanel10, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel9, gridBagConstraints);
        if (this.cimomPropSet) {
            this.jtfCIMhost_url.setText(this.cimomHostUrl);
            this.jtfCIMport.setText(this.cimomPort);
            this.jtfCIMuid.setText(this.cimomUid);
            this.jtfCIMpwd.setText(this.cimomPort);
            this.jtfCIMnmspace.setText(this.cimomNameSpace);
            this.jcbprotocols.setSelectedItem(this.cimomProtocol);
            if (SetupWizardUtility.isCreateMof) {
                this.jchbCreateNewMof.doClick();
                this.jtfMofFileTxt.setText(SetupWizardUtility.strPathTosaveMofFile);
            }
        }
        return jPanel;
    }

    protected JPanel backupDBInfoScreen() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><b>Enter Snapshot Backup Location</b><br><br>Please specify the path where you have your snapshot image stored. If your database name is SIMDB, enter the path of parent directory of SIMDB.0<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(new JLabel("<html><br><br><br>Snapshot Backup Path&nbsp&nbsp<br><br><br><br><html>"));
        this.jtfBackupDBPath = new JTextField(20);
        jPanel3.add(this.jtfBackupDBPath);
        this.jbBrowseDBPath = new JButton("Browse");
        jPanel3.add(this.jbBrowseDBPath);
        jPanel2.add(jPanel3);
        if (this.dbPathSet) {
            this.jtfBackupDBPath.setText(this.strdbPath);
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel2);
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setSize(100, 100);
        jPanel.add((Component)jPanel4, "Center");
        this.jbBrowseDBPath.addActionListener(new BrowseDirectoryListener(this.jtfBackupDBPath));
        return jPanel;
    }

    protected boolean isCimomPropset() {
        if (this.jtfCIMhost_url.getText().equals("")) {
            return false;
        }
        if (this.jtfCIMuid.getText().equals("") || new String(this.jtfCIMpwd.getPassword()).equals("")) {
            return false;
        }
        if (this.jtfCIMport.getText().equals("") || this.jtfCIMnmspace.getText().equals("")) {
            return false;
        }
        return (!this.jchbCreateNewMof.isSelected() || !this.jtfMofFileTxt.getText().equals("")) && null != this.jtfMofFileTxt.getText();
    }

    protected boolean checkSimulationMode() {
        if (this.jcbSimulation_mode.getSelectedItem().equals("Snapshot-based")) {
            return true;
        }
        JOptionPane.showMessageDialog(null, "Sorry !Only Snapshot-based Simulation supported!", "SimulationMode Error", 1);
        return false;
    }

    protected JPanel configInfoScreen() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><b>Configuration-based Simulation</b><br><br>Please specify the path of Configuration File<br><br><br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(110);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(new JLabel("<html><br><br><br>Configuration File Path&nbsp&nbsp<br><br><br><br><html>"));
        this.jtfConfigFilePath = new JTextField(20);
        jPanel3.add(this.jtfConfigFilePath);
        this.jtfConfigFilePath.setText(this.getConfFilePath());
        this.jbBrowseConfigFile = new JButton("Browse");
        jPanel3.add(this.jbBrowseConfigFile);
        jPanel2.add(jPanel3);
        if (this.configPropSet) {
            this.jtfConfigFilePath.setText(this.strConfigFile);
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel2);
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setSize(100, 100);
        jPanel.add((Component)jPanel4, "Center");
        ConfigbrowseButtonHandler configbrowseButtonHandler = new ConfigbrowseButtonHandler();
        this.jbBrowseConfigFile.addActionListener(configbrowseButtonHandler);
        return jPanel;
    }

    protected JPanel SimulationModeScreen() {
        if (this.snapshotSetupMode) {
            return this.snapshotModeSelectScreen();
        }
        return this.configInfoScreen();
    }

    public JPanel SetupSummaryPage() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html><b>Confirm Setup Parameters<br><br> </b>Please confirmed the Setup parameters and click <b>Setup</b> to proceed<br><br><br></html", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(200);
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(this.layout);
        Properties properties = SetupWizardUtility.simulatorProperties;
        try {
            SetupWizardUtility.loadProperties();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Set<Object> set = properties.keySet();
        Iterator<Object> iterator = set.iterator();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.left = 10;
        int n = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            String string = object.toString();
            if (!SetupWizardUtility.propToDisplay.contains(string)) continue;
            String string2 = properties.getProperty(string);
            JLabel jLabel2 = new JLabel(string);
            JLabel jLabel3 = new JLabel(string2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            jPanel2.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            jPanel2.add((Component)jLabel3, gridBagConstraints);
        }
        jPanel2.setBorder(BorderFactory.createTitledBorder("Setup Paramaters"));
        jPanel.add((Component)jPanel2, "Center");
        return jPanel;
    }

    protected void saveDbProperties() {
        this.dbName = this.jtfDBName.getText();
        this.dbPassWord = new String(this.jtfDBPasswd.getPassword()).equals("") ? "Default" : new String(this.jtfDBPasswd.getPassword());
        this.dbUserId = this.jtfDBUserId.getText().equals("") ? "Default" : this.jtfDBUserId.getText();
        this.dbHostUrl = this.jtfDBHostUrl.getText();
        this.databasePropSet = true;
        this.logger.info((Object)"Database Information ");
        this.logger.debug((Object)("Database Name: " + this.dbName + " DB Password: " + this.dbPassWord + " DB UID: " + this.dbUserId + " DB Url: " + this.dbHostUrl));
    }

    protected void saveDeviceProperties() {
        this.devicePropSet = true;
        if (this.switchSelected) {
            this.deviceType = (String)this.jcbSwitch.getSelectedItem();
            this.deviceCategory = "Switch";
        }
        if (this.storageSelected) {
            this.deviceType = (String)this.jcbStorage.getSelectedItem();
            this.deviceCategory = "Storage";
        }
        if (this.othersSelected) {
            this.deviceType = (String)this.jcbOthers.getSelectedItem();
            this.deviceCategory = "Others";
        }
        this.logger.debug((Object)("Device Category Selected: " + this.deviceCategory + " DeviceType Selected: " + this.deviceType));
    }

    protected void saveSModeProperties() {
        this.simulationMode = this.jcbSimulation_mode.getSelectedItem().toString();
        this.logger.debug((Object)("Simulation Mode Selected: " + this.simulationMode));
        this.snapshotSetupMode = this.simulationMode.equals("Snapshot-based");
        this.simulationModeSet = true;
        this.setupModeSet = true;
    }

    protected void saveSnapshotModeProperties() {
        this.snapshotModeSet = true;
        if (this.restoreBackupDB) {
            this.startFreshSnapshot = false;
            this.snapshot_type = "Restore Backup DB";
        } else if (this.startFreshSnapshot) {
            this.snapshot_type = "Fresh Snapshot";
            this.restoreBackupDB = false;
        }
        this.logger.info((Object)"For snapshot based simulation");
        this.logger.debug((Object)("Snapshot Mode Selected: " + this.snapshot_type));
    }

    protected void saveCIMOMProperties() {
        this.cimomHostUrl = this.jtfCIMhost_url.getText();
        this.cimomPort = this.jtfCIMport.getText();
        this.cimomUid = this.jtfCIMuid.getText();
        this.cimomPwd = new String(this.jtfCIMpwd.getPassword());
        this.cimomNameSpace = this.jtfCIMnmspace.getText();
        this.cimomProtocol = this.jcbprotocols.getSelectedItem().toString();
        this.cimomPropSet = true;
        if (this.jchbCreateNewMof.isSelected()) {
            SetupWizardUtility.isCreateMof = true;
            SetupWizardUtility.strPathTosaveMofFile = this.jtfMofFileTxt.getText();
        } else {
            SetupWizardUtility.isCreateMof = false;
            SetupWizardUtility.strPathTosaveMofFile = null;
        }
        this.logger.debug((Object)("CIMOM Host URL: " + this.cimomHostUrl + " CIMOMPort: " + this.cimomPort + " CIMOM Namespace: " + this.cimomNameSpace + " CIMOM Protocol: " + this.cimomProtocol));
    }

    protected void saveDBPathProperties() {
        this.dbPathSet = true;
        this.strdbPath = this.jtfBackupDBPath.getText();
        this.logger.debug((Object)("Restore DB Path specified: " + this.dbPathSet));
    }

    protected void saveInstallMode() {
        this.setupModeSet = true;
        if (this.nonInteractiveSetup) {
            this.logger.debug((Object)"Install Mode Seletced: NonIntercative");
            this.interactiveSetup = false;
        } else if (this.interactiveSetup) {
            this.logger.debug((Object)"Install Mode Seletced: Intercative");
            this.nonInteractiveSetup = false;
        }
    }

    protected void saveProperties() {
        SetupWizardUtility.setProperty("WBEM_INSTALL_PATH", this.destinationPath);
        SetupWizardUtility.setProperty("DEVICE_CATEGORY", this.deviceCategory);
        SetupWizardUtility.setProperty("DEVICE_TYPE", this.deviceType);
        SetupWizardUtility.setProperty("DB_NAME", this.dbName);
        SetupWizardUtility.setProperty("DB_USER_NAME", this.dbUserId);
        SetupWizardUtility.setProperty("DB_PASSWORD", this.dbPassWord);
        SetupWizardUtility.setProperty("DB_HOST_URL", this.dbHostUrl);
        SetupWizardUtility.setProperty("SIMULATION_MODE", this.simulationMode);
        if (this.snapshotSetupMode && this.startFreshSnapshot) {
            SetupWizardUtility.setProperty("SNAPSHOT_SIMULATION_MODE", this.snapshot_type);
            SetupWizardUtility.setProperty("CIMOM_HOST_URL", this.cimomHostUrl);
            SetupWizardUtility.setProperty("CIMOM_PORT", this.cimomPort);
            SetupWizardUtility.setProperty("CIMOM_USER_ID", this.cimomUid);
            SetupWizardUtility.setProperty("CIMOM_PASSWORD", this.cimomPwd);
            SetupWizardUtility.setProperty("CIMOM_NAMESPACE", this.cimomNameSpace);
            SetupWizardUtility.setProperty("CIMOM_PROTOCOL", this.cimomProtocol);
            SetupWizardUtility.setProperty("CIMOM_TYPE", this.cimomType);
        } else if (this.snapshotSetupMode && this.restoreBackupDB) {
            SetupWizardUtility.setProperty("SNAPSHOT_SIMULATION_MODE", this.snapshot_type);
            SetupWizardUtility.setProperty("BACK_UP_PATH", this.strdbPath);
        } else {
            SetupWizardUtility.setProperty("CONFIG_FILE_PATH", this.strConfigFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    public void saveSnapshotInteractiveToFile() {
        SetupWizardUtility.simulatorProperties.clear();
        SetupWizardUtility.setProperty("DB_NAME", this.dbName);
        SetupWizardUtility.setProperty("DB_USER_NAME", this.dbUserId);
        SetupWizardUtility.setProperty("DB_PASSWORD", this.dbPassWord);
        SetupWizardUtility.setProperty("DB_HOST_URL", this.dbHostUrl);
        SetupWizardUtility.setProperty("CIMOM_HOST_URL", this.cimomHostUrl);
        SetupWizardUtility.setProperty("CIMOM_PORT", this.cimomPort);
        SetupWizardUtility.setProperty("CIMOM_USER_ID", this.cimomUid);
        SetupWizardUtility.setProperty("CIMOM_PASSWORD", this.cimomPwd);
        SetupWizardUtility.setProperty("CIMOM_NAMESPACE", this.cimomNameSpace);
        SetupWizardUtility.setProperty("CIMOM_PROTOCOL", this.cimomProtocol);
        SetupWizardUtility.interactive = this.interactiveSetup;
        SetupWizardUtility.setProperty("SIMULATION_MODE", "SNAPSHOT_MODE");
        SetupWizardUtility.setProperty("IS_CREATE_MOF", new Boolean(SetupWizardUtility.isCreateMof).toString());
        SetupWizardUtility.setProperty("IS_INSTALL_CIMOM", new Boolean(SetupWizardUtility.isInstallCIMOM).toString());
        SetupWizardUtility.setProperty("IS_COMPILE_CIMOM", new Boolean(SetupWizardUtility.isCompileMof).toString());
        SetupWizardUtility.setProperty("IS_SIMULATE_DEVICE", new Boolean(SetupWizardUtility.isSimulateDevice).toString());
        if (SetupWizardUtility.isCompileMof) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.cimomInstalledLocation);
            SetupWizardUtility.setProperty("MOF_FILE_PATH", SetupWizardUtility.mofFilePath);
        }
        if (SetupWizardUtility.isInstallCIMOM) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.dirLocationToInstallCIMOM);
        }
        if (SetupWizardUtility.isCreateMof) {
            SetupWizardUtility.setProperty("LOCATION_TO_SAVE_MOF", SetupWizardUtility.strPathTosaveMofFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    protected void SaveSetupParameterToFile() {
        if (this.snapshotSetupMode) {
            SetupWizardUtility.setProperty("SIMULATION_MODE", "SNAPSHOT_MODE");
        } else {
            SetupWizardUtility.setProperty("SIMULATION_MODE", "CONFIGURATION_MODE");
        }
        SetupWizardUtility.setProperty("IS_CREATE_MOF", new Boolean(SetupWizardUtility.isCreateMof).toString());
        SetupWizardUtility.setProperty("IS_INSTALL_CIMOM", new Boolean(SetupWizardUtility.isInstallCIMOM).toString());
        SetupWizardUtility.setProperty("IS_COMPILE_CIMOM", new Boolean(SetupWizardUtility.isCompileMof).toString());
        SetupWizardUtility.setProperty("IS_SIMULATE_DEVICE", new Boolean(SetupWizardUtility.isSimulateDevice).toString());
        if (SetupWizardUtility.isCompileMof) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.cimomInstalledLocation);
            SetupWizardUtility.setProperty("MOF_FILE_PATH", SetupWizardUtility.mofFilePath);
        }
        if (SetupWizardUtility.isInstallCIMOM) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.dirLocationToInstallCIMOM);
        }
        if (SetupWizardUtility.isCreateMof) {
            SetupWizardUtility.setProperty("LOCATION_TO_SAVE_MOF", SetupWizardUtility.strPathTosaveMofFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    public void saveConfigurationInteractiveToFile() {
        SetupWizardUtility.simulatorProperties.clear();
        SetupWizardUtility.setProperty("DB_NAME", this.dbName);
        SetupWizardUtility.setProperty("DB_USER_NAME", this.dbUserId);
        SetupWizardUtility.setProperty("DB_PASSWORD", this.dbPassWord);
        SetupWizardUtility.setProperty("DB_HOST_URL", this.dbHostUrl);
        SetupWizardUtility.setProperty("DEVICE_CATEGORY", this.deviceCategory);
        SetupWizardUtility.setProperty("DEVICE_TYPE", this.deviceType);
        SetupWizardUtility.setProperty("CONFIG_FILE_PATH", this.strConfigFile);
        SetupWizardUtility.interactive = this.interactiveSetup;
        SetupWizardUtility.setProperty("SIMULATION_MODE", "CONFIGURATION_MODE");
        SetupWizardUtility.setProperty("IS_CREATE_MOF", new Boolean(SetupWizardUtility.isCreateMof).toString());
        SetupWizardUtility.setProperty("IS_INSTALL_CIMOM", new Boolean(SetupWizardUtility.isInstallCIMOM).toString());
        SetupWizardUtility.setProperty("IS_COMPILE_CIMOM", new Boolean(SetupWizardUtility.isCompileMof).toString());
        SetupWizardUtility.setProperty("IS_SIMULATE_DEVICE", new Boolean(SetupWizardUtility.isSimulateDevice).toString());
        if (SetupWizardUtility.isCompileMof) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.cimomInstalledLocation);
            SetupWizardUtility.setProperty("MOF_FILE_PATH", SetupWizardUtility.mofFilePath);
        }
        if (SetupWizardUtility.isInstallCIMOM) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.dirLocationToInstallCIMOM);
        }
        if (SetupWizardUtility.isCreateMof) {
            SetupWizardUtility.setProperty("LOCATION_TO_SAVE_MOF", SetupWizardUtility.strPathTosaveMofFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    public void saveNonInteractiveToFile() {
    }

    protected void saveDirPath() {
        this.destinationPath = this.jtfdirName.getText();
        this.logger.debug((Object)("WBEM Install Path specified: " + this.destinationPath));
        this.wbemPropertiesSet = true;
    }

    protected void saveConfigProp() {
        this.strConfigFile = this.jtfConfigFilePath.getText();
        this.logger.debug((Object)("Configuration File Path mentioned: " + this.strConfigFile));
        this.configPropSet = true;
    }

    protected void saveSANPathProp() {
        SANPropPath = this.SANPropFile.toString();
        this.logger.debug((Object)("SAN Property File path specified: " + SANPropPath));
    }

    private File opendir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this.deviceSelectScreen());
        if (n == 1) {
            return DEFAULT_WBEM_DIR_PATH;
        }
        this.fileName = jFileChooser.getSelectedFile();
        return this.fileName;
    }

    private File openfile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showOpenDialog(this.deviceSelectScreen());
        if (n == 1) {
            return DEFAULT_PROPERTY_FILE_PATH;
        }
        this.configFile = jFileChooser.getSelectedFile();
        return this.configFile;
    }

    private String getConfFilePath() {
        String string = null;
        if (this.deviceCategory.equals("Switch")) {
            string = "conf\\Brocade-requirement.config";
        } else if (this.deviceCategory.equals("Storage")) {
            if (this.deviceType.equals("DS4K_9.16.G0.06")) {
                string = "conf\\DS4K-requirement.config";
            } else if (this.deviceType.equals("DS6K_5.1.0.40")) {
                string = "conf\\DS6K-requirement.config";
            } else if (this.deviceType.equals("DS8K_5.1.0.40")) {
                string = "conf\\DS8K-requirement.config";
            }
        }
        return string;
    }

    private void addComponent(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n2;
        this.constraints.gridy = n;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.layout.setConstraints(component, this.constraints);
        jPanel.add(component);
    }

    public JPanel customSetupOptions() {
        JPanel jPanel = new JPanel(this.layout);
        JLabel jLabel = new JLabel("<html><b>Choose your custom setup options</b><br><br> If you are a first time user of the \ufffdSAN Simulator\ufffd, we recommend you should select all the options. .<br></html>", 2);
        jLabel.setFont(new Font("Times New RomanSerif", 0, 12));
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setHorizontalTextPosition(2);
        jLabel.setIconTextGap(272);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(this.layout);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets.left = 10;
        gridBagConstraints2.insets.top = 10;
        this.jchbWbemInstall = new JCheckBox();
        this.jchbWbemInstall.setText(CREATE_NEW_CIMOM_CHECK_VALUE);
        this.jchbWbemInstall.setEnabled(true);
        this.jchbWbemInstall.setFont(new Font("Times New RomanSerif", 0, 12));
        this.jchbWbemInstall.addItemListener(new checkBoxListener(CREATE_NEW_CIMOM_CHECK_VALUE));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        jPanel2.add((Component)this.jchbWbemInstall, gridBagConstraints2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel3.add(new JLabel("Directory path of installed CIMOM:               "));
        this.jtfWbemInstallpathTxt = new JTextField(20);
        this.jtfWbemInstallpathTxt.setEnabled(false);
        jPanel3.add(this.jtfWbemInstallpathTxt);
        this.browseBt = new JButton("Browse");
        this.browseBt.addActionListener(new BrowseDirectoryListener(this.jtfWbemInstallpathTxt));
        this.browseBt.setEnabled(false);
        jPanel3.add(this.browseBt);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.bottom = 0;
        gridBagConstraints2.insets.left = 20;
        jPanel2.add((Component)jPanel3, gridBagConstraints2);
        this.jchbCompileMof = new JCheckBox();
        this.jchbCompileMof.setEnabled(true);
        this.jchbCompileMof.setText(COMPILE_MOF_CHECK_VALUE);
        this.jchbCompileMof.setFont(new Font("Times New RomanSerif", 0, 12));
        this.jchbCompileMof.addItemListener(new checkBoxListener(COMPILE_MOF_CHECK_VALUE));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets.left = 10;
        gridBagConstraints2.fill = 2;
        jPanel2.add((Component)this.jchbCompileMof, gridBagConstraints2);
        JPanel jPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel4.add(new JLabel("Directory path for CIMOM destination:         "));
        this.jtfCimomPathTxt = new JTextField(20);
        this.jtfCimomPathTxt.setEnabled(false);
        jPanel4.add(this.jtfCimomPathTxt);
        this.browseCimomDir = new JButton("Browse");
        this.browseCimomDir.addActionListener(new BrowseDirectoryListener(this.jtfCimomPathTxt));
        this.browseCimomDir.setEnabled(false);
        jPanel4.add(this.browseCimomDir);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets.left = 20;
        jPanel2.add((Component)jPanel4, gridBagConstraints2);
        JPanel jPanel5 = new JPanel(new FlowLayout(0, 0, 0));
        JLabel jLabel2 = new JLabel("Directory path of MOF files to compile:         ");
        jPanel5.add(jLabel2);
        this.jtfMofFilePathTxt = new JTextField(20);
        this.jtfMofFilePathTxt.setEnabled(false);
        jPanel5.add(this.jtfMofFilePathTxt);
        this.browseMofFile = new JButton("Browse");
        this.browseMofFile.addActionListener(new BrowseDirectoryListener(this.jtfMofFilePathTxt));
        this.browseMofFile.setEnabled(false);
        jPanel5.add(this.browseMofFile);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.insets.left = 20;
        jPanel2.add((Component)jPanel5, gridBagConstraints2);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setText("Compile Newly created MOF");
        jCheckBox.setFont(new Font("Times New RomanSerif", 0, 12));
        jCheckBox.setEnabled(false);
        jCheckBox.addItemListener(new checkBoxListener(SIMULATE_DEVICE_CHECK_VALUE));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.insets.left = 10;
        jPanel2.add((Component)jCheckBox, gridBagConstraints2);
        this.jchbSimulateDevice = new JCheckBox();
        this.jchbSimulateDevice.setText("Generate Configuration/Snapshot based simulation data");
        this.jchbSimulateDevice.setFont(new Font("Times New RomanSerif", 0, 12));
        this.jchbSimulateDevice.addItemListener(new checkBoxListener(SIMULATE_DEVICE_CHECK_VALUE));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.insets.left = 10;
        jPanel2.add((Component)this.jchbSimulateDevice, gridBagConstraints2);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Customize Setup"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        if (SetupWizardUtility.isCustomSetup) {
            if (SetupWizardUtility.isCompileMof) {
                this.jchbCompileMof.doClick();
                this.jtfCimomPathTxt.setText(SetupWizardUtility.cimomInstalledLocation);
                this.jtfMofFilePathTxt.setText(SetupWizardUtility.mofFilePath);
            }
            if (SetupWizardUtility.isInstallCIMOM) {
                this.jchbWbemInstall.doClick();
                this.jtfWbemInstallpathTxt.setText(SetupWizardUtility.dirLocationToInstallCIMOM);
            }
            if (SetupWizardUtility.isSimulateDevice) {
                this.jchbSimulateDevice.doClick();
            }
        }
        return jPanel;
    }

    private String getDeviceMOf() {
        String string = null;
        if (this.deviceCategory.equals("Switch")) {
            string = "SAN_Mof\\Brocade_110.4.0a";
        } else if (this.deviceCategory.equals("Storage")) {
            if (this.deviceType.equals("DS4K_9.16.G0.06")) {
                string = "SAN_Mof\\DS4K";
            } else if (this.deviceType.equals("DS6K_5.1.0.40")) {
                string = "SAN_Mof\\DS6K";
            } else if (this.deviceType.equals("DS8K_5.1.0.40")) {
                string = "SAN_Mof\\DS8K";
            }
        }
        return string;
    }

    protected void saveCustomSetupOtions() {
        SetupWizardUtility.isCustomSetup = true;
        if (this.jchbWbemInstall.isSelected()) {
            SetupWizardUtility.isInstallCIMOM = true;
            SetupWizardUtility.dirLocationToInstallCIMOM = this.jtfWbemInstallpathTxt.getText();
        } else {
            SetupWizardUtility.isInstallCIMOM = false;
            SetupWizardUtility.dirLocationToInstallCIMOM = null;
        }
        if (this.jchbSimulateDevice.isSelected()) {
            SetupWizardUtility.isSimulateDevice = true;
        }
        if (this.jchbCompileMof.isSelected()) {
            SetupWizardUtility.isCompileMof = true;
            SetupWizardUtility.cimomInstalledLocation = this.jtfCimomPathTxt.getText();
            SetupWizardUtility.mofFilePath = this.jtfMofFilePathTxt.getText();
        } else {
            SetupWizardUtility.isCompileMof = false;
            SetupWizardUtility.cimomInstalledLocation = null;
            SetupWizardUtility.mofFilePath = null;
        }
    }

    protected boolean isSetupParametersSet() {
        if (this.jchbWbemInstall.isSelected() && (this.jtfWbemInstallpathTxt.getText().equals("") || null == this.jtfWbemInstallpathTxt.getText())) {
            return false;
        }
        return !this.jchbCompileMof.isSelected() || !(this.jtfCimomPathTxt.isEnabled() ? this.jtfCimomPathTxt.getText().equals("") || null == this.jtfCimomPathTxt.getText() || this.jtfMofFilePathTxt.getText().equals("") || null == this.jtfMofFilePathTxt.getText() : this.jtfMofFilePathTxt.getText().equals("") || null == this.jtfMofFilePathTxt.getText());
    }

    protected boolean isSetupModeSet() {
        return this.installModeClicked;
    }

    protected void createSetuFile() {
    }

    private class BrowseDirectoryListener
    implements ActionListener {
        JTextField textField;

        public BrowseDirectoryListener(JTextField jTextField) {
            this.textField = jTextField;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.textField.setText(InputScreens.this.opendir().toString());
        }
    }

    private class checkBoxListener
    implements ItemListener {
        private String jchbclicked;

        public checkBoxListener(String string) {
            this.jchbclicked = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (this.jchbclicked.equals(InputScreens.CREATE_NEW_CIMOM_CHECK_VALUE)) {
                    this.setCIMOMPort();
                    InputScreens.this.jtfWbemInstallpathTxt.setEnabled(true);
                    if (InputScreens.this.jtfCimomPathTxt.isEnabled()) {
                        InputScreens.this.jtfCimomPathTxt.setEnabled(false);
                    }
                    InputScreens.this.browseBt.setEnabled(true);
                } else if (this.jchbclicked.equals(InputScreens.COMPILE_MOF_CHECK_VALUE)) {
                    if (InputScreens.this.jtfWbemInstallpathTxt.isEnabled()) {
                        InputScreens.this.jtfMofFilePathTxt.setEnabled(true);
                        InputScreens.this.browseMofFile.setEnabled(true);
                        if (!InputScreens.this.snapshotSetupMode) {
                            InputScreens.this.jtfMofFilePathTxt.setText(InputScreens.this.getDeviceMOf());
                        }
                    } else {
                        InputScreens.this.jtfCimomPathTxt.setEnabled(true);
                        InputScreens.this.browseCimomDir.setEnabled(true);
                        InputScreens.this.jtfMofFilePathTxt.setEnabled(true);
                        InputScreens.this.browseMofFile.setEnabled(true);
                    }
                } else if (this.jchbclicked.equals(InputScreens.CREATE_DEVICE_MOF_VALUE)) {
                    InputScreens.this.jtfMofFileTxt.setEnabled(true);
                    InputScreens.this.browseMofLoc.setEnabled(true);
                }
            } else if (itemEvent.getStateChange() == 2) {
                if (this.jchbclicked.equals(InputScreens.CREATE_NEW_CIMOM_CHECK_VALUE)) {
                    InputScreens.this.jtfWbemInstallpathTxt.setEnabled(false);
                    InputScreens.this.browseBt.setEnabled(false);
                    if (InputScreens.this.snapshotSetupMode && InputScreens.this.jtfMofFilePathTxt.isEnabled()) {
                        InputScreens.this.jtfCimomPathTxt.setEnabled(true);
                    }
                } else if (this.jchbclicked.equals(InputScreens.COMPILE_MOF_CHECK_VALUE)) {
                    InputScreens.this.jtfCimomPathTxt.setEnabled(false);
                    InputScreens.this.browseCimomDir.setEnabled(false);
                    InputScreens.this.jtfMofFilePathTxt.setEnabled(false);
                    InputScreens.this.browseMofFile.setEnabled(false);
                } else if (this.jchbclicked.equals(InputScreens.CREATE_DEVICE_MOF_VALUE)) {
                    InputScreens.this.jtfMofFileTxt.setEnabled(false);
                    InputScreens.this.browseMofLoc.setEnabled(false);
                }
            }
        }

        private void setCIMOMPort() {
            while (true) {
                String string = JOptionPane.showInputDialog("Enter Port number for CIMOM to run", (Object)"5988");
                InputScreens.this.logger.debug((Object)("Port Number Entered: " + string));
                if (string == null) continue;
                if (new CheckPreRequisites().CheckPort(Integer.parseInt(string))) break;
                JOptionPane.showMessageDialog(null, "This port is currently in use", "Port Busy", 0);
            }
        }
    }

    private class RadioButtonHandler
    implements ItemListener {
        private String jrbt;

        public RadioButtonHandler(String string) {
            this.jrbt = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                InputScreens.this.deviceClicked = true;
                if (this.jrbt.equals("Switch")) {
                    InputScreens.this.switchSelected = true;
                    InputScreens.this.storageSelected = false;
                    InputScreens.this.othersSelected = false;
                    InputScreens.this.serverSelected = false;
                    InputScreens.this.jcbServer.setEnabled(false);
                    InputScreens.this.jcbSwitch.setEnabled(true);
                    InputScreens.this.jcbStorage.setEnabled(false);
                    InputScreens.this.jcbOthers.setEnabled(false);
                    if (InputScreens.this.deviceType.equalsIgnoreCase("Not Set")) {
                        InputScreens.this.deviceType = "Brocade_110.4.0a";
                    }
                }
                if (this.jrbt.equals("Storage")) {
                    InputScreens.this.switchSelected = false;
                    InputScreens.this.storageSelected = true;
                    InputScreens.this.othersSelected = false;
                    InputScreens.this.serverSelected = false;
                    InputScreens.this.jcbServer.setEnabled(false);
                    InputScreens.this.jcbSwitch.setEnabled(false);
                    InputScreens.this.jcbStorage.setEnabled(true);
                    InputScreens.this.jcbOthers.setEnabled(false);
                    if (InputScreens.this.deviceType.equalsIgnoreCase("Not Set")) {
                        InputScreens.this.deviceType = "DS4K_9.16.G0.06";
                    }
                }
                if (this.jrbt.equals("Others")) {
                    InputScreens.this.switchSelected = false;
                    InputScreens.this.storageSelected = false;
                    InputScreens.this.othersSelected = true;
                    InputScreens.this.serverSelected = false;
                    InputScreens.this.jcbServer.setEnabled(false);
                    InputScreens.this.jcbSwitch.setEnabled(false);
                    InputScreens.this.jcbStorage.setEnabled(false);
                    InputScreens.this.jcbOthers.setEnabled(true);
                    InputScreens.this.deviceType = "IBM Tape Library";
                }
                if (this.jrbt.equals("Server")) {
                    InputScreens.this.switchSelected = false;
                    InputScreens.this.storageSelected = false;
                    InputScreens.this.othersSelected = false;
                    InputScreens.this.serverSelected = false;
                    InputScreens.this.jcbSwitch.setEnabled(false);
                    InputScreens.this.jcbStorage.setEnabled(false);
                    InputScreens.this.jcbOthers.setEnabled(false);
                    InputScreens.this.jrbSwitch.doClick();
                    JOptionPane.showMessageDialog(null, "Sorry! Server Simulation is yet not supported", "Invalid", 1);
                    InputScreens.this.deviceType = "Not Supported";
                }
            }
        }
    }

    private class SnapshotRadioHandler
    implements ItemListener {
        private String SnapshotMode;

        public SnapshotRadioHandler(String string) {
            this.SnapshotMode = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            InputScreens.this.setupModeClicked = true;
            if (this.SnapshotMode.equals("Restore")) {
                InputScreens.this.restoreBackupDB = true;
                InputScreens.this.startFreshSnapshot = false;
            } else if (this.SnapshotMode.equals("Fresh")) {
                InputScreens.this.restoreBackupDB = false;
                InputScreens.this.startFreshSnapshot = true;
            }
        }
    }

    private class InstallRadioHandler
    implements ItemListener {
        private String InstallMode;

        public InstallRadioHandler(String string) {
            this.InstallMode = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            InputScreens.this.installModeClicked = true;
            if (this.InstallMode.equals(InputScreens.NON_INTERACTIVE_VALUE)) {
                InputScreens.this.nonInteractiveSetup = true;
                InputScreens.this.interactiveSetup = false;
                InputScreens.this.jcbSimulation_mode.setEnabled(false);
            } else if (this.InstallMode.equals(InputScreens.INTERACTIVE_VALUE)) {
                InputScreens.this.nonInteractiveSetup = false;
                InputScreens.this.interactiveSetup = true;
                InputScreens.this.jcbSimulation_mode.setEnabled(true);
            }
        }
    }

    private class DeviceTypeHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (InputScreens.this.switchSelected) {
                    if (itemEvent.getItem().equals("Brocade_110.4.0a")) {
                        InputScreens.this.deviceType = itemEvent.getItem().toString();
                        InputScreens.this.logger.debug((Object)("Device type: " + InputScreens.this.deviceType));
                    } else {
                        String string = itemEvent.getItem().toString();
                        string = string.substring(0, string.indexOf(" "));
                        JOptionPane.showMessageDialog(null, "Sorry! Switch -> " + string + " simulation currently not supported.", "Invalid", 0);
                        InputScreens.this.jcbSwitch.setSelectedIndex(0);
                    }
                } else if (InputScreens.this.othersSelected) {
                    String string = itemEvent.getItem().toString();
                    if (string.equals("IBM Tape Library")) {
                        InputScreens.this.deviceType = itemEvent.getItem().toString();
                        InputScreens.this.logger.debug((Object)("Device type: " + InputScreens.this.deviceType));
                    } else {
                        JOptionPane.showMessageDialog(null, "Sorry! Others -> iSCSI simulation not supported yet", "Invalid", 0);
                        InputScreens.this.jcbOthers.setSelectedIndex(0);
                    }
                } else if (InputScreens.this.storageSelected) {
                    InputScreens.this.deviceType = itemEvent.getItem().toString();
                    InputScreens.this.logger.debug((Object)("Device type: " + InputScreens.this.deviceType));
                } else {
                    InputScreens.this.deviceType = "Not Sopported";
                }
            }
        }
    }

    private class SimulationModeHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItem().equals("Configuaration-based")) {
                InputScreens.this.logger.debug((Object)("Simulation Mode Selected: " + itemEvent.getItem()));
                if (InputScreens.this.deviceType.equals("IBM Tape Library")) {
                    JOptionPane.showMessageDialog(null, "Configuration Simuation approach not supported for IBM Tape Library currently", "Invalid", 0);
                    InputScreens.this.jcbSimulation_mode.setSelectedIndex(0);
                }
                InputScreens.this.snapshotSetupMode = false;
            } else {
                InputScreens.this.logger.debug((Object)("SImulation Mode Selected: " + itemEvent.getItem()));
                InputScreens.this.snapshotSetupMode = true;
            }
        }
    }

    private class TestDB
    implements ActionListener {
        private String hosturl;
        private String userid;
        private String dbname;
        private String password;

        private TestDB() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InputScreens.this.dbConnectionTested = true;
            TestDBConnection testDBConnection = new TestDBConnection();
            this.dbname = InputScreens.this.jtfDBName.getText();
            this.password = new String(InputScreens.this.jtfDBPasswd.getPassword()).equals("") ? "Default" : new String(InputScreens.this.jtfDBPasswd.getPassword());
            this.userid = InputScreens.this.jtfDBUserId.getText().equals("") ? "Default" : InputScreens.this.jtfDBUserId.getText();
            this.hosturl = InputScreens.this.jtfDBHostUrl.getText();
            InputScreens.this.logger.debug((Object)("Parameters Passed for DB test: " + this.dbname + "  " + this.password + "   " + this.userid + "  " + this.hosturl));
            int n = testDBConnection.testConnection(this.dbname, this.userid, this.password, this.hosturl);
            if (n == 1) {
                JOptionPane.showMessageDialog(null, "Database Connection successful", "Test DB Conncetion", 1);
                InputScreens.this.dbConnectionExist = true;
            } else {
                JOptionPane.showMessageDialog(null, "Databse Conncetion failed", "Test DB Conncetion", 0);
                InputScreens.this.dbConnectionExist = false;
            }
        }
    }

    private class TestCIMOM
    implements ActionListener {
        private String cimomurl;
        private String cimomuserid;
        private String cimompasswd;
        private String cimomnmspace;
        private String cimomprotocol;
        private String cimomport;

        private TestCIMOM() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            this.cimomurl = InputScreens.this.jtfCIMhost_url.getText();
            this.cimomport = InputScreens.this.jtfCIMport.getText();
            this.cimomuserid = InputScreens.this.jtfCIMuid.getText();
            this.cimompasswd = new String(InputScreens.this.jtfCIMpwd.getPassword());
            this.cimomnmspace = InputScreens.this.jtfCIMnmspace.getText();
            this.cimomprotocol = InputScreens.this.jcbprotocols.getSelectedItem().toString();
            TestWbemCimomConnection testWbemCimomConnection = new TestWbemCimomConnection();
            InputScreens.this.logger.debug((Object)"Sun WBEM CIMOM to connect");
            try {
                n = testWbemCimomConnection.testConnection(this.cimomurl, this.cimomport, this.cimomuserid, this.cimompasswd, this.cimomnmspace, this.cimomprotocol);
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
            if (n == 1) {
                JOptionPane.showMessageDialog(null, "Connection Successful !", "Test CIMOM Connection", 1);
                InputScreens.this.logger.info((Object)"CIMOM Connection successful!");
            } else if (n == 0) {
                JOptionPane.showMessageDialog(null, "Connection Refused !", "Test CIMOM Connection", 0);
                InputScreens.this.logger.info((Object)"Connection to CIMOM refused!");
            }
        }
    }

    private class SANPropbrowseButtonHandler
    implements ActionListener {
        private SANPropbrowseButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InputScreens.this.SANPropFile = InputScreens.this.openfile();
            InputScreens.this.jtfSANPropFilePath.setText(InputScreens.this.SANPropFile.toString());
        }
    }

    private class ConfigbrowseButtonHandler
    implements ActionListener {
        private ConfigbrowseButtonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InputScreens.this.jtfConfigFilePath.setText(InputScreens.this.openfile().toString());
        }
    }
}

