/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.DiscoveryUtil;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;

public class RemoteCIMClient {
    private static CIMClient cimClient;
    public static String deviceType;
    private static List sanPClassList;
    private static Logger logger;

    public static Vector getFreePortsForSelectedDevice() {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = null;
        try {
            sanPClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SANProtocolEndPoint");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Iterator iterator2 = RemoteCIMClient.getAllPortsForSelectedDevice().iterator();
        while (iterator2.hasNext()) {
            boolean bl = false;
            CIMInstance cIMInstance = (CIMInstance)iterator2.next();
            CIMValue cIMValue = cIMInstance.getProperty("DeviceID").getValue();
            iterator = sanPClassList.iterator();
            while (iterator.hasNext()) {
                CIMInstance cIMInstance2 = (CIMInstance)iterator.next();
                CIMValue cIMValue2 = cIMInstance2.getProperty("Name").getValue();
                if (!cIMValue2.equals((Object)cIMValue)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            String string = cIMInstance.getProperty("PortNumber").getValue().getValue().toString();
            String string2 = cIMInstance.getProperty("PermanentAddress").getValue().getValue().toString();
            vector.add("" + string + " (" + string2 + ")");
        }
        return vector;
    }

    public static void connect(String string, String string2, String string3, String string4, String string5, String string6) {
        UserPrincipal userPrincipal = null;
        PasswordCredential passwordCredential = null;
        try {
            if (string != null && string5 != null) {
                try {
                    CIMNameSpace cIMNameSpace = new CIMNameSpace(string6 + "://" + string + ":" + string2, string5);
                    if (string3 != null) {
                        userPrincipal = new UserPrincipal(string3);
                    }
                    if (string4 != null) {
                        passwordCredential = new PasswordCredential(string4);
                    }
                    cimClient = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential);
                    System.out.println("CIMOM connection successful");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    logger.error((Object)("Unable To Connect to CIMOM [" + string + "]" + exception.getMessage()));
                }
            } else {
                logger.error((Object)"Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }

    public static void configureConnection() {
        try {
            RemoteCIMClient.findDevicetype();
            logger.debug((Object)("Target Device Type Found: " + deviceType));
            ConnectionUtility.targetDevcieType = deviceType;
            RemoteCIMClient.changeCIMClient();
        }
        catch (CIMException cIMException) {
            logger.error((Object)cIMException);
        }
        logger.debug((Object)"CIM Client changed");
    }

    private static void changeCIMClient() throws CIMException {
        cimClient.close();
        if (deviceType.equals("Switch")) {
            RemoteCIMClient.connect(ConnectionUtility.CIMOMHostUrl, ConnectionUtility.CIMOMPort, ConnectionUtility.CIMOMUserName, ConnectionUtility.CIMOMPassword, "/root/brocade1", ConnectionUtility.CIMOMProtocol);
        } else if (deviceType.equals("DS4K")) {
            RemoteCIMClient.connect(ConnectionUtility.CIMOMHostUrl, ConnectionUtility.CIMOMPort, ConnectionUtility.CIMOMUserName, ConnectionUtility.CIMOMPassword, "/root/lsissi11", ConnectionUtility.CIMOMProtocol);
        } else if (deviceType.equals("DS6K")) {
            RemoteCIMClient.connect(ConnectionUtility.CIMOMHostUrl, ConnectionUtility.CIMOMPort, ConnectionUtility.CIMOMUserName, ConnectionUtility.CIMOMPassword, "/root/ibm", ConnectionUtility.CIMOMProtocol);
        }
    }

    private static void findDevicetype() throws CIMException {
        ArrayList arrayList = new ArrayList();
        arrayList.add(ConnectionUtility.CIMOMNameSpace);
        try {
            arrayList = DiscoveryUtil.getNamespaces((CIMClient)cimClient, arrayList, (String)"Array");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        deviceType = arrayList.contains("/root/brocade1") ? "Switch" : (arrayList.contains("/root/lsissi11") ? "DS4K" : (arrayList.contains("/root/ibm") ? "DS6K" : "Unknown"));
    }

    public static void closeConnection() {
        if (cimClient != null) {
            try {
                cimClient.close();
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
            }
        }
    }

    private static List getAllPortsForSelectedDevice() {
        CIMObjectPath cIMObjectPath;
        CIMObjectPath cIMObjectPath2;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        ArrayList<CIMInstance> arrayList = new ArrayList<CIMInstance>();
        try {
            cIMObjectPath2 = new CIMObjectPath("CIM_FCPort");
            enumeration = cimClient.enumerateInstances(cIMObjectPath2, true, false, true);
            cIMObjectPath = new CIMObjectPath("CIM_ComputerSystem");
            enumeration2 = cimClient.enumerateInstances(cIMObjectPath, true, false, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error((Object)("Error in enumerating ComputerSystem " + exception));
        }
        while (enumeration2.hasMoreElements()) {
            cIMObjectPath2 = (CIMInstance)enumeration2.nextElement();
            cIMObjectPath = cIMObjectPath2.getProperty("Name").getValue();
            String string = ConnectionUtility.deviceName.split("_")[1];
            if (!cIMObjectPath.getValue().toString().equalsIgnoreCase(string)) continue;
            CIMValue cIMValue = cIMObjectPath2.getProperty("Name").getValue();
            while (enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                CIMValue cIMValue2 = cIMInstance.getProperty("SystemName").getValue();
                if (!cIMValue.equals((Object)cIMValue2)) continue;
                arrayList.add(cIMInstance);
            }
            break block2;
        }
        return arrayList;
    }

    public static Vector enumerateTargetDevcieNames() {
        CIMObjectPath cIMObjectPath = null;
        Enumeration enumeration = null;
        Vector<String> vector = new Vector<String>();
        cIMObjectPath = new CIMObjectPath("CIM_ComputerSystem");
        try {
            enumeration = cimClient.enumerateInstances(cIMObjectPath, true, false, true);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            logger.error((Object)("Error in Enumerating Device Names: " + (Object)((Object)cIMException)));
        }
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            CIMValue cIMValue = cIMInstance.getProperty("Dedicated").getValue();
            if (cIMValue == null) continue;
            String string = cIMInstance.getProperty("ElementName").getValue().getValue().toString();
            String string2 = cIMInstance.getProperty("Name").getValue().getValue().toString();
            if (string.equalsIgnoreCase("IBM TotalStorage DS8000")) {
                string = "DS8K";
            } else if (string.equalsIgnoreCase("IBM TotalStorage DS6000")) {
                string = "DS6K";
            }
            vector.add(string + "_" + string2);
        }
        return vector;
    }

    static {
        logger = Logger.getLogger((Class)RemoteCIMClient.class);
    }
}

