/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionDataGenerator;
import org.eclipse.aperi.simulator.ui.CompileMOF;
import org.eclipse.aperi.simulator.ui.ConfigDataGenerator;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.CopyDirectory;
import org.eclipse.aperi.simulator.ui.CreateSetupScreen;
import org.eclipse.aperi.simulator.ui.DatabaseUtility;
import org.eclipse.aperi.simulator.ui.GenerateMof;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;
import org.eclipse.aperi.simulator.ui.TakeSnapshot;

public class SetupProcess
extends Thread {
    private CreateSetupScreen setupScreen;
    private static final String START_CIMOM = "simulator_start_cimom.bat";
    private static final String WBEM_PROPERTIES = "WBEMServices_Win32.properties";
    private static final String CIMOM_PROPERTIES = "san_simulator_cimom.properties";
    private Logger logger = Logger.getLogger((Class)SetupProcess.class);

    public void run() {
        this.setupScreen = new CreateSetupScreen();
        try {
            if (ConnectionUtility.isSimConnection) {
                this.SetupConnection();
            } else {
                this.SetupSANSimulator();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void SetupConnection() {
        this.setupScreen.jProgressBar.setValue(2);
        this.logger.info((Object)"Connection DataGeneration to proceed..");
        ConnectionDataGenerator connectionDataGenerator = new ConnectionDataGenerator();
        try {
            connectionDataGenerator.generateData();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setupScreen.jbFinish.setVisible(true);
        this.setupScreen.jbCancel.setVisible(false);
        this.setupScreen.jProgressBar.setValue(10);
        this.logger.info((Object)"Connection Data Generation completed Successfully ");
        this.setupScreen.jlInfo.setText("<html><br><b>Setup Completed successfully!Click Finish to exit</b><br><br><html>");
    }

    public void SetupSANSimulator() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SetupWizardUtility.loadProperties();
        this.setupScreen.jProgressBar.setValue(1);
        if (SetupWizardUtility.isCreateMof) {
            object4 = new GenerateMof();
            ((GenerateMof)object4).generate();
            this.setupScreen.jchbCreateMof.setEnabled(true);
            this.setupScreen.jchbCreateMof.doClick();
            this.setupScreen.jchbCreateMof.setEnabled(false);
        }
        this.setupScreen.jProgressBar.setValue(3);
        if (SetupWizardUtility.isInstallCIMOM) {
            object4 = null;
            object4 = SetupWizardUtility.getProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM");
            this.logger.debug((Object)("WBEM install path ->" + (String)object4));
            this.logger.info((Object)"Setup for SAN Simulator to Proceed");
            File file = new File((String)object4);
            if (!file.exists()) {
                new File((String)object4).mkdirs();
            }
            try {
                this.setupScreen.jProgressBar.setValue(1);
                object3 = new File(".", "wbemservices");
                object2 = new File((String)object4, "wbemservices");
                CopyDirectory.copyDirectory((File)object3, (File)object2);
                object3 = new File(".", "lib");
                object2 = new File((String)object4, "lib");
                CopyDirectory.copyDirectory((File)object3, (File)object2);
                object = new File((String)object4, START_CIMOM);
                File file2 = new File(".", START_CIMOM);
                CopyDirectory.copyFile(file2, (File)object);
                object = new File((String)object4, CIMOM_PROPERTIES);
                file2 = new File(".", CIMOM_PROPERTIES);
                CopyDirectory.copyFile(file2, (File)object);
                object = new File((String)object4, WBEM_PROPERTIES);
                file2 = new File(".", WBEM_PROPERTIES);
                CopyDirectory.copyFile(file2, (File)object);
                this.setupScreen.jchbWbemInstall.setEnabled(true);
                this.setupScreen.jchbWbemInstall.doClick();
                this.setupScreen.jchbWbemInstall.setEnabled(false);
                this.setupScreen.jProgressBar.setValue(4);
            }
            catch (Exception exception) {
                this.logger.error((Object)("Error occured in copying WBEM directory " + exception));
                exception.printStackTrace();
            }
            this.logger.info((Object)"WBEM directory copied successfully!");
        } else {
            this.setupScreen.jProgressBar.setValue(4);
        }
        if (SetupWizardUtility.isCompileMof) {
            int n = new CompileMOF().compile();
            this.logger.info((Object)"MOF Compilation is successful!");
            if (n == 1) {
                this.setupScreen.jProgressBar.setValue(4);
                this.setupScreen.jchbMofCompile.setEnabled(true);
                this.setupScreen.jchbMofCompile.doClick();
                this.setupScreen.jchbMofCompile.setEnabled(false);
                JOptionPane.showMessageDialog(null, "Please close start_cimom.bat command window to resume installation", "Information", 1);
            } else {
                this.logger.error((Object)"Error encountered in MOF Compilation!");
                JOptionPane.showMessageDialog(null, "Error occurred while compiling MOFs !", "Error", 0);
            }
        } else {
            this.setupScreen.jProgressBar.setValue(5);
        }
        if (SetupWizardUtility.isSimulateDevice) {
            DatabaseUtility databaseUtility = new DatabaseUtility();
            int n = databaseUtility.CreateDatabase();
            if (n == 1) {
                this.logger.info((Object)"Database creation and configuration went successful!");
                this.setupScreen.jProgressBar.setValue(6);
                if (SetupWizardUtility.getProperty("SIMULATION_MODE").equals("SNAPSHOT_MODE")) {
                    this.logger.info((Object)"Snapshot-Based Simulation to Proceed");
                    object3 = new TakeSnapshot();
                    ((TakeSnapshot)object3).ConfigureDBForSnapshot();
                    ((TakeSnapshot)object3).startSnapshot();
                } else if (SetupWizardUtility.getProperty("SIMULATION_MODE").equals("CONFIGURATION_MODE")) {
                    object3 = SetupWizardUtility.getProperty("CONFIG_FILE_PATH");
                    this.logger.info((Object)"Configuration-Based Simulation to proceed");
                    object2 = new ConfigDataGenerator();
                    object = SetupWizardUtility.getProperty("DEVICE_TYPE");
                    ((ConfigDataGenerator)object2).ConfigureDBForConfiguration();
                    ((ConfigDataGenerator)object2).generator((String)object3, (String)object);
                }
            } else if (n == 0) {
                this.logger.error((Object)"Error occur in database configuration !");
                JOptionPane.showMessageDialog(null, "Error occured during setup !", "Error", 0);
                System.exit(0);
            }
            this.setupScreen.jchbDBCreated.setEnabled(true);
            this.setupScreen.jchbDBCreated.doClick();
            this.setupScreen.jchbDBCreated.setEnabled(false);
        }
        this.setupScreen.jbFinish.setVisible(true);
        this.setupScreen.jbCancel.setVisible(false);
        this.setupScreen.jProgressBar.setValue(10);
        this.setupScreen.jlInfo.setText("<html><br><b>Setup Completed successfully!  Click Finish to exit</b><br><br><html>");
    }
}

