/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;

public class SwitchDBClient {
    public static List sanPClassList;
    public static Vector switchNames;
    public static Map fabricMap;
    public static Map switchNameIDMap;
    private static Logger logger;
    public static Vector fabricNames;

    public static void configDBForSwitch() {
        Properties properties = new Properties();
        properties.setProperty("DATABASE", "db2");
        properties.setProperty("DB_NAME", ConnectionUtility.switchDBName);
        properties.setProperty("DB_USERNAME", ConnectionUtility.switchDBUserid);
        properties.setProperty("DB_PASSWORD", ConnectionUtility.switchDBPassword);
        properties.setProperty("DB_LOCATION", ConnectionUtility.switchDBUrl);
        try {
            File file = File.createTempFile("setupwizard", ".config");
            file.deleteOnExit();
            properties.store(new FileOutputStream(file), "SETUP WIZARD PROPERTIES");
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", file.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Vector getFreePortsForSwitch(boolean bl) {
        CIMValue cIMValue;
        CIMValue cIMValue2;
        CIMInstance cIMInstance;
        CIMInstance cIMInstance2;
        Object object;
        Object object2;
        Iterator iterator = null;
        Iterator iterator2 = null;
        Vector<String> vector = new Vector<String>();
        String string = bl ? ConnectionUtility.switchName : ConnectionUtility.deviceName;
        try {
            object2 = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SwitchFCPort");
            object = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Switch");
            sanPClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SANProtocolEndPoint");
            iterator2 = object.iterator();
            iterator = object2.iterator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ArrayList<CIMValue> arrayList = new ArrayList<CIMValue>();
        while (iterator2.hasNext()) {
            cIMInstance2 = (CIMInstance)iterator2.next();
            String string2 = cIMInstance2.getProperty("ElementName").getValue().getValue().toString();
            if (!string2.equals(string)) continue;
            cIMInstance = cIMInstance2.getProperty("Name").getValue();
            while (iterator.hasNext()) {
                cIMValue2 = (CIMInstance)iterator.next();
                cIMValue = cIMValue2.getProperty("SystemName").getValue();
                if (!cIMInstance.equals((Object)cIMValue)) continue;
                arrayList.add(cIMValue2);
            }
            break block2;
        }
        cIMInstance2 = arrayList.iterator();
        while (cIMInstance2.hasNext()) {
            boolean bl2 = false;
            cIMInstance = (CIMInstance)cIMInstance2.next();
            cIMValue2 = cIMInstance.getProperty("DeviceID").getValue();
            cIMValue = sanPClassList.iterator();
            while (cIMValue.hasNext()) {
                CIMInstance cIMInstance3 = (CIMInstance)cIMValue.next();
                CIMValue cIMValue3 = cIMInstance3.getProperty("Name").getValue();
                if (!cIMValue3.equals((Object)cIMValue2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            object = cIMInstance.getProperty("PortNumber").getValue().getValue().toString();
            object2 = cIMInstance.getProperty("PermanentAddress").getValue().getValue().toString();
            vector.add("" + (String)object + " (" + (String)object2 + ")");
        }
        return vector;
    }

    public static Vector enumerateSwitchNames() {
        Object var0 = null;
        Vector<String> vector = new Vector<String>();
        vector.add("");
        return vector;
    }

    public static Vector enumerateSwitchName(String string) {
        Vector vector = null;
        return vector;
    }

    public static Vector enumerateSwitchNames(String string) {
        Object var1_1 = null;
        Vector<String> vector = new Vector<String>();
        vector.add("");
        List list = null;
        try {
            list = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SwitchInFabric");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CIMInstance cIMInstance = (CIMInstance)iterator.next();
            String string2 = cIMInstance.getProperty("GroupComponent").getValue().getValue().toString();
            if (!string2.equals(string)) continue;
            CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance.getProperty("PartComponent").getValue().getValue().toString());
            String string3 = cIMObjectPath.getKey("Name").getValue().getValue().toString();
            String string4 = (String)switchNameIDMap.get(string3);
            logger.debug((Object)("Switch available: " + string4));
            vector.add(string4);
        }
        return vector;
    }

    public static Vector enumerateFabric() {
        List list = null;
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        try {
            list = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Fabric");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CIMInstance cIMInstance = (CIMInstance)iterator.next();
            vector.add(cIMInstance.getObjectPath());
        }
        return vector;
    }

    public static List getSANProtocolEndPointFromSwitch() {
        return sanPClassList;
    }

    private static void createSwitchIDMap() {
        switchNameIDMap.clear();
        try {
            List list = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Switch");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CIMInstance cIMInstance = (CIMInstance)iterator.next();
                String string = cIMInstance.getProperty("Name").getValue().getValue().toString();
                String string2 = cIMInstance.getProperty("ElementName").getValue().getValue().toString();
                switchNameIDMap.put(string, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void getDeviceConnectData() {
        SwitchDBClient.createSwitchIDMap();
        Vector vector = SwitchDBClient.enumerateFabric();
        Iterator iterator = vector.iterator();
        fabricNames.removeAllElements();
        fabricMap.clear();
        while (iterator.hasNext()) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)iterator.next();
            String string = cIMObjectPath.toString();
            Vector vector2 = SwitchDBClient.enumerateSwitchNames(string);
            String string2 = cIMObjectPath.getKey("Name").getValue().getValue().toString();
            fabricMap.put(string2, vector2);
            fabricNames.add(string2);
        }
    }

    static {
        fabricMap = new HashMap();
        switchNameIDMap = new HashMap();
        logger = Logger.getLogger((Class)SwitchDBClient.class);
        fabricNames = new Vector();
    }
}

