/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.cimom.common.GenericSnapshotmaker;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class TakeSnapshot {
    private Logger logger = Logger.getLogger((Class)TakeSnapshot.class);

    public void ConfigureDBForSnapshot() {
        Properties properties = new Properties();
        properties.setProperty("DATABASE", "db2");
        properties.setProperty("DB_NAME", SetupWizardUtility.getProperty("DB_NAME"));
        properties.setProperty("DB_USER", SetupWizardUtility.getProperty("DB_USER_NAME"));
        properties.setProperty("DB_PASSWORD", SetupWizardUtility.getProperty("DB_PASSWORD"));
        properties.setProperty("DB_LOCATION", SetupWizardUtility.getProperty("DB_HOST_URL"));
        try {
            File file = File.createTempFile("setupwizard", ".config");
            file.deleteOnExit();
            properties.store(new FileOutputStream(file), "SETUP WIZARD PROPERTIES");
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", file.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void startSnapshot() {
        try {
            String string = SetupWizardUtility.getProperty("CIMOM_PROTOCOL") + "://" + SetupWizardUtility.getProperty("CIMOM_HOST_URL") + ":" + SetupWizardUtility.getProperty("CIMOM_PORT");
            String string2 = SetupWizardUtility.getProperty("CIMOM_USER_ID");
            String string3 = SetupWizardUtility.getProperty("CIMOM_PASSWORD");
            String string4 = SetupWizardUtility.getProperty("CIMOM_NAMESPACE");
            System.out.println(string + " " + string2 + " " + string3 + " " + string4);
            this.logger.debug((Object)("CIMOM URL form for Snapshotting -> " + string + " " + string2 + " " + string3 + " " + string4));
            GenericSnapshotmaker genericSnapshotmaker = new GenericSnapshotmaker(string, string4, string2, string3);
            genericSnapshotmaker.startSnapshotMaker();
            long l = System.currentTimeMillis();
            long l2 = System.currentTimeMillis();
            this.logger.info((Object)("Time taken to snapshot this CIMOM = " + (l2 - l) / 1000L + " Seconds"));
            System.out.println("Time Taken to snapshot this CIMOM = " + (l2 - l) / 1000L + " Seconds");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.debug((Object)exception);
        }
    }
}

