/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import org.apache.log4j.Logger;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.SwitchDBClient;

public class TargetDeviceDBClient {
    private static Connection connection;
    public static String storageDeviceCategory;
    private static Map DeviceTypeMap;
    private static Logger logger;

    private static List getAllPortsForSelectedDevice() {
        Object object;
        List<CIMInstance> list;
        Iterator iterator = null;
        Iterator iterator2 = null;
        try {
            list = null;
            object = null;
            if (storageDeviceCategory.equals("DS4K")) {
                list = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_FCPort");
                object = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_StorageSystem");
            } else if (storageDeviceCategory.equals("DS6K")) {
                list = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_FCPort");
                object = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_StorageSystem");
            }
            iterator = list.iterator();
            iterator2 = object.iterator();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        list = new ArrayList();
        while (iterator2.hasNext()) {
            object = (CIMInstance)iterator2.next();
            CIMValue cIMValue = object.getProperty("Name").getValue();
            String string = ConnectionUtility.deviceName.split("_")[1];
            if (!cIMValue.getValue().toString().equalsIgnoreCase(string)) continue;
            while (iterator.hasNext()) {
                CIMInstance cIMInstance = (CIMInstance)iterator.next();
                CIMValue cIMValue2 = cIMInstance.getProperty("SystemName").getValue();
                if (!cIMValue.equals((Object)cIMValue2)) continue;
                list.add(cIMInstance);
            }
            break block2;
        }
        return list;
    }

    public static void configDBForTargetDevice() {
        String string = ConnectionUtility.targetDevcieDBUrl;
        String string2 = ConnectionUtility.targetDevcieDBName;
        String string3 = ConnectionUtility.targetDevcieDBUserid;
        String string4 = ConnectionUtility.targetDevcieDBPassword;
        if (string4.equals("") || string3.equals("")) {
            String string5 = "jdbc:db2:" + string2;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                connection = DriverManager.getConnection(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error((Object)("Exception in DB Configuration: " + classNotFoundException));
            }
            catch (SQLException sQLException) {
                logger.error((Object)("SQLException in DB Configuration: " + sQLException));
            }
            logger.debug((Object)("Target Device DB Configured with DB URL: " + string5));
        } else {
            String string6 = "jdbc:db2://" + string + ":50000/" + string2;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                connection = DriverManager.getConnection(string6, string3, string4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error((Object)("Exception in DB COnfiguration: " + classNotFoundException));
            }
            catch (SQLException sQLException) {
                logger.error((Object)("Exception in DB COnfiguration: " + sQLException));
            }
            logger.debug((Object)("Target Device DB Configured for DB URL: " + string6));
        }
    }

    private static String getDeviceType() {
        String string = null;
        String string2 = ConnectionUtility.deviceName;
        string = (String)DeviceTypeMap.get(string2);
        return string;
    }

    public static Vector getFreePortsForSelectedDevice() {
        storageDeviceCategory = TargetDeviceDBClient.getDeviceType();
        Iterator iterator = null;
        List list = new ArrayList();
        Vector<String> vector = new Vector<String>();
        try {
            list = SwitchDBClient.getSANProtocolEndPointFromSwitch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Iterator iterator2 = TargetDeviceDBClient.getAllPortsForSelectedDevice().iterator();
        while (iterator2.hasNext()) {
            boolean bl = false;
            CIMInstance cIMInstance = (CIMInstance)iterator2.next();
            CIMValue cIMValue = cIMInstance.getProperty("DeviceID").getValue();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                CIMInstance cIMInstance2 = (CIMInstance)iterator.next();
                CIMValue cIMValue2 = cIMInstance2.getProperty("Name").getValue();
                if (!cIMValue2.equals((Object)cIMValue)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            String string = cIMInstance.getProperty("PortNumber").getValue().getValue().toString();
            String string2 = cIMInstance.getProperty("PermanentAddress").getValue().getValue().toString();
            vector.add("" + string + " (" + string2 + ")");
        }
        return vector;
    }

    public static Vector enumerateStorageNames() {
        String string;
        String string2;
        CIMInstance cIMInstance;
        List list = null;
        Vector<String> vector = new Vector<String>();
        try {
            list = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_StorageSystem");
        }
        catch (Exception exception) {
            logger.error((Object)("Error in Enumerating: " + exception));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            cIMInstance = (CIMInstance)iterator.next();
            string2 = cIMInstance.getProperty("ElementName").getValue().getValue().toString();
            string = cIMInstance.getProperty("Name").getValue().getValue().toString();
            vector.add(string2 + "_" + string);
            DeviceTypeMap.put(string2 + "_" + string, "DS4K");
        }
        try {
            list = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_StorageSystem");
        }
        catch (Exception exception) {
            logger.error((Object)("Error in Enumerating: " + exception));
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            cIMInstance = (CIMInstance)iterator.next();
            string2 = cIMInstance.getProperty("ElementName").getValue().getValue().toString();
            string2 = string2.equalsIgnoreCase("IBM TotalStorage DS8000") ? "DS8K" : "DS6K";
            string = cIMInstance.getProperty("Name").getValue().getValue().toString();
            vector.add(string2 + "_" + string);
            DeviceTypeMap.put(string2 + "_" + string, "DS6K");
        }
        return vector;
    }

    static {
        DeviceTypeMap = new HashMap();
        logger = Logger.getLogger((Class)TargetDeviceDBClient.class);
    }
}

