/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.apogy.addons.monitoring.ValueSource;
import org.eclipse.apogy.addons.monitoring.ui.TimeValueSeries;
import org.eclipse.apogy.addons.monitoring.ui.impl.AbstractTimePlotImpl;
import org.eclipse.apogy.common.ui.birt.composites.ValueVsTimeBIRTChartComposite;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Composite;

public class AbstractTimePlotCustomImpl<T>
extends AbstractTimePlotImpl<T> {
    protected ValueVsTimeBIRTChartComposite valueVsTimeBIRTChartComposite = null;
    protected Adapter valueSourceAdapter;
    protected TimeValueSeries timeValueSeries = new TimeValueSeries();
    protected long lastSampleTime = 0L;

    @Override
    public void initialise(Composite parent, int style) {
        this.valueVsTimeBIRTChartComposite = this.createChartComposite(parent, style);
        if (this.timeValueSeries.size() == 0) {
            this.timeValueSeries.addTimeValue(new Date(), 0.0);
        }
        this.valueVsTimeBIRTChartComposite.updateValues(this.timeValueSeries.getTimes(), this.timeValueSeries.getValues());
        if (this.getValueSource() != null && !this.getValueSource().eAdapters().contains((Object)this.getValueSourceAdapter())) {
            this.getValueSource().eAdapters().add((Object)this.getValueSourceAdapter());
        }
        if (this.getTitle() != null) {
            this.valueVsTimeBIRTChartComposite.setChartTitle(this.getTitle());
        }
        this.valueVsTimeBIRTChartComposite.setHistorySize(this.getMaximumHistorySize());
        this.valueVsTimeBIRTChartComposite.setHistoryTimeLength(Math.round(this.getMaximumHistoryTimeLength()) * 1000);
        if (this.getXAxisName() != null) {
            this.valueVsTimeBIRTChartComposite.setXAxisName(this.getXAxisName());
        }
        if (this.getYAxisName() != null) {
            this.valueVsTimeBIRTChartComposite.setYAxisName(this.getYAxisName());
        }
        if (this.getXAxisColor() != null) {
            this.valueVsTimeBIRTChartComposite.setXAxisColor(this.getXAxisColor().rgb);
        }
        if (this.getYAxisColor() != null) {
            this.valueVsTimeBIRTChartComposite.setYAxisColor(this.getYAxisColor().rgb);
        }
        if (this.getPlotGridColor() != null) {
            this.valueVsTimeBIRTChartComposite.setPlotGridColor(this.getPlotGridColor().rgb);
        }
        if (this.getPlotBackgroundColor() != null) {
            this.valueVsTimeBIRTChartComposite.setPlotBackgroundColor(this.getPlotBackgroundColor().rgb);
        }
        if (this.getTimeFormatString() != null) {
            this.valueVsTimeBIRTChartComposite.setTimeFormatString(this.getTimeFormatString());
        }
        if (this.getValuesFormatString() != null) {
            this.valueVsTimeBIRTChartComposite.setYAxisFormatString(this.getValuesFormatString());
        }
        this.lastSampleTime = 0L;
    }

    @Override
    public void dispose() {
        if (this.getValueSource() != null) {
            this.getValueSource().eAdapters().remove((Object)this.getValueSourceAdapter());
        }
    }

    @Override
    public void setTitle(String newTitle) {
        super.setTitle(newTitle);
        if (newTitle != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setChartTitle(newTitle);
        }
    }

    @Override
    public void setXAxisName(String newXAxisName) {
        super.setXAxisName(newXAxisName);
        if (newXAxisName != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setXAxisName(newXAxisName);
        }
    }

    @Override
    public void setXAxisColor(RGBA newXAxisColor) {
        super.setXAxisColor(newXAxisColor);
        if (newXAxisColor != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setXAxisColor(this.xAxisColor.rgb);
        }
    }

    @Override
    public void setYAxisName(String newYAxisName) {
        super.setYAxisName(newYAxisName);
        if (newYAxisName != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setYAxisName(newYAxisName);
        }
    }

    @Override
    public void setYAxisColor(RGBA newYAxisColor) {
        super.setYAxisColor(newYAxisColor);
        if (newYAxisColor != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setYAxisColor(this.yAxisColor.rgb);
        }
    }

    @Override
    public void setPlotBackgroundColor(RGBA newPlotBackgroundColor) {
        super.setPlotBackgroundColor(newPlotBackgroundColor);
        if (newPlotBackgroundColor != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setPlotBackgroundColor(newPlotBackgroundColor.rgb);
        }
    }

    @Override
    public void setPlotGridColor(RGBA newPlotGridColor) {
        super.setPlotGridColor(newPlotGridColor);
        if (newPlotGridColor != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setPlotGridColor(newPlotGridColor.rgb);
        }
    }

    @Override
    public void setTimeFormatString(String newTimeFormatString) {
        super.setTimeFormatString(newTimeFormatString);
        if (newTimeFormatString != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setTimeFormatString(newTimeFormatString);
        }
    }

    @Override
    public void setSeriesColor(RGBA newSeriesColor) {
        super.setSeriesColor(newSeriesColor);
        if (newSeriesColor != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setSeriesColor(newSeriesColor.rgb);
        }
    }

    @Override
    public void setValuesFormatString(String newValuesFormatString) {
        super.setValuesFormatString(newValuesFormatString);
        if (newValuesFormatString != null && this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.setYAxisFormatString(newValuesFormatString);
        }
    }

    @Override
    public void setMaximumHistorySize(int newMaximumHistorySize) {
        super.setMaximumHistorySize(newMaximumHistorySize);
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            if (newMaximumHistorySize > 0) {
                this.valueVsTimeBIRTChartComposite.setHistorySize(newMaximumHistorySize);
            } else {
                this.valueVsTimeBIRTChartComposite.setHistorySize(Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public void setMaximumHistoryTimeLength(float newMaximumhistoryTimeLength) {
        super.setMaximumHistoryTimeLength(newMaximumhistoryTimeLength);
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            if (newMaximumhistoryTimeLength > 0.0f) {
                this.valueVsTimeBIRTChartComposite.setHistoryTimeLength(Math.round(newMaximumhistoryTimeLength) * 1000);
            } else {
                this.valueVsTimeBIRTChartComposite.setHistoryTimeLength(Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public Composite getComposite() {
        return this.valueVsTimeBIRTChartComposite;
    }

    @Override
    public void setValueSource(ValueSource<T> newValueSource) {
        ValueSource oldValueSource = this.getValueSource();
        if (oldValueSource != null) {
            oldValueSource.eAdapters().remove((Object)this.getValueSourceAdapter());
        }
        super.setValueSource(newValueSource);
        this.clearPlot();
        if (newValueSource != null && !newValueSource.eAdapters().contains((Object)this.getValueSourceAdapter())) {
            newValueSource.eAdapters().add((Object)this.getValueSourceAdapter());
        }
    }

    protected ValueVsTimeBIRTChartComposite createChartComposite(Composite parent, int style) {
        return new ValueVsTimeBIRTChartComposite(parent, style){

            protected SortedMap<CDateTime, Double> manageHistorySize(SortedMap<CDateTime, Double> currentDataSeries) {
                SortedMap<CDateTime, Double> result = null;
                switch (AbstractTimePlotCustomImpl.this.getHistorySizeManagementPolicy().getValue()) {
                    case 0: {
                        result = super.manageHistorySize(currentDataSeries);
                        break;
                    }
                    case 1: {
                        if (AbstractTimePlotCustomImpl.this.getMaximumHistorySize() > 0 && currentDataSeries.size() > AbstractTimePlotCustomImpl.this.getMaximumHistorySize()) {
                            result = new TreeMap<CDateTime, Double>();
                            Iterator<CDateTime> it = currentDataSeries.keySet().iterator();
                            boolean sample = true;
                            while (it.hasNext()) {
                                CDateTime time = it.next();
                                if (sample) {
                                    result.put(time, (Double)currentDataSeries.get(time));
                                }
                                boolean bl = sample = !sample;
                            }
                            break;
                        }
                        result = currentDataSeries;
                        break;
                    }
                    default: {
                        result = super.manageHistorySize(currentDataSeries);
                    }
                }
                return result;
            }
        };
    }

    protected void clearPlot() {
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            ArrayList<Date> dates = new ArrayList<Date>();
            dates.add(new Date());
            ArrayList<Double> yValues = new ArrayList<Double>();
            yValues.add(new Double(0.0));
            this.valueVsTimeBIRTChartComposite.updateValues(dates, yValues);
        }
        this.timeValueSeries.clear();
    }

    protected Adapter getValueSourceAdapter() {
        if (this.valueSourceAdapter == null) {
            this.valueSourceAdapter = new AdapterImpl(){
                private Date previousDataDate;
                private Object previousValue;

                public void notifyChanged(Notification msg) {
                    long now = System.currentTimeMillis();
                    int featureID = msg.getFeatureID(ValueSource.class);
                    switch (featureID) {
                        case 2: {
                            if (AbstractTimePlotCustomImpl.this.getMinimumTimeBetweenSample() > 0.0f && (double)(now - AbstractTimePlotCustomImpl.this.lastSampleTime) * 0.001 < (double)AbstractTimePlotCustomImpl.this.getMinimumTimeBetweenSample()) {
                                return;
                            }
                            AbstractTimePlotCustomImpl.this.lastSampleTime = now;
                            Date newValueDate = new Date(now);
                            Object newValue = msg.getNewValue();
                            AbstractTimePlotCustomImpl.this.processNewData(this.previousDataDate, this.previousValue, newValueDate, newValue);
                            this.previousDataDate = newValueDate;
                            this.previousValue = newValue;
                            break;
                        }
                    }
                }
            };
        }
        return this.valueSourceAdapter;
    }

    protected void processNewData(Date previousDataDate, Object previousValue, Date newValueDate, Object newValue) {
        boolean valueAdded = false;
        double doubleValue = 0.0;
        if (newValue instanceof Number) {
            Number number = (Number)newValue;
            doubleValue = number.doubleValue();
            valueAdded = true;
        } else if (newValue instanceof Boolean) {
            Boolean bool = (Boolean)newValue;
            doubleValue = bool != false ? 1.0 : 0.0;
            valueAdded = true;
        } else if (newValue instanceof Enumerator) {
            Enumerator enumerator = (Enumerator)newValue;
            doubleValue = enumerator.getValue();
            valueAdded = true;
        }
        if (valueAdded) {
            this.addData(newValueDate, doubleValue);
            this.updateChart();
        }
    }

    protected synchronized void updateChart() {
        if (this.valueVsTimeBIRTChartComposite != null && !this.valueVsTimeBIRTChartComposite.isDisposed()) {
            this.valueVsTimeBIRTChartComposite.updateValues(this.timeValueSeries.getTimes(), this.timeValueSeries.getValues());
        }
    }

    protected void addData(Date date, double value) {
        int entriesToRemove;
        this.timeValueSeries.addTimeValue(date, value);
        if (this.getMaximumHistoryTimeLength() > 0.0f) {
            while (this.getHistoryTimeSpan() > this.getMaximumHistoryTimeLength()) {
                this.timeValueSeries.removeOldestEntry(1);
            }
        }
        if (this.getMaximumHistorySize() > 0 && (entriesToRemove = this.timeValueSeries.size() - this.getMaximumHistorySize()) > 0) {
            this.timeValueSeries.removeOldestEntry(entriesToRemove);
        }
    }

    protected float getHistoryTimeSpan() {
        List<Date> dates = this.timeValueSeries.getTimes();
        if (dates.size() >= 2) {
            Date start = dates.get(0);
            Date end = dates.get(dates.size() - 1);
            float length = (float)(end.getTime() - start.getTime()) * 0.001f;
            return length;
        }
        return 0.0f;
    }
}

