/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.composites;

import java.util.List;
import org.eclipse.apogy.addons.monitoring.Alarm;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringFacade;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringFactory;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.ApogyNotifier;
import org.eclipse.apogy.addons.monitoring.NotifierList;
import org.eclipse.apogy.addons.monitoring.ui.wizards.ValueSourceSelectionWizard;
import org.eclipse.apogy.addons.ui.AbstractToolEClassSettings;
import org.eclipse.apogy.addons.ui.ApogyAddonsUIFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifiersComposite<RootEObject extends EObject, ResolvedEObject extends NotifierList, ItemObject extends ApogyNotifier>
extends EMFFormsEListComposite<RootEObject, ResolvedEObject, ItemObject> {
    private static final Logger Logger = LoggerFactory.getLogger(NotifiersComposite.class);
    private Adapter notifierAdapter;
    private Adapter notifierListAdapter;
    private NotifierList previousNotifierList;
    private ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);

    public NotifiersComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.NOTIFIER_LIST__NOTIFIERS, settings);
    }

    public NotifiersComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, style);
        this.createDeleteButton(parent, style);
        this.createSeparator(parent, style);
        Button activateButton = this.createActivateButton(parent, style);
        activateButton.setText("Enable");
        Button disableButton = this.createDeActivateButton(parent, style);
        disableButton.setText("Disable");
        this.createSeparator(parent, style);
        this.createChangeValueSourceButton(parent, style);
    }

    protected Button createEditConditionButton(Composite parent, int style) {
        Button button = NotifiersComposite.createButton((Composite)parent, (int)0, (String)"Edit Value Source", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doEditCondition((Alarm)this.getViewer().getStructuredSelection().getFirstElement());
            this.refreshViewer();
        }));
        this.createEditConditionButtonBindings(button);
        return button;
    }

    protected void createEditConditionButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected void doEditCondition(Alarm alarm) {
        EObjectWizard wizard = new EObjectWizard((EObject)alarm, null, ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__VALUE_SOURCE, ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE, null);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        this.refreshViewer();
    }

    protected void doNew() {
        NotifierList notifierList = ApogyAddonsMonitoringFacade.INSTANCE.getNotifierList();
        if (notifierList == null) {
            notifierList = ApogyAddonsMonitoringFactory.eINSTANCE.createNotifierList();
            InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)invocatorSession.getToolsList(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.TOOLS_LIST__TOOLS_LIST_CONTAINERS, (Object)notifierList, true);
            this.refreshViewer();
        }
        AbstractToolEClassSettings settings = ApogyAddonsUIFactory.eINSTANCE.createAbstractToolEClassSettings();
        settings.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)notifierList, null, (ETypedElement)ApogyAddonsMonitoringPackage.Literals.NOTIFIER_LIST__NOTIFIERS));
        EObjectWizard wizard = new EObjectWizard((EObject)notifierList, null, ApogyAddonsMonitoringPackage.Literals.NOTIFIER_LIST__NOTIFIERS, ApogyAddonsMonitoringPackage.Literals.ALARM, (EClassSettings)settings);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
        if (wizard.getCreatedEObject() instanceof Alarm) {
            ApogyNotifier notifier = (ApogyNotifier)wizard.getCreatedEObject();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)notifier, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__ENABLED, (Object)true, true);
            this.refreshViewer();
            this.getViewer().setSelection((ISelection)new StructuredSelection((Object)notifier), true);
        }
        this.refreshViewer();
    }

    protected void doDelete(ApogyNotifier notifier) {
        try {
            ApogyAddonsMonitoringFacade.INSTANCE.removeFromList(ApogyAddonsMonitoringFacade.INSTANCE.getNotifierList(), notifier);
            if (this.getViewer().getTree().getItemCount() > 0) {
                Object obj = this.getViewer().getTree().getItem(0).getData();
                this.getViewer().setSelection((ISelection)new StructuredSelection(obj), true);
                this.selectionChanged((IStructuredSelection)new StructuredSelection(obj));
            } else {
                this.selectionChanged((IStructuredSelection)new StructuredSelection());
            }
            this.refreshViewer();
            Logger.info("Deleted notifier <" + notifier.getName() + ">.");
        }
        catch (Exception e) {
            Logger.error("Failed to delete notifier !", (Throwable)e);
        }
    }

    public void setRootEObject(RootEObject rootEObject) {
        super.setRootEObject(rootEObject);
        NotifierList notifierList = null;
        if (this.getResolvedEObject() instanceof NotifierList) {
            notifierList = (NotifierList)this.getResolvedEObject();
        }
        if (rootEObject instanceof NotifierList) {
            notifierList = (NotifierList)rootEObject;
        }
        if (notifierList != this.previousNotifierList) {
            if (this.previousNotifierList != null) {
                this.previousNotifierList.eAdapters().remove((Object)this.getNotifierListAdapter());
                for (ApogyNotifier notifier : this.previousNotifierList.getNotifiers()) {
                    notifier.eAdapters().remove((Object)this.getNotifierAdapter());
                }
            }
            if (notifierList != null) {
                notifierList.eAdapters().add((Object)this.getNotifierListAdapter());
                for (ApogyNotifier notifier : notifierList.getNotifiers()) {
                    notifier.eAdapters().add((Object)this.getNotifierAdapter());
                }
            }
            this.previousNotifierList = notifierList;
        }
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ApogyNotifier) {
                    ApogyNotifier notifier = (ApogyNotifier)element;
                    return notifier.getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                if (element instanceof ApogyNotifier) {
                    ApogyNotifier notifier = (ApogyNotifier)element;
                    return notifier.getDescription();
                }
                return "";
            }

            public Color getBackground(Object element) {
                if (element instanceof ApogyNotifier) {
                    return NotifiersComposite.this.getApogyNotifierBackground((ApogyNotifier)element);
                }
                return null;
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn valueSourceColumn = new TreeViewerColumn(viewer, 0);
        valueSourceColumn.getColumn().setText("Value Source");
        valueSourceColumn.getColumn().setAlignment(0x1000000);
        valueSourceColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ApogyNotifier notifier;
                if (element instanceof ApogyNotifier && (notifier = (ApogyNotifier)element).getValueSource() != null) {
                    return notifier.getValueSource().getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                ApogyNotifier notifier;
                if (element instanceof ApogyNotifier && (notifier = (ApogyNotifier)element).getValueSource() != null) {
                    return notifier.getValueSource().getDescription();
                }
                return "";
            }

            public Image getImage(Object element) {
                ApogyNotifier notifier;
                if (element instanceof ApogyNotifier && (notifier = (ApogyNotifier)element).getValueSource() != null) {
                    return NotifiersComposite.this.labelProvider.getImage((Object)notifier.getValueSource());
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof ApogyNotifier) {
                    return NotifiersComposite.this.getApogyNotifierBackground((ApogyNotifier)element);
                }
                return null;
            }
        });
        valueSourceColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn enableColumn = new TreeViewerColumn(viewer, 0);
        enableColumn.getColumn().setText("Enabled");
        enableColumn.getColumn().setAlignment(0x1000000);
        enableColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ApogyNotifier) {
                    ApogyNotifier notifier = (ApogyNotifier)element;
                    return Boolean.toString(notifier.isEnabled());
                }
                return "?";
            }

            public Color getBackground(Object element) {
                if (element instanceof ApogyNotifier) {
                    return NotifiersComposite.this.getApogyNotifierBackground((ApogyNotifier)element);
                }
                return null;
            }
        });
        enableColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)75);
        TreeViewerColumn triggerColumn = new TreeViewerColumn(viewer, 0);
        triggerColumn.getColumn().setText("Triggered");
        triggerColumn.getColumn().setAlignment(0x1000000);
        triggerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ApogyNotifier) {
                    ApogyNotifier notifier = (ApogyNotifier)element;
                    return Boolean.toString(notifier.isTriggered());
                }
                return "?";
            }

            public Color getBackground(Object element) {
                if (element instanceof ApogyNotifier) {
                    return NotifiersComposite.this.getApogyNotifierBackground((ApogyNotifier)element);
                }
                return null;
            }
        });
        triggerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)80);
    }

    protected void doActivate(List<ItemObject> list) {
        for (ApogyNotifier notifier : list) {
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)notifier, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__ENABLED, (Object)true, true);
            }
            catch (Exception e) {
                Logger.error("Failed to enable notifier <" + notifier + ">!", (Throwable)e);
            }
        }
    }

    protected void createActivateButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o instanceof ApogyNotifier) {
                return !((ApogyNotifier)o).isEnabled();
            }
            return false;
        });
    }

    protected Button createDeActivateButton(Composite parent, int style) {
        Button btnDeActivate = NotifiersComposite.createButton((Composite)parent, (int)0, (String)"De-Activate", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.doDeActivate(this.getViewer().getStructuredSelection().toList());
            this.refreshViewer();
        }));
        this.createDeActivateButtonBindings(btnDeActivate);
        return btnDeActivate;
    }

    protected void createDeActivateButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o instanceof ApogyNotifier) {
                return ((ApogyNotifier)o).isEnabled();
            }
            return false;
        });
    }

    protected void doDeActivate(List<ItemObject> list) {
        for (ApogyNotifier notifier : list) {
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)notifier, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__ENABLED, (Object)false, true);
            }
            catch (Exception e) {
                Logger.error("Failed to disable notifier <" + notifier + ">!", (Throwable)e);
            }
        }
    }

    protected Button createChangeValueSourceButton(Composite parent, int style) {
        Button btnChangeValueSource = NotifiersComposite.createButton((Composite)parent, (int)0, (String)"Change Value Source", e -> BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
            this.changeValueSource(this.getViewer().getStructuredSelection().toList());
            this.refreshViewer();
        }));
        this.createChangeValueSourceButtonBindings(btnChangeValueSource);
        return btnChangeValueSource;
    }

    protected void createChangeValueSourceButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (o != null) {
                return true;
            }
            return false;
        });
    }

    protected Color getApogyNotifierBackground(ApogyNotifier notifier) {
        return null;
    }

    protected void changeValueSource(List<ItemObject> list) {
        if (list.size() > 0) {
            final ApogyNotifier notifier = (ApogyNotifier)list.get(0);
            ValueSourceSelectionWizard wizard = new ValueSourceSelectionWizard((EObject)notifier, null, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__VALUE_SOURCE, null){

                @Override
                public boolean performFinish() {
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)notifier, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__VALUE_SOURCE, this.getSelectedValueSource());
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
            this.refreshViewer();
            notifier.forceRefresh();
        }
    }

    private Adapter getNotifierAdapter() {
        if (this.notifierAdapter == null) {
            this.notifierAdapter = new EContentAdapter(){

                public void notifyChanged(final Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getNotifier() instanceof ApogyNotifier) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!NotifiersComposite.this.isDisposed()) {
                                    NotifiersComposite.this.getViewer().refresh(msg.getNotifier(), true);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.notifierAdapter;
    }

    private Adapter getNotifierListAdapter() {
        if (this.notifierListAdapter == null) {
            this.notifierListAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof NotifierList && (featureID = msg.getFeatureID(NotifierList.class)) == 1) {
                        switch (msg.getEventType()) {
                            case 3: {
                                ApogyNotifier notifier = (ApogyNotifier)msg.getNewValue();
                                notifier.eAdapters().add((Object)NotifiersComposite.this.getNotifierAdapter());
                                break;
                            }
                            case 5: {
                                List notifiers = (List)msg.getNewValue();
                                for (ApogyNotifier notifier : notifiers) {
                                    notifier.eAdapters().add((Object)NotifiersComposite.this.getNotifierAdapter());
                                }
                                break;
                            }
                            case 4: {
                                ApogyNotifier notifier = (ApogyNotifier)msg.getOldValue();
                                notifier.eAdapters().remove((Object)NotifiersComposite.this.getNotifierAdapter());
                                break;
                            }
                            case 6: {
                                List notifiers = (List)msg.getOldValue();
                                for (ApogyNotifier notifier : notifiers) {
                                    notifier.eAdapters().remove((Object)NotifiersComposite.this.getNotifierAdapter());
                                }
                                break;
                            }
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!NotifiersComposite.this.isDisposed()) {
                                    NotifiersComposite.this.getViewer().refresh();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.notifierListAdapter;
    }
}

