/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring.ui.views;

import javax.annotation.PostConstruct;
import org.eclipse.apogy.addons.monitoring.ui.ApogyAddonsMonitoringUIFacade;
import org.eclipse.apogy.addons.monitoring.ui.composites.ValueSourceDisplayOutputComposite;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionPart;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSourceDisplayOutputPart
extends AbstractSessionPart<ApogyAddonsMonitoringUIFacade> {
    public static final String NUMBER_OF_COLUMNS_ID = "NumberOfColumns";
    private static final Logger Logger = LoggerFactory.getLogger(ValueSourceDisplayOutputPart.class);
    private ValueSourceDisplayOutputComposite valueSourceDisplayOutputComposite;

    public void setNumberOfColumns(int numberOfColumns) {
        if (this.valueSourceDisplayOutputComposite != null && !this.valueSourceDisplayOutputComposite.isDisposed()) {
            this.valueSourceDisplayOutputComposite.setNumberOfColumns(numberOfColumns);
        }
    }

    protected void createComposite(Composite parent, int style) {
        this.valueSourceDisplayOutputComposite = new ValueSourceDisplayOutputComposite(parent, style, null);
        this.valueSourceDisplayOutputComposite.setRootEObject(ApogyAddonsMonitoringUIFacade.INSTANCE.getValueSourceDisplayList());
    }

    protected void doSetContent(ApogyAddonsMonitoringUIFacade rootEObject) {
        if (this.valueSourceDisplayOutputComposite != null && !this.valueSourceDisplayOutputComposite.isDisposed()) {
            this.valueSourceDisplayOutputComposite.setRootEObject(rootEObject.getValueSourceDisplayList());
        }
    }

    protected void sessionChanged(InvocatorSession invocatorSession) {
        this.setContent(ApogyAddonsMonitoringUIFacade.INSTANCE);
    }

    @PostConstruct
    public void postConstruct() {
        try {
            this.setContent(ApogyAddonsMonitoringUIFacade.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PersistState
    public void userPersistState(MPart mPart) {
        try {
            int numberOfColumns = 1;
            if (this.valueSourceDisplayOutputComposite != null && !this.valueSourceDisplayOutputComposite.isDisposed()) {
                numberOfColumns = this.valueSourceDisplayOutputComposite.getNumberOfColumns();
            }
            mPart.getPersistedState().put(NUMBER_OF_COLUMNS_ID, Integer.toString(numberOfColumns));
            Logger.info("Saved Displays Configuration number of columns <" + numberOfColumns + ">.");
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    @PostConstruct
    public void userPostConstruct(MPart mPart) {
        if (this.valueSourceDisplayOutputComposite != null && !this.valueSourceDisplayOutputComposite.isDisposed()) {
            try {
                String value = (String)mPart.getPersistedState().get(NUMBER_OF_COLUMNS_ID);
                if (value != null) {
                    int numberOfColumns = Integer.parseInt((String)mPart.getPersistedState().get(NUMBER_OF_COLUMNS_ID));
                    this.valueSourceDisplayOutputComposite.setNumberOfColumns(numberOfColumns);
                    Logger.info("Restored Displays Configuration number of columns <" + numberOfColumns + ">.");
                } else {
                    Logger.warn("Could not restored Displays Configuration number of columns.");
                }
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

