/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import javax.measure.unit.Unit;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.impl.AbstractFeatureBasedValueSourceImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractFeatureBasedValueSourceCustomImpl<T>
extends AbstractFeatureBasedValueSourceImpl<T> {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractFeatureBasedValueSourceCustomImpl.class);
    private Adapter eObjectAdapter;
    private Adapter displayUnitRegisteryAdapter;

    @Override
    public void initialise() {
        this.updateUnits();
        if (!ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnitsRegistry().eAdapters().contains((Object)this.getDisplayUnitRegisteryAdapter())) {
            ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnitsRegistry().eAdapters().add((Object)this.getDisplayUnitRegisteryAdapter());
        }
        if (this.getEObject() != null && !this.getEObject().eAdapters().contains((Object)this.getEObjectAdapter())) {
            this.getEObject().eAdapters().add((Object)this.getEObjectAdapter());
        }
    }

    @Override
    public void dispose() {
        ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnitsRegistry().eAdapters().remove((Object)this.getDisplayUnitRegisteryAdapter());
        if (this.getEObject() != null) {
            this.getEObject().eAdapters().remove((Object)this.getEObjectAdapter());
        }
    }

    @Override
    public void setEObject(EObject newEObject) {
        EObject previousEObject = this.getEObject();
        if (previousEObject != null) {
            previousEObject.eAdapters().remove((Object)this.getEObjectAdapter());
        }
        super.setEObject(newEObject);
        if (newEObject != null && !newEObject.eAdapters().contains((Object)this.getEObjectAdapter())) {
            newEObject.eAdapters().add((Object)this.getEObjectAdapter());
            T currentValue = this.resolveValueSourceCurrentValue();
            this.valueChanged(null, currentValue);
        }
    }

    @Override
    public void setFeature(EStructuralFeature newFeature) {
        super.setFeature(newFeature);
        this.updateUnits();
        T currentValue = this.resolveValueSourceCurrentValue();
        this.valueChanged(null, currentValue);
    }

    protected void updateUnits() {
        Unit nativeUnits = null;
        Unit displayUnits = null;
        if (this.getFeature() != null) {
            nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getFeature());
            displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.getFeature());
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE__NATIVE_UNIT, (Object)nativeUnits, true);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE__DISPLAY_UNIT, (Object)displayUnits, true);
    }

    protected T resolveValueSourceCurrentValue() {
        Object value = null;
        if (this.getEObject() != null && this.getEObject().eClass().getEAllStructuralFeatures().contains((Object)this.getFeature())) {
            try {
                value = this.getEObject().eGet(this.getFeature(), true);
            }
            catch (Exception e) {
                Logger.error("The feature <" + this.getFeature().getName() + "> is incompatible with the value source type.", (Throwable)e);
            }
        }
        return (T)value;
    }

    private Adapter getEObjectAdapter() {
        if (this.eObjectAdapter == null) {
            this.eObjectAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeature() == AbstractFeatureBasedValueSourceCustomImpl.this.getFeature()) {
                        Object oldValue = notification.getOldValue();
                        Object newValue = notification.getNewValue();
                        Object previous = null;
                        Object current = null;
                        try {
                            previous = oldValue;
                        }
                        catch (Exception exception) {}
                        try {
                            current = newValue;
                        }
                        catch (Exception exception) {}
                        try {
                            AbstractFeatureBasedValueSourceCustomImpl.this.valueChanged(previous, current);
                        }
                        catch (Exception e) {
                            Logger.error("Error during value source <" + AbstractFeatureBasedValueSourceCustomImpl.this.getName() + "> update !", (Throwable)e);
                        }
                    }
                }
            };
        }
        return this.eObjectAdapter;
    }

    private Adapter getDisplayUnitRegisteryAdapter() {
        if (this.displayUnitRegisteryAdapter == null) {
            this.displayUnitRegisteryAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    AbstractFeatureBasedValueSourceCustomImpl.this.updateUnits();
                }
            };
        }
        return this.displayUnitRegisteryAdapter;
    }
}

