/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import java.util.Iterator;
import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.NotificationCondition;
import org.eclipse.apogy.addons.monitoring.NotificationConditionLogicalOperation;
import org.eclipse.apogy.addons.monitoring.impl.AlarmImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AlarmCustomImpl
extends AlarmImpl {
    private boolean previousConditionFullfilled = false;

    @Override
    public void ack() {
        this.deactivateEffects();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.ALARM__ACKNOWLEDGED, (Object)true, true);
    }

    @Override
    public void setTriggered(boolean newTriggered) {
        boolean previousTrigger = this.isTriggered();
        super.setTriggered(newTriggered);
        if (!previousTrigger && newTriggered) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.ALARM__ACKNOWLEDGED, (Object)false, true);
        }
    }

    @Override
    public void setTriggerOnConditionPositiveGoingEdgeOnly(boolean newTriggerOnConditionPositiveGoingEdgeOnly) {
        super.setTriggerOnConditionPositiveGoingEdgeOnly(true);
    }

    @Override
    public boolean isTriggerOnConditionPositiveGoingEdgeOnly() {
        return true;
    }

    @Override
    protected void processNewValue(Object newValue) {
        if (this.isEnabled()) {
            boolean conditionFullfilled = false;
            if (this.getConditions().size() > 0) {
                if (this.getConditionLogicalOperator() == NotificationConditionLogicalOperation.OR) {
                    Iterator it = this.getConditions().iterator();
                    while (!conditionFullfilled && it.hasNext()) {
                        NotificationCondition condition = (NotificationCondition)it.next();
                        try {
                            boolean conditionValid = condition.evaluate(newValue);
                            if (!conditionValid) continue;
                            conditionFullfilled = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (this.getConditionLogicalOperator() == NotificationConditionLogicalOperation.AND) {
                    conditionFullfilled = true;
                    Iterator it = this.getConditions().iterator();
                    while (conditionFullfilled && it.hasNext()) {
                        NotificationCondition condition = (NotificationCondition)it.next();
                        try {
                            conditionFullfilled = condition.evaluate(newValue);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                conditionFullfilled = true;
            }
            if (this.isTriggerOnConditionPositiveGoingEdgeOnly()) {
                if (!this.previousConditionFullfilled && conditionFullfilled) {
                    this.activateEffects(newValue);
                }
                this.previousConditionFullfilled = conditionFullfilled;
            } else if (conditionFullfilled) {
                this.activateEffects(newValue);
            } else {
                this.deactivateEffects();
            }
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.APOGY_NOTIFIER__TRIGGERED, (Object)conditionFullfilled, true);
        }
    }
}

