/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import org.eclipse.apogy.addons.monitoring.ApogyAddonsMonitoringPackage;
import org.eclipse.apogy.addons.monitoring.impl.TimerValueSourceImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TimerValueSourceCustomImpl
extends TimerValueSourceImpl {
    private Job job = null;
    private long currentTime = 0L;

    @Override
    public void initialise() {
        super.initialise();
        this.currentTime = this.getDuration();
        this.getJob().cancel();
        this.getJob().schedule();
    }

    @Override
    public void dispose() {
        this.getJob().cancel();
        this.job = null;
        super.dispose();
    }

    @Override
    public void setDuration(long newDuration) {
        if (newDuration >= 0L) {
            super.setDuration(newDuration);
            this.initialise();
        }
    }

    @Override
    public void setUpdatePeriod(long newUpdatePeriod) {
        if (newUpdatePeriod >= 0L) {
            super.setUpdatePeriod(newUpdatePeriod);
        }
    }

    @Override
    public void setLoop(boolean newLoop) {
        super.setLoop(newLoop);
        if (newLoop) {
            this.initialise();
        }
    }

    @Override
    public void resetTimer() {
        this.initialise();
    }

    @Override
    public EObject getEObject() {
        return this;
    }

    @Override
    public EStructuralFeature getFeature() {
        return ApogyAddonsMonitoringPackage.Literals.TIMER_VALUE_SOURCE__CURRENT_TIMER_VALUE;
    }

    @Override
    public void valueChanged(Long oldValue, Long newValue) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.VALUE_SOURCE__CURRENT_VALUE, (Object)new Long(newValue), true);
    }

    private Job getJob() {
        if (this.job == null) {
            this.job = new Job("Timer Value Source"){

                protected IStatus run(IProgressMonitor arg0) {
                    long startTime = System.currentTimeMillis();
                    TimerValueSourceCustomImpl.this.currentTime = TimerValueSourceCustomImpl.this.getDuration();
                    while (TimerValueSourceCustomImpl.this.currentTime > 0L) {
                        long now = System.currentTimeMillis();
                        long delta = now - startTime;
                        TimerValueSourceCustomImpl timerValueSourceCustomImpl = TimerValueSourceCustomImpl.this;
                        timerValueSourceCustomImpl.currentTime = timerValueSourceCustomImpl.currentTime - delta;
                        try {
                            if (TimerValueSourceCustomImpl.this.currentTime < 0L) {
                                TimerValueSourceCustomImpl.this.currentTime = 0L;
                            }
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TimerValueSourceCustomImpl.this, (EStructuralFeature)ApogyAddonsMonitoringPackage.Literals.TIMER_VALUE_SOURCE__CURRENT_TIMER_VALUE, (Object)new Long(TimerValueSourceCustomImpl.this.currentTime), true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (TimerValueSourceCustomImpl.this.currentTime <= 0L && TimerValueSourceCustomImpl.this.isLoop()) {
                            startTime = System.currentTimeMillis();
                            TimerValueSourceCustomImpl.this.currentTime = TimerValueSourceCustomImpl.this.getDuration();
                        }
                        startTime = now;
                        try {
                            Thread.sleep(TimerValueSourceCustomImpl.this.getUpdatePeriod());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.job;
    }
}

