/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ros.ui.composites;

import java.util.List;
import org.eclipse.apogy.addons.mqtt.ros.ApogyAddonsMQTTROSPackage;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSArbitratorServer;
import org.eclipse.apogy.addons.mqtt.ros.MQTTROSServiceCall;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class MQTTROSArbitratorServerCallListComposite
extends EMFFormsEListComposite<MQTTROSArbitratorServer, MQTTROSArbitratorServer, MQTTROSServiceCall> {
    private Adapter adapter;

    public MQTTROSArbitratorServerCallListComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMQTTROSPackage.Literals.MQTTROS_ARBITRATOR_SERVER__CALLS, settings);
    }

    public void setRootEObject(MQTTROSArbitratorServer rootEObject) {
        MQTTROSArbitratorServer oldServer = (MQTTROSArbitratorServer)this.getRootEObject();
        super.setRootEObject((EObject)rootEObject);
        this.registerAdapter(oldServer, rootEObject);
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return this.getEStructuralFeature();
            }

            public Object[] getElements(Object object) {
                if (object instanceof MQTTROSArbitratorServer) {
                    MQTTROSArbitratorServer server = (MQTTROSArbitratorServer)object;
                    return server.getCalls().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object object) {
                return new Object[0];
            }
        };
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn clientIDColumn = new TreeViewerColumn(viewer, 0);
        clientIDColumn.getColumn().setText("Client");
        clientIDColumn.getColumn().setAlignment(0x1000000);
        clientIDColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MQTTROSServiceCall serviceCall;
                if (element instanceof MQTTROSServiceCall && (serviceCall = (MQTTROSServiceCall)element).getUserID() != null) {
                    return serviceCall.getUserID();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }
        });
        clientIDColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        TreeViewerColumn timeColumn = new TreeViewerColumn(viewer, 0);
        timeColumn.getColumn().setText("Time");
        timeColumn.getColumn().setAlignment(0x1000000);
        timeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MQTTROSServiceCall serviceCall;
                if (element instanceof MQTTROSServiceCall && (serviceCall = (MQTTROSServiceCall)element).getTime() != null) {
                    return ApogyCommonEMFFacade.INSTANCE.format(serviceCall.getTime());
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return this.getText(element);
            }
        });
        timeColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn serviceNameColumn = new TreeViewerColumn(viewer, 0);
        serviceNameColumn.getColumn().setText("Service");
        serviceNameColumn.getColumn().setAlignment(0x1000000);
        serviceNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MQTTROSServiceCall serviceCall;
                if (element instanceof MQTTROSServiceCall && (serviceCall = (MQTTROSServiceCall)element).getServiceName() != null) {
                    return serviceCall.getServiceName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                MQTTROSServiceCall serviceCall;
                if (element instanceof MQTTROSServiceCall && (serviceCall = (MQTTROSServiceCall)element).getServiceName() != null) {
                    return serviceCall.getServiceName();
                }
                return "?";
            }
        });
        serviceNameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)500);
        TreeViewerColumn successColumn = new TreeViewerColumn(viewer, 0);
        successColumn.getColumn().setText("Status");
        successColumn.getColumn().setAlignment(0x1000000);
        successColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTROSServiceCall) {
                    MQTTROSServiceCall serviceCall = (MQTTROSServiceCall)element;
                    if (serviceCall.getResponse() != null) {
                        if (serviceCall.getResponse().getException() != null) {
                            return "Failed ! " + serviceCall.getResponse().getException().getMessage();
                        }
                        return "Completed.";
                    }
                    return "In Progress...";
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                if (element instanceof MQTTROSServiceCall) {
                    MQTTROSServiceCall serviceCall = (MQTTROSServiceCall)element;
                    if (serviceCall.getResponse() != null) {
                        if (serviceCall.getResponse().getException() != null) {
                            return "Failed ! " + serviceCall.getResponse().getException().getMessage();
                        }
                        return "Completed.";
                    }
                    return "In Progress...";
                }
                return "?";
            }

            public Color getBackground(Object element) {
                if (element instanceof MQTTROSServiceCall) {
                    MQTTROSServiceCall serviceCall = (MQTTROSServiceCall)element;
                    if (serviceCall.getResponse() != null) {
                        if (serviceCall.getResponse().getException() != null) {
                            return PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
                        }
                        return PlatformUI.getWorkbench().getDisplay().getSystemColor(5);
                    }
                    return PlatformUI.getWorkbench().getDisplay().getSystemColor(7);
                }
                return super.getBackground(element);
            }
        });
        successColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
    }

    private void registerAdapter(MQTTROSArbitratorServer oldServer, MQTTROSArbitratorServer newServer) {
        if (oldServer != null) {
            oldServer.eAdapters().add((Object)this.getAdapter());
            for (MQTTROSServiceCall call : oldServer.getCalls()) {
                call.eAdapters().remove((Object)this.getAdapter());
            }
        }
        if (newServer != null) {
            newServer.eAdapters().add((Object)this.getAdapter());
            for (MQTTROSServiceCall call : newServer.getCalls()) {
                call.eAdapters().add((Object)this.getAdapter());
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof MQTTROSArbitratorServer) {
                        if (msg.getFeatureID(MQTTROSArbitratorServer.class) == 8) {
                            switch (msg.getEventType()) {
                                case 3: {
                                    MQTTROSServiceCall call = (MQTTROSServiceCall)msg.getNewValue();
                                    call.eAdapters().add((Object)this);
                                    break;
                                }
                                case 5: {
                                    List calls = (List)msg.getNewValue();
                                    for (MQTTROSServiceCall call : calls) {
                                        call.eAdapters().add((Object)this);
                                    }
                                    break;
                                }
                                case 4: {
                                    MQTTROSServiceCall call = (MQTTROSServiceCall)msg.getOldValue();
                                    call.eAdapters().remove((Object)this);
                                    break;
                                }
                                case 6: {
                                    List calls = (List)msg.getOldValue();
                                    for (MQTTROSServiceCall call : calls) {
                                        call.eAdapters().remove((Object)this);
                                    }
                                    break;
                                }
                            }
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!MQTTROSArbitratorServerCallListComposite.this.isDisposed() && MQTTROSArbitratorServerCallListComposite.this.getViewer() != null) {
                                        MQTTROSArbitratorServerCallListComposite.this.getViewer().refresh();
                                    }
                                }
                            });
                        }
                    } else if (msg.getNotifier() instanceof MQTTROSServiceCall) {
                        final MQTTROSServiceCall call = (MQTTROSServiceCall)msg.getNotifier();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!MQTTROSArbitratorServerCallListComposite.this.isDisposed() && MQTTROSArbitratorServerCallListComposite.this.getViewer() != null) {
                                    MQTTROSArbitratorServerCallListComposite.this.getViewer().refresh((Object)call, true);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.adapter;
    }
}

