/*
 * Decompiled with CFR 0.152.
 */
package shape_msgs;

import geometry_msgs.Point;
import geometry_msgs.PointMQTT;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ros.internal.message.RawMessage;
import shape_msgs.Mesh;
import shape_msgs.MeshTriangle;
import shape_msgs.MeshTriangleMQTT;

public class MeshMQTT
implements Mesh {
    private List<Point> vertices = new ArrayList<Point>();
    private List<MeshTriangle> triangles = new ArrayList<MeshTriangle>();

    public MeshMQTT() {
    }

    public MeshMQTT(String jsonString) throws Exception {
        this.parseJSONString(jsonString);
    }

    public RawMessage toRawMessage() {
        return null;
    }

    public List<MeshTriangle> getTriangles() {
        return this.triangles;
    }

    public void setTriangles(List<MeshTriangle> value) {
        this.triangles.clear();
        this.triangles.addAll(value);
    }

    public List<Point> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<Point> value) {
        this.vertices.clear();
        this.vertices.addAll(value);
    }

    public static JSONObject toJSONObject(Mesh mesh, DecimalFormat decimalFormat) throws Exception {
        JSONObject jsonObject = new JSONObject();
        PointMQTT.setJSONOutputDecimalFormat(decimalFormat);
        ArrayList<JSONObject> vertices = new ArrayList<JSONObject>();
        for (Point point : mesh.getVertices()) {
            JSONObject object = PointMQTT.toJSONObject(point);
            vertices.add(object);
        }
        JSONArray array = new JSONArray(vertices);
        jsonObject.put("vertices", (Object)array);
        ArrayList<JSONObject> triangles = new ArrayList<JSONObject>();
        for (MeshTriangle triangle : mesh.getTriangles()) {
            JSONObject object = MeshTriangleMQTT.toJSONObject(triangle);
            triangles.add(object);
        }
        JSONArray arrayTriangles = new JSONArray(triangles);
        jsonObject.put("triangles", (Object)arrayTriangles);
        return jsonObject;
    }

    protected void parseJSONString(String jsonString) throws Exception {
        JSONObject jsonObject = new JSONObject(jsonString);
        ArrayList<PointMQTT> vertices = new ArrayList<PointMQTT>();
        JSONArray arrayVertices = jsonObject.getJSONArray("vertices");
        int i = 0;
        while (i < arrayVertices.length()) {
            JSONObject object = arrayVertices.getJSONObject(i);
            PointMQTT point = new PointMQTT(object);
            vertices.add(point);
            ++i;
        }
        this.getVertices().clear();
        this.getVertices().addAll(vertices);
        ArrayList<MeshTriangleMQTT> triangles = new ArrayList<MeshTriangleMQTT>();
        JSONArray arrayTriangles = jsonObject.getJSONArray("triangles");
        int i2 = 0;
        while (i2 < arrayTriangles.length()) {
            JSONObject object = arrayTriangles.getJSONObject(i2);
            MeshTriangleMQTT triangle = new MeshTriangleMQTT(object);
            triangles.add(triangle);
            ++i2;
        }
        this.getTriangles().clear();
        this.getTriangles().addAll(triangles);
    }
}

