/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.ui.composites;

import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTPackage;
import org.eclipse.apogy.addons.mqtt.MQTTBrokerConnectionInfo;
import org.eclipse.apogy.addons.mqtt.MQTTBrokerConnectionInfoRegistry;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.common.emf.ui.adapters.AbstractEListContentProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.EMFFormsEListComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class MQTTBrokerConnectionInfoRegistryComposite
extends EMFFormsEListComposite<MQTTBrokerConnectionInfoRegistry, MQTTBrokerConnectionInfoRegistry, MQTTBrokerConnectionInfo> {
    private Adapter adapter;
    private MQTTBrokerConnectionInfoRegistry registry;

    public MQTTBrokerConnectionInfoRegistryComposite(Composite parent, int style, ECollectionCompositeSettings settings) {
        super(parent, style, null, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_BROKER_CONNECTION_INFO_REGISTRY__BROKERS_CONNNECTION_INFO, settings);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (MQTTBrokerConnectionInfoRegistryComposite.this.registry != null) {
                    MQTTBrokerConnectionInfoRegistryComposite.this.registry.eAdapters().remove((Object)MQTTBrokerConnectionInfoRegistryComposite.this.getAdapter());
                }
            }
        });
    }

    protected void createColumns(TreeViewer viewer) {
        TreeViewerColumn nameColumn = new TreeViewerColumn(viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setAlignment(0x1000000);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTBrokerConnectionInfo) {
                    MQTTBrokerConnectionInfo topic = (MQTTBrokerConnectionInfo)element;
                    return topic.getName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return "Name of the Connection.";
            }
        });
        nameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)120);
        TreeViewerColumn userNameColumn = new TreeViewerColumn(viewer, 0);
        userNameColumn.getColumn().setText("User Name");
        userNameColumn.getColumn().setAlignment(0x1000000);
        userNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTBrokerConnectionInfo) {
                    MQTTBrokerConnectionInfo connection = (MQTTBrokerConnectionInfo)element;
                    return connection.getUserName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_BROKER_CONNECTION_INFO__USER_NAME);
            }
        });
        userNameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
        TreeViewerColumn brokerHostNameColumn = new TreeViewerColumn(viewer, 0);
        brokerHostNameColumn.getColumn().setText("Broker Host Name");
        brokerHostNameColumn.getColumn().setAlignment(0x1000000);
        brokerHostNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MQTTBrokerConnectionInfo) {
                    MQTTBrokerConnectionInfo connection = (MQTTBrokerConnectionInfo)element;
                    return connection.getBrokerHostName();
                }
                return "?";
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsMQTTPackage.Literals.MQTT_BROKER_CONNECTION_INFO__BROKER_HOST_NAME);
            }
        });
        brokerHostNameColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)200);
    }

    protected AdapterFactoryContentProvider createContentProvider(AdapterFactory adapterFactory) {
        return new AbstractEListContentProvider(adapterFactory){

            public EStructuralFeature getEStructuralFeature() {
                return MQTTBrokerConnectionInfoRegistryComposite.this.getEStructuralFeature();
            }

            public Object[] getElements(Object object) {
                if (object instanceof MQTTBrokerConnectionInfoRegistry) {
                    MQTTBrokerConnectionInfoRegistry registry = (MQTTBrokerConnectionInfoRegistry)object;
                    return registry.getBrokersConnnectionInfo().toArray();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object object) {
                return new Object[0];
            }
        };
    }

    protected void createButtons(Composite parent, int style) {
        this.createNewButton(parent, 0);
        this.createDeleteButton(parent, 0);
    }

    protected void doNew() {
        super.doNew();
        this.getViewer().refresh(true);
    }

    public void setRootEObject(MQTTBrokerConnectionInfoRegistry rootEObject) {
        super.setRootEObject((EObject)rootEObject);
        if (this.registry != null) {
            this.registry.eAdapters().remove((Object)this.getAdapter());
        }
        if (rootEObject != null) {
            rootEObject.eAdapters().add((Object)this.getAdapter());
        }
        this.registry = rootEObject;
        this.getViewer().refresh();
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(final Notification msg) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!MQTTBrokerConnectionInfoRegistryComposite.this.isDisposed() && MQTTBrokerConnectionInfoRegistryComposite.this.getViewer() != null) {
                                MQTTBrokerConnectionInfoRegistryComposite.this.getViewer().refresh(msg.getNotifier(), true);
                            }
                        }
                    });
                }
            };
        }
        return this.adapter;
    }
}

