/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum QualityOfService implements Enumerator
{
    QOS_0(0, "QOS_0", "At most once"),
    QOS_1(1, "QOS_1", "At least once"),
    QOS_2(2, "QOS_2", "Exactly once");

    public static final int QOS_0_VALUE = 0;
    public static final int QOS_1_VALUE = 1;
    public static final int QOS_2_VALUE = 2;
    private static final QualityOfService[] VALUES_ARRAY;
    public static final List<QualityOfService> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new QualityOfService[]{QOS_0, QOS_1, QOS_2};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static QualityOfService get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QualityOfService result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QualityOfService getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QualityOfService result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QualityOfService get(int value) {
        switch (value) {
            case 0: {
                return QOS_0;
            }
            case 1: {
                return QOS_1;
            }
            case 2: {
                return QOS_2;
            }
        }
        return null;
    }

    private QualityOfService(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

