/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mqtt.impl;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.addons.mqtt.ApogyAddonsMQTTPackage;
import org.eclipse.apogy.addons.mqtt.ApogyMQTTRegistry;
import org.eclipse.apogy.addons.mqtt.MQTTClientConnectionOptions;
import org.eclipse.apogy.addons.mqtt.MQTTClientState;
import org.eclipse.apogy.addons.mqtt.MQTTTopic;
import org.eclipse.apogy.addons.mqtt.MQTTTopicState;
import org.eclipse.apogy.addons.mqtt.impl.MQTTClientImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTClientCustomImpl
extends MQTTClientImpl {
    public static final long SERVER_RECONNECT_TIME_INTERVAL_MS = 1000L;
    private MqttClient client;
    private static final Logger Logger = LoggerFactory.getLogger(MQTTClientCustomImpl.class);
    private boolean started = false;
    private String clientId = null;
    private List<MQTTTopic> topicsWaitingForSubscription = new ArrayList<MQTTTopic>();
    private MqttCallback clientCallback;
    private Map<String, List<MQTTTopic>> topicNamesToMQTTTopics = new HashMap<String, List<MQTTTopic>>();
    private Map<MQTTTopic, Long> topicToUpdateTime = new HashMap<MQTTTopic, Long>();
    private Job topicStateUpdateJob = null;
    private Job reconnectToServerJob = null;

    @Override
    public synchronized void start() {
        if (!this.started) {
            try {
                if (this.isVerbose()) {
                    Logger.info("Starting MQTT client <" + this.getName() + ">...");
                }
                if (!ApogyMQTTRegistry.INSTANCE.getClientList().contains((Object)this)) {
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)ApogyMQTTRegistry.INSTANCE, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.APOGY_MQTT_REGISTRY__CLIENT_LIST, (Object)this, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.isEnableServerAutomaticReconnect()) {
                    this.started = true;
                    this.getReconnectToServerJob().schedule();
                } else {
                    this.connect();
                    this.started = true;
                }
                this.getTopicStateUpdateJob().schedule();
                if (this.isVerbose()) {
                    Logger.info("MQTT client <" + this.getName() + "> running.");
                }
            }
            catch (Exception e) {
                Logger.error(String.valueOf(this.getName()) + " - Failed to connect to broker !", (Throwable)e);
            }
        } else if (this.isVerbose()) {
            Logger.warn(String.valueOf(this.getName()) + " - MQTT Client already started !");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.client != null) {
            try {
                this.client.disconnect();
                this.client.close();
                this.client = null;
            }
            catch (MqttException e) {
                Logger.error(String.valueOf(this.getName()) + " - Error while disconnecting", (Throwable)e);
            }
        }
        for (MQTTTopic topic : this.getSubscribedTopics()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.STOPPED, true);
        }
        if (ApogyMQTTRegistry.INSTANCE.getClientList().contains((Object)this)) {
            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)ApogyMQTTRegistry.INSTANCE, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.APOGY_MQTT_REGISTRY__CLIENT_LIST, (Object)this, true);
        }
        this.topicNamesToMQTTTopics.clear();
        this.topicToUpdateTime.clear();
        this.getTopicStateUpdateJob().cancel();
        this.topicStateUpdateJob = null;
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__STATE, (Object)MQTTClientState.NOT_CONNECTED, true);
        this.started = false;
    }

    @Override
    public String getClientId() {
        if (this.clientId == null) {
            String userName = System.getProperty("user.name");
            String machineName = null;
            try {
                machineName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {}
            if (userName == null) {
                userName = "anonymous";
            }
            String prefix = userName;
            if (machineName != null) {
                prefix = String.valueOf(prefix) + "@" + machineName;
            }
            this.clientId = this.getName() != null && this.getName().length() > 0 ? String.valueOf(prefix) + "-Apogy_" + this.getName() + "_" + MqttClient.generateClientId() : String.valueOf(prefix) + "-Apogy_" + MqttClient.generateClientId();
        }
        return this.clientId;
    }

    @Override
    public synchronized void subscribe(MQTTTopic topic) {
        if (this.started) {
            if (this.client != null && this.client.isConnected()) {
                List<MQTTTopic> topics = this.topicNamesToMQTTTopics.get(topic.getTopicName());
                if (topics == null) {
                    topics = new ArrayList<MQTTTopic>();
                    topics.add(topic);
                    this.topicNamesToMQTTTopics.put(topic.getTopicName(), topics);
                    Logger.info("Client {} Subscribing to topic {}...", (Object)this.getName(), (Object)topic.getTopicName());
                    try {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.INITIALIZING, true);
                        }
                        catch (Exception exception) {}
                        this.client.subscribe(topic.getTopicName(), topic.getQualityOfService().getValue());
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.READY, true);
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception e) {
                        Logger.error(" - Failled to subscribe to topic <" + topic.getTopicName() + "> !", (Throwable)e);
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.FAILED, true);
                        }
                        catch (Exception exception) {}
                    }
                    ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)this, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__SUBSCRIBED_TOPICS, (Object)topic, true);
                } else if (topic.getCallBack() != null && !topics.contains(topic)) {
                    topics.add(topic);
                }
            }
        } else {
            this.topicsWaitingForSubscription.add(topic);
        }
    }

    @Override
    public synchronized void unsubscribe(MQTTTopic topic) {
        if (this.started && this.client != null) {
            Logger.info("Client {} Un-Subscribing from topic {}...", (Object)this.getName(), (Object)topic.getTopicName());
            List<MQTTTopic> topics = this.topicNamesToMQTTTopics.get(topic.getTopicName());
            if (topics != null && topics.size() == 1) {
                try {
                    if (this.client.isConnected()) {
                        this.client.unsubscribe(topic.getTopicName());
                    }
                }
                catch (MqttException e) {
                    e.printStackTrace();
                }
                topics.remove(topic);
            }
        }
        try {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.STOPPED, true);
        }
        catch (Exception exception) {}
        this.topicsWaitingForSubscription.remove(topic);
        ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)this, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__SUBSCRIBED_TOPICS, (Object)topic, true);
    }

    @Override
    public void publish(MQTTTopic topic, String message) throws Exception {
        if (this.started) {
            if (this.client == null) {
                throw new Exception("The client is null !");
            }
        } else {
            throw new Exception("The client is not started !");
        }
        MqttMessage mqttMessage = new MqttMessage(message.getBytes());
        this.client.publish(topic.getTopicName(), mqttMessage);
    }

    private synchronized boolean connect() throws Exception {
        try {
            this.setState(MQTTClientState.CONNECTING);
        }
        catch (Exception exception) {}
        try {
            if (this.isVerbose()) {
                Logger.info(String.valueOf(this.getName()) + " - Connecting to MQTT broker at <{}> using port <{}> with Client ID <{}>...", new Object[]{this.getBrokerHostName(), this.getPort(), this.getClientId()});
            }
            String serverURI = String.valueOf(this.getBrokerHostName()) + ":" + this.getPort();
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir != null) {
                MqttDefaultFilePersistence mqttDefaultFilePersistence = new MqttDefaultFilePersistence(tmpDir);
                this.client = new MqttClient(serverURI, this.getClientId(), (MqttClientPersistence)mqttDefaultFilePersistence);
            } else {
                MemoryPersistence memoryPersistence = new MemoryPersistence();
                this.client = new MqttClient(serverURI, this.getClientId(), (MqttClientPersistence)memoryPersistence);
            }
            if (this.getConnectionOptions() != null) {
                MQTTClientConnectionOptions opt = this.getConnectionOptions();
                MqttConnectOptions options = opt.asMqttConnectOptions();
                if (this.isVerbose()) {
                    System.out.println("Connection Options--------------------------------------------------");
                    System.out.println("MqttConnectOptions Type : " + this.getConnectionOptions().getClass().getSimpleName());
                    System.out.println("User                    : " + options.getUserName());
                    System.out.println("Password                : " + new String(options.getPassword()));
                    System.out.println("Connection Timeout      : " + options.getConnectionTimeout());
                    System.out.println("Clean Session           : " + options.isCleanSession());
                    System.out.println("Auto Reconnect          : " + options.isAutomaticReconnect());
                    System.out.println("--------------------------------------------------------------------");
                }
                this.client.connect(options);
            } else {
                this.client.connect();
            }
            this.started = true;
            try {
                this.setState(MQTTClientState.CONNECTED);
            }
            catch (Exception exception) {}
            for (MQTTTopic topic : this.topicsWaitingForSubscription) {
                try {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.INITIALIZING, true);
                }
                catch (Exception exception) {}
            }
            for (MQTTTopic topic : this.topicsWaitingForSubscription) {
                this.subscribe(topic);
            }
            this.topicsWaitingForSubscription.clear();
            for (MQTTTopic topic : this.getSubscribedTopics()) {
                this.topicToUpdateTime.put(topic, new Long(0L));
                try {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.READY, true);
                }
                catch (Exception exception) {}
            }
            this.client.setCallback(this.getClientCallback());
            if (this.isVerbose()) {
                Logger.info(String.valueOf(this.getName()) + " - Connected to MQTT broker <" + this.getBrokerHostName() + ":" + this.getPort() + ".");
            }
            return true;
        }
        catch (Exception e) {
            try {
                this.setState(MQTTClientState.FAILED);
            }
            catch (Exception exception) {}
            throw e;
        }
    }

    private void unsubscribeFromAllTopics(List<MQTTTopic> topicList) {
        for (MQTTTopic topic : topicList) {
            try {
                this.unsubscribe(topic);
            }
            catch (Exception exception) {}
        }
    }

    private void serverWasTerminated() {
        Logger.error(String.valueOf(this.getName()) + " - Server terminated!");
        if (this.isEnableServerAutomaticReconnect()) {
            for (MQTTTopic topic : this.getSubscribedTopics()) {
                try {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.INITIALIZING, true);
                }
                catch (Exception exception) {}
            }
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__STATE, (Object)MQTTClientState.CONNECTING, true);
            }
            catch (Exception exception) {}
            ArrayList<MQTTTopic> tmpList = new ArrayList<MQTTTopic>();
            tmpList.addAll((Collection<MQTTTopic>)this.getSubscribedTopics());
            this.unsubscribeFromAllTopics(tmpList);
            this.topicNamesToMQTTTopics.clear();
            this.topicsWaitingForSubscription.clear();
            this.topicsWaitingForSubscription.addAll(tmpList);
            if (this.client != null) {
                try {
                    this.client.close();
                    this.client = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.getReconnectToServerJob().schedule();
        } else {
            for (MQTTTopic topic : this.getSubscribedTopics()) {
                try {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.FAILED, true);
                }
                catch (Exception exception) {}
            }
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__STATE, (Object)MQTTClientState.FAILED, true);
            }
            catch (Exception exception) {}
        }
    }

    private MqttCallback getClientCallback() {
        if (this.clientCallback == null) {
            this.clientCallback = new MqttCallback(){

                public void messageArrived(String topicName, MqttMessage message) throws Exception {
                    List topics;
                    if (MQTTClientCustomImpl.this.getState() != MQTTClientState.CONNECTED) {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)MQTTClientCustomImpl.this, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__STATE, (Object)MQTTClientState.CONNECTED, true);
                    }
                    if ((topics = (List)MQTTClientCustomImpl.this.topicNamesToMQTTTopics.get(topicName)) != null && topics.size() > 0) {
                        for (MQTTTopic topic : topics) {
                            try {
                                MQTTClientCustomImpl.this.topicToUpdateTime.put(topic, System.currentTimeMillis());
                                MqttCallback callback = topic.getCallBack();
                                if (callback != null) {
                                    callback.messageArrived(topicName, message);
                                }
                                if (topic.getState() == MQTTTopicState.READY) continue;
                                if (MQTTClientCustomImpl.this.isVerbose()) {
                                    Logger.info(String.valueOf(MQTTClientCustomImpl.this.getName()) + " - Topic <" + topic.getTopicName() + "> is updating again.");
                                }
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.READY, true);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }

                public void deliveryComplete(IMqttDeliveryToken arg0) {
                }

                public void connectionLost(Throwable throwable) {
                    Logger.error(String.valueOf(MQTTClientCustomImpl.this.getName()) + " - Connection with MQTT broker <" + MQTTClientCustomImpl.this.getBrokerHostName() + ":" + MQTTClientCustomImpl.this.getPort() + " has been lost !");
                    for (MQTTTopic topic : MQTTClientCustomImpl.this.getSubscribedTopics()) {
                        try {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.FAILED, true);
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)MQTTClientCustomImpl.this, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_CLIENT__STATE, (Object)MQTTClientState.NOT_CONNECTED, true);
                    }
                    catch (Exception exception) {}
                    MQTTClientCustomImpl.this.serverWasTerminated();
                }
            };
        }
        return this.clientCallback;
    }

    private Job getTopicStateUpdateJob() {
        if (this.topicStateUpdateJob == null) {
            this.topicStateUpdateJob = new Job(String.valueOf(this.getName()) + " Topic State Update"){

                protected IStatus run(IProgressMonitor arg0) {
                    while (MQTTClientCustomImpl.this.started) {
                        long now = System.currentTimeMillis();
                        for (MQTTTopic topic : MQTTClientCustomImpl.this.topicToUpdateTime.keySet()) {
                            Long lastUpdateTime;
                            if (topic.getExpectedUpdatePeriod() <= 0L || now - (lastUpdateTime = (Long)MQTTClientCustomImpl.this.topicToUpdateTime.get(topic)) <= topic.getExpectedUpdatePeriod()) continue;
                            try {
                                if (topic.getState() != MQTTTopicState.READY) continue;
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)topic, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.MQTT_TOPIC__STATE, (Object)MQTTTopicState.STALLED, true);
                                if (!MQTTClientCustomImpl.this.isVerbose()) continue;
                                Logger.warn(String.valueOf(this.getName()) + " - Topic <" + topic.getTopicName() + "> has stalled !");
                            }
                            catch (Exception exception) {}
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.topicStateUpdateJob;
    }

    private Job getReconnectToServerJob() {
        if (this.reconnectToServerJob == null) {
            this.reconnectToServerJob = new Job(String.valueOf(this.getName()) + " Server Re-Connect"){

                protected IStatus run(IProgressMonitor arg0) {
                    boolean connected = false;
                    int attemptsNumber = 1;
                    while (MQTTClientCustomImpl.this.started && MQTTClientCustomImpl.this.isEnableServerAutomaticReconnect() && !connected) {
                        if (attemptsNumber > 1) {
                            Logger.warn(String.valueOf(MQTTClientCustomImpl.this.getName()) + " - Attempting to reconnect to broker for the {} time ...", (Object)attemptsNumber);
                        }
                        try {
                            connected = MQTTClientCustomImpl.this.connect();
                        }
                        catch (Exception exception) {
                            connected = false;
                        }
                        if (!connected) {
                            try {
                                MQTTClientCustomImpl.this.client.close();
                                MQTTClientCustomImpl.this.client = null;
                            }
                            catch (Exception exception) {}
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (Exception exception) {}
                            ++attemptsNumber;
                            continue;
                        }
                        if (!ApogyMQTTRegistry.INSTANCE.getClientList().contains((Object)MQTTClientCustomImpl.this)) {
                            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)ApogyMQTTRegistry.INSTANCE, (EStructuralFeature)ApogyAddonsMQTTPackage.Literals.APOGY_MQTT_REGISTRY__CLIENT_LIST, (Object)MQTTClientCustomImpl.this, true);
                        }
                        Logger.warn(String.valueOf(MQTTClientCustomImpl.this.getName()) + " - Re-connected to broker, re-subscribing to topics...", (Object)attemptsNumber);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.reconnectToServerJob;
    }
}

