/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.edit;

import java.text.DecimalFormat;
import org.eclipse.apogy.addons.powersystems.SolarCell;
import org.eclipse.apogy.addons.powersystems.provider.SolarCellItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class SolarCellCustomItemProvider
extends SolarCellItemProvider {
    private DecimalFormat decimalFormat = new DecimalFormat("0.000");
    private DecimalFormat angleFormat = new DecimalFormat("0.0");

    public SolarCellCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        SolarCell solarCell = (SolarCell)object;
        String label = solarCell.getName();
        if (label == null || label.length() == 0) {
            label = this.getString("_UI_SolarCell_type");
        }
        label = String.valueOf(label) + " (";
        if (solarCell.isShadowed()) {
            label = String.valueOf(label) + "Shadowed,";
        }
        label = String.valueOf(label) + "Sun Angle : " + this.angleFormat.format(Math.toDegrees(solarCell.getSunIncidenceAngle())) + " deg,";
        label = String.valueOf(label) + "Power : " + this.decimalFormat.format(solarCell.getPowerAvailable()) + " W, ";
        label = String.valueOf(label) + "Eff. : " + Double.toString(solarCell.getEfficiency()) + "%, ";
        label = String.valueOf(label) + "Lenght : " + Double.toString(solarCell.getLength()) + " m, ";
        label = String.valueOf(label) + "Width : " + Double.toString(solarCell.getWidth()) + " m";
        label = String.valueOf(label) + ")";
        return label;
    }
}

