/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.mqtt;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.mqtt.SystemElementMQTTMessageConverter;
import org.eclipse.apogy.addons.powersystems.mqtt.SystemElementMQTTMessageConverterRegistry;
import org.eclipse.apogy.addons.powersystems.mqtt.impl.PowerSystemMQTTBridgeImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.json.JSONArray;
import org.json.JSONObject;

public class PowerSystemMQTTBridgeCustomImpl
extends PowerSystemMQTTBridgeImpl {
    private static String ELEMENTS_ARRAY_KEY = "SystemElementArray";

    @Override
    public JSONObject toJSON() throws Exception {
        JSONObject jsonObject = new JSONObject();
        if (this.getSystemElementProvider() != null && !this.getSystemElementProvider().getProvidedElements().isEmpty()) {
            ArrayList<JSONObject> list = new ArrayList<JSONObject>();
            EList elements = this.getSystemElementProvider().getProvidedElements();
            for (SystemElement element : elements) {
                SystemElementMQTTMessageConverter converter = SystemElementMQTTMessageConverterRegistry.INSTANCE.getConverterForType(element.eClass());
                JSONObject elementJsonObject = new JSONObject();
                converter.convertToJSON(element, elementJsonObject);
                list.add(elementJsonObject);
            }
            JSONArray jsonArray = new JSONArray(list);
            jsonObject.put(ELEMENTS_ARRAY_KEY, (Object)jsonArray);
        }
        return jsonObject;
    }

    @Override
    public void updateSystemElements(JSONObject jsonObject) throws Exception {
        JSONArray array = jsonObject.getJSONArray(ELEMENTS_ARRAY_KEY);
        int i = 0;
        while (i < array.length()) {
            try {
                JSONObject item = (JSONObject)array.get(i);
                EClass eClass = this.extractEClass(item);
                String elementName = this.extractSystemElementName(item);
                SystemElement target = this.getSystemElementByClassAndName(eClass, elementName);
                if (target != null) {
                    SystemElementMQTTMessageConverter converter = SystemElementMQTTMessageConverterRegistry.INSTANCE.getConverterForType(eClass);
                    if (converter != null) {
                        converter.apply(item, target);
                    } else {
                        System.err.println("No converter found !");
                    }
                } else {
                    System.err.println("No local SystemElement found !");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private SystemElement getSystemElementByClassAndName(EClass eClass, String elementName) {
        SystemElement result = null;
        Iterator it = this.getSystemElementProvider().getProvidedElements().iterator();
        while (it.hasNext() && result == null) {
            SystemElement element = (SystemElement)it.next();
            if (!element.eClass().equals(eClass) || element.getName().compareTo(elementName) != 0) continue;
            result = element;
        }
        return result;
    }

    private String extractSystemElementName(JSONObject jsonObject) throws Exception {
        return jsonObject.getString("name");
    }

    private EClass extractEClass(JSONObject jsonObject) throws Exception {
        String className = jsonObject.getString("eclass_name");
        return ApogyCommonEMFFacade.INSTANCE.getEClass(className);
    }
}

