/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.mqtt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.addons.powersystems.mqtt.SystemElementMQTTMessageConverter;
import org.eclipse.apogy.addons.powersystems.mqtt.impl.SystemElementMQTTMessageConverterRegistryImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemElementMQTTMessageConverterRegistryCustomImpl
extends SystemElementMQTTMessageConverterRegistryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SystemElementMQTTMessageConverterRegistryCustomImpl.class);

    @Override
    public Map<EClass, SystemElementMQTTMessageConverter> getConvertersMap() {
        Map<Object, SystemElementMQTTMessageConverter> map = super.getConvertersMap();
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            String s = this.getSYSTEM_ELEMENT_MQTT_MESSAGE_CONVERTER_CONTRIBUTORS_POINT_ID();
            IExtensionPoint nodePresentationExtPoint = Platform.getExtensionRegistry().getExtensionPoint(s);
            IConfigurationElement[] contributors = nodePresentationExtPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                String eClassStr = contributor.getAttribute(this.getSYSTEM_ELEMENT_MQTT_MESSAGE_ECLASS_ID());
                eClassStr = eClassStr.trim();
                String converterString = contributor.getAttribute(this.getSYSTEM_ELEMENT_MQTT_MESSAGE_CONVERTER_CONTRIBUTORS_CONVERTER_ID());
                converterString = converterString.trim();
                try {
                    EClass eClass = ApogyCommonEMFFacade.INSTANCE.getEClass(eClassStr);
                    SystemElementMQTTMessageConverter converter = (SystemElementMQTTMessageConverter)EcoreUtil.create((EClass)ApogyCommonEMFFacade.INSTANCE.getEClass(converterString));
                    if (converter != null) {
                        map.put(eClass, converter);
                    } else {
                        Logger.error("A NULL converter was contributed by <" + contributor.getContributor().getName() + ">.");
                    }
                }
                catch (Exception exception) {
                    Logger.error("Failed to load contributed WizardPagesProvider <" + converterString + "> for type <" + eClassStr + "> from <" + contributor.getClass().getName() + ">");
                }
                ++i;
            }
            Logger.info("Found " + map.size() + " contributed converters.");
        }
        this.setConvertersMap(map);
        return map;
    }

    @Override
    public List<SystemElementMQTTMessageConverter> getAllRegisteredconverters() {
        return new ArrayList<SystemElementMQTTMessageConverter>(this.getConvertersMap().values());
    }

    @Override
    public SystemElementMQTTMessageConverter getConverterForType(EClass eClass) {
        ArrayList<EClass> types = new ArrayList<EClass>();
        for (EClass type : this.getConvertersMap().keySet()) {
            if (type == null || eClass != type && !type.isSuperTypeOf(eClass)) continue;
            types.add(type);
        }
        if (types.isEmpty()) {
            types.add(EcorePackage.Literals.EOBJECT);
        }
        EClass closestMatch = ApogyCommonEMFFacade.INSTANCE.findClosestMatch(eClass, types);
        return this.getConvertersMap().get(closestMatch);
    }
}

