/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.Battery;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.ui.composites.SystemElementListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class BatteryListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends SystemElementListComposite<RootEObject, ResolvedEObject, Battery> {
    protected static DecimalFormat percentFormat = new DecimalFormat("0.00");
    protected static DecimalFormat decimalFormat = new DecimalFormat("0.000");
    protected static final int SOC_MIN_WIDTH = 75;
    protected static final int STATE_MIN_WIDTH = 100;
    protected static final int POWER_FLOW_MIN_WIDTH = 130;
    protected static final int MAX_POWER_INPUT_MIN_WIDTH = 170;
    protected static final int MAX_POWER_OUTPUT_MIN_WIDTH = 180;

    public BatteryListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    @Override
    protected void createButtons(Composite parent, int style) {
    }

    @Override
    protected void createColumns(TreeViewer viewer) {
        super.createColumns(viewer);
        TreeViewerColumn stateColumn = new TreeViewerColumn(viewer, 0);
        stateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        stateColumn.getColumn().setText("State");
        stateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Battery) {
                    Battery battery = (Battery)element;
                    return battery.getChargingState().getLiteral();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.BATTERY__CHARGING_STATE);
            }

            public Color getBackground(Object element) {
                if (element instanceof Battery) {
                    return BatteryListComposite.this.getBackgroundColor((Battery)element);
                }
                return null;
            }
        });
        TreeViewerColumn socColumn = new TreeViewerColumn(viewer, 0);
        socColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)75);
        socColumn.getColumn().setText("SOC (%)");
        socColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Battery) {
                    Battery battery = (Battery)element;
                    return percentFormat.format(battery.getSoc());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__SOC);
            }

            public Color getBackground(Object element) {
                if (element instanceof Battery) {
                    return BatteryListComposite.this.getBackgroundColor((Battery)element);
                }
                return null;
            }
        });
        TreeViewerColumn powerInputColumn = new TreeViewerColumn(viewer, 0);
        powerInputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)130);
        powerInputColumn.getColumn().setText("Power Flow (W)");
        powerInputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Battery) {
                    Battery battery = (Battery)element;
                    return decimalFormat.format(battery.getCurrentPowerFlow());
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof Battery) {
                    return BatteryListComposite.this.getBackgroundColor((Battery)element);
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof Battery) {
                    return ApogyCommonEMFFacade.INSTANCE.getFullDescription((ETypedElement)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__CURRENT_POWER_FLOW);
                }
                return null;
            }
        });
        TreeViewerColumn maxChargePowerColumn = new TreeViewerColumn(viewer, 0);
        maxChargePowerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)170);
        maxChargePowerColumn.getColumn().setText("Max Charge Power (W)");
        maxChargePowerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Battery) {
                    Battery battery = (Battery)element;
                    return decimalFormat.format(battery.getMaximumPowerInput());
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof Battery) {
                    return BatteryListComposite.this.getBackgroundColor((Battery)element);
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof Battery) {
                    return ApogyCommonEMFFacade.INSTANCE.getFullDescription((ETypedElement)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__MAXIMUM_POWER_INPUT);
                }
                return null;
            }
        });
        TreeViewerColumn maxDischargePowerColumn = new TreeViewerColumn(viewer, 0);
        maxDischargePowerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)180);
        maxDischargePowerColumn.getColumn().setText("Max Discharge Power (W)");
        maxDischargePowerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Battery) {
                    Battery battery = (Battery)element;
                    return decimalFormat.format(battery.getMaximumPowerOuput());
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof Battery) {
                    return BatteryListComposite.this.getBackgroundColor((Battery)element);
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof Battery) {
                    return ApogyCommonEMFFacade.INSTANCE.getFullDescription((ETypedElement)ApogyAddonsPowerSystemsPackage.Literals.ENERGY_STORAGE__MAXIMUM_POWER_OUPUT);
                }
                return null;
            }
        });
    }

    @Override
    protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
        ArrayList<SystemElement> result = new ArrayList<SystemElement>();
        for (SystemElement element : inputs) {
            if (!(element instanceof Battery)) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    protected Color getBackgroundColor(Battery battery) {
        Color color = null;
        if (!battery.isPowerStateValid()) {
            color = INVALID_COLOR;
        } else {
            switch (battery.getChargingState().getValue()) {
                case 0: {
                    color = Display.getCurrent().getSystemColor(5);
                    break;
                }
                case 1: {
                    color = Display.getCurrent().getSystemColor(7);
                    break;
                }
                case 3: {
                    color = Display.getCurrent().getSystemColor(13);
                    break;
                }
                case 2: {
                    color = Display.getCurrent().getSystemColor(6);
                    break;
                }
                case 4: {
                    color = Display.getCurrent().getSystemColor(9);
                    break;
                }
            }
        }
        return color;
    }
}

