/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.PowerSwitch;
import org.eclipse.apogy.addons.powersystems.SwitchState;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.ui.composites.SystemElementListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PowerSwitchesListComposite<RootEObject extends EObject, ResolvedEObject extends EObject>
extends SystemElementListComposite<RootEObject, ResolvedEObject, PowerSwitch> {
    private boolean switchControlEnabled = true;
    private Button btnSwitchOn;
    private Button btnSwitchOff;
    protected static DecimalFormat decimalFormat = new DecimalFormat("0.000");
    protected static DecimalFormat percentDecimalFormat = new DecimalFormat("0.0");
    protected static final int STATE_COL_MIN_WIDTH = 50;
    protected static final int POWER_INPUT_MIN_WIDTH = 100;
    protected static final int POWER_OUTPUT_MIN_WIDTH = 100;
    protected static final int EFFICIENCY_MIN_WIDTH = 100;

    public PowerSwitchesListComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, ECollectionCompositeSettings settings) {
        super(parent, style, featurePath, eStructuralFeature, settings);
    }

    public boolean isSwitchControlEnabled() {
        return this.switchControlEnabled;
    }

    public void setSwitchControlEnabled(final boolean switchControlEnabled) {
        this.switchControlEnabled = switchControlEnabled;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PowerSwitchesListComposite.this.btnSwitchOn != null && !PowerSwitchesListComposite.this.btnSwitchOn.isDisposed()) {
                    if (switchControlEnabled) {
                        PowerSwitchesListComposite.this.btnSwitchOn.setEnabled(true);
                    } else {
                        PowerSwitchesListComposite.this.btnSwitchOn.setEnabled(false);
                    }
                }
                if (PowerSwitchesListComposite.this.btnSwitchOff != null && !PowerSwitchesListComposite.this.btnSwitchOff.isDisposed()) {
                    if (switchControlEnabled) {
                        PowerSwitchesListComposite.this.btnSwitchOff.setEnabled(true);
                    } else {
                        PowerSwitchesListComposite.this.btnSwitchOff.setEnabled(false);
                    }
                }
            }
        });
    }

    @Override
    protected void createButtons(Composite parent, int style) {
        this.createSwitchOnButton(parent, style);
        this.createSwitchOffButton(parent, style);
    }

    protected Button createSwitchOnButton(Composite parent, int style) {
        this.btnSwitchOn = PowerSwitchesListComposite.createButton((Composite)parent, (int)0, (String)"Switch ON", e -> {
            List elements = this.getViewer().getStructuredSelection().toList();
            BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                this.doSwitch(elements, SwitchState.ON);
                this.refreshViewer();
            });
        });
        this.btnSwitchOn.setEnabled(this.isSwitchControlEnabled());
        this.createSwitchButtonBindings(this.btnSwitchOn);
        return this.btnSwitchOn;
    }

    protected void doSwitch(List<PowerSwitch> items, SwitchState switchState) {
        for (PowerSwitch powerSwitch : items) {
            try {
                if (switchState == SwitchState.ON) {
                    powerSwitch.switchOn();
                    continue;
                }
                powerSwitch.switchOff();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void createSwitchButtonBindings(Button button) {
        ApogyCommonEMFUIFacade.INSTANCE.createViewerSelectionControlEnabledBinding(this.getDataBindingContext(), (StructuredViewer)this.getViewer(), (Control)button, o -> {
            if (this.isSwitchControlEnabled() && this.getViewer().getStructuredSelection().size() > 0) {
                return true;
            }
            return false;
        });
    }

    protected Button createSwitchOffButton(Composite parent, int style) {
        this.btnSwitchOff = PowerSwitchesListComposite.createButton((Composite)parent, (int)0, (String)"Switch OFF", e -> {
            List elements = this.getViewer().getStructuredSelection().toList();
            BusyIndicator.showWhile((Display)this.getDisplay(), () -> {
                this.doSwitch(elements, SwitchState.OFF);
                this.refreshViewer();
            });
        });
        this.btnSwitchOn.setEnabled(this.isSwitchControlEnabled());
        this.createSwitchButtonBindings(this.btnSwitchOff);
        return this.btnSwitchOff;
    }

    @Override
    protected void createColumns(TreeViewer viewer) {
        super.createColumns(viewer);
        TreeViewerColumn stateColumn = new TreeViewerColumn(viewer, 0);
        stateColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)50);
        stateColumn.getColumn().setText("State");
        stateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerSwitch) {
                    return ((PowerSwitch)element).getSwitchState().getLiteral();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_SWITCH__SWITCH_STATE);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerSwitch) {
                    return PowerSwitchesListComposite.this.getBackgroundColor((PowerSwitch)element);
                }
                return null;
            }
        });
        TreeViewerColumn powerOutputColumn = new TreeViewerColumn(viewer, 0);
        powerOutputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        powerOutputColumn.getColumn().setText("Output (W)");
        powerOutputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerSwitch) {
                    PowerSwitch powerSwitch = (PowerSwitch)element;
                    return decimalFormat.format(powerSwitch.getOutputPower());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.IN_LINE_SYSTEM_ELEMENT__OUTPUT_POWER);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerSwitch) {
                    return PowerSwitchesListComposite.this.getBackgroundColor((PowerSwitch)element);
                }
                return null;
            }
        });
        TreeViewerColumn powerInputColumn = new TreeViewerColumn(viewer, 0);
        powerInputColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        powerInputColumn.getColumn().setText("Input (W)");
        powerInputColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerSwitch) {
                    PowerSwitch powerSwitch = (PowerSwitch)element;
                    return decimalFormat.format(powerSwitch.getInputPower());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.IN_LINE_SYSTEM_ELEMENT__INPUT_POWER);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerSwitch) {
                    return PowerSwitchesListComposite.this.getBackgroundColor((PowerSwitch)element);
                }
                return null;
            }
        });
        TreeViewerColumn efficiencyColumn = new TreeViewerColumn(viewer, 0);
        efficiencyColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        efficiencyColumn.getColumn().setText("Efficiency (%)");
        efficiencyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerSwitch) {
                    PowerSwitch powerSwitch = (PowerSwitch)element;
                    return percentDecimalFormat.format(powerSwitch.getEfficiency());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                return ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)ApogyAddonsPowerSystemsPackage.Literals.POWER_SWITCH__EFFICIENCY);
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerSwitch) {
                    return PowerSwitchesListComposite.this.getBackgroundColor((PowerSwitch)element);
                }
                return null;
            }
        });
        TreeViewerColumn parasiticPowerColumn = new TreeViewerColumn(viewer, 0);
        parasiticPowerColumn.getColumn().setData("TREE_COLUMN_MIN_WIDTH", (Object)100);
        parasiticPowerColumn.getColumn().setText("Parasitic Power (W)");
        parasiticPowerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PowerSwitch) {
                    PowerSwitch powerSwitch = (PowerSwitch)element;
                    return decimalFormat.format(powerSwitch.getRequiredPower());
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof PowerSwitch) {
                    PowerSwitch powerSwitch = (PowerSwitch)element;
                    String tooltipText = "Parasitic Power used by the power switch (On : " + decimalFormat.format(powerSwitch.getParasiticPowerWhenOn()) + " W, ";
                    tooltipText = String.valueOf(tooltipText) + "Off : " + decimalFormat.format(powerSwitch.getParasiticPowerWhenOff()) + " W)";
                    return tooltipText;
                }
                return null;
            }

            public Color getBackground(Object element) {
                if (element instanceof PowerSwitch) {
                    return PowerSwitchesListComposite.this.getBackgroundColor((PowerSwitch)element);
                }
                return null;
            }
        });
    }

    @Override
    protected Collection<SystemElement> filter(Collection<SystemElement> inputs) {
        ArrayList<SystemElement> result = new ArrayList<SystemElement>();
        for (SystemElement element : inputs) {
            if (!(element instanceof PowerSwitch)) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    protected Color getBackgroundColor(PowerSwitch powerSwitch) {
        Color color = null;
        if (!powerSwitch.isPowerStateValid()) {
            color = INVALID_COLOR;
        } else {
            switch (powerSwitch.getSwitchState().getValue()) {
                case 0: {
                    color = Display.getCurrent().getSystemColor(5);
                    break;
                }
                case 1: {
                    color = Display.getCurrent().getSystemColor(15);
                    break;
                }
            }
        }
        return color;
    }
}

