/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BreakerState implements Enumerator
{
    ON(0, "ON", "On"),
    OFF(1, "OFF", "Off"),
    TRIPPED(2, "TRIPPED", "Tripped");

    public static final int ON_VALUE = 0;
    public static final int OFF_VALUE = 1;
    public static final int TRIPPED_VALUE = 2;
    private static final BreakerState[] VALUES_ARRAY;
    public static final List<BreakerState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BreakerState[]{ON, OFF, TRIPPED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BreakerState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BreakerState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BreakerState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BreakerState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BreakerState get(int value) {
        switch (value) {
            case 0: {
                return ON;
            }
            case 1: {
                return OFF;
            }
            case 2: {
                return TRIPPED;
            }
        }
        return null;
    }

    private BreakerState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

