/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Date;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.PowerConsumer;
import org.eclipse.apogy.addons.powersystems.SwitchState;
import org.eclipse.apogy.addons.powersystems.impl.PowerSwitchImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PowerSwitchCustomImpl
extends PowerSwitchImpl {
    @Override
    public boolean isPowerStateValid() {
        boolean result = super.isPowerStateValid();
        if (this.getSwitchState() == SwitchState.OFF) {
            result &= this.getOutputPower() == 0.0;
        }
        return result;
    }

    @Override
    public void switchOn() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_SWITCH__SWITCH_STATE, (Object)SwitchState.ON, true);
    }

    @Override
    public void switchOff() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_SWITCH__SWITCH_STATE, (Object)SwitchState.OFF, true);
        if (this.getOutput() instanceof PowerConsumer) {
            PowerConsumer consumer = (PowerConsumer)((Object)this.getOutput());
            consumer.setPowerConsumed(0.0);
        }
    }

    @Override
    public double getEffectiveEfficiency() {
        if (this.getSwitchState() == SwitchState.ON) {
            return this.getEfficiency();
        }
        return 0.0;
    }

    @Override
    public double getRequiredPower() {
        double power = 0.0;
        switch (this.getSwitchState().getValue()) {
            case 0: {
                power = this.getParasiticPowerWhenOn();
                break;
            }
            case 1: {
                power = this.getParasiticPowerWhenOff();
                break;
            }
        }
        return power;
    }

    @Override
    public void update(Date time) {
    }
}

