/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.Battery;
import org.eclipse.apogy.addons.powersystems.Breaker;
import org.eclipse.apogy.addons.powersystems.DistributionBus;
import org.eclipse.apogy.addons.powersystems.EnergyStorage;
import org.eclipse.apogy.addons.powersystems.PowerBus;
import org.eclipse.apogy.addons.powersystems.PowerConsumer;
import org.eclipse.apogy.addons.powersystems.PowerConverter;
import org.eclipse.apogy.addons.powersystems.PowerProvider;
import org.eclipse.apogy.addons.powersystems.PowerSwitch;
import org.eclipse.apogy.addons.powersystems.PowerSystem;
import org.eclipse.apogy.addons.powersystems.SystemElement;
import org.eclipse.apogy.addons.powersystems.impl.PowerSystemCSVRecorderImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class PowerSystemCSVRecorderCustomImpl
extends PowerSystemCSVRecorderImpl {
    protected DecimalFormat timeFormat = new DecimalFormat("0.000");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.0000");
    protected OutputStreamWriter writer = null;
    protected Adapter timeAdapter = null;
    protected Date startDate = null;
    protected Set<SystemElement> elements = new TreeSet<SystemElement>(new Comparator<SystemElement>(){

        @Override
        public int compare(SystemElement o1, SystemElement o2) {
            if (o1.getName() != null && o2.getName() != null) {
                int nameComparison = o1.getName().compareTo(o2.getName());
                if (nameComparison == 0) {
                    return o1.getClass().getName().compareTo(o2.getClass().getName());
                }
                return nameComparison;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    });

    @Override
    public void setPowerSystem(PowerSystem newPowerSystem) {
        if (this.getPowerSystem() != null) {
            this.getPowerSystem().eAdapters().remove((Object)this.getTimeAdapter());
        }
        if (newPowerSystem != null) {
            newPowerSystem.eAdapters().add((Object)this.getTimeAdapter());
        }
        super.setPowerSystem(newPowerSystem);
    }

    @Override
    public void start(String logFilePath) throws Exception {
        if (!this.isRunning()) {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(logFilePath), "UTF-8");
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_SYSTEM_CSV_RECORDER__RUNNING, (Object)true, true);
            this.elements.clear();
            this.elements.addAll((Collection<SystemElement>)this.getPowerSystem().getElements());
            this.writer.write(String.valueOf(this.createCSVHeader()) + "\n");
        }
    }

    @Override
    public void stop() {
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception exception) {}
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_SYSTEM_CSV_RECORDER__RUNNING, (Object)false, true);
    }

    protected Adapter getTimeAdapter() {
        if (this.timeAdapter == null) {
            this.timeAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    Date time;
                    String line;
                    int featureId;
                    if (PowerSystemCSVRecorderCustomImpl.this.isRunning() && msg.getNotifier() instanceof PowerSystem && (featureId = msg.getFeatureID(PowerSystem.class)) == 0 && (line = PowerSystemCSVRecorderCustomImpl.this.captureData(time = (Date)msg.getNewValue())) != null) {
                        try {
                            PowerSystemCSVRecorderCustomImpl.this.writer.write(String.valueOf(line) + "\n");
                            PowerSystemCSVRecorderCustomImpl.this.writer.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
        return this.timeAdapter;
    }

    protected String createCSVHeader() {
        String header = "Elapsed Time (s),";
        Iterator<SystemElement> it = this.elements.iterator();
        while (it.hasNext()) {
            String h = this.createHeader(it.next());
            if (h != null) {
                header = String.valueOf(header) + h;
            }
            if (!it.hasNext()) continue;
            header = String.valueOf(header) + ",";
        }
        return header;
    }

    protected String captureData(Date date) {
        String line = "";
        double time = 0.0;
        if (this.startDate == null) {
            this.startDate = date;
        }
        time = (double)(date.getTime() - this.startDate.getTime()) * 0.001;
        line = String.valueOf(line) + this.timeFormat.format(time) + ",";
        Iterator<SystemElement> it = this.elements.iterator();
        while (it.hasNext()) {
            line = String.valueOf(line) + this.captureData(it.next());
            if (!it.hasNext()) continue;
            line = String.valueOf(line) + ",";
        }
        return line;
    }

    protected String createHeader(SystemElement systemElement) {
        String s = null;
        if (systemElement instanceof PowerBus) {
            s = String.valueOf(systemElement.getName()) + " State,";
            s = String.valueOf(s) + systemElement.getName() + " Balance (W),";
            s = String.valueOf(s) + systemElement.getName() + " Overload (W)";
        } else if (systemElement instanceof DistributionBus) {
            s = String.valueOf(systemElement.getName()) + " Consumed (W)";
        } else if (systemElement instanceof Battery) {
            s = String.valueOf(systemElement.getName()) + " SOC (%),";
            s = String.valueOf(s) + systemElement.getName() + " State,";
            s = String.valueOf(s) + systemElement.getName() + " Flow (W)";
        } else if (systemElement instanceof EnergyStorage) {
            s = String.valueOf(s) + systemElement.getName() + " SOC (%),";
            s = String.valueOf(s) + systemElement.getName() + " Flow (W),";
        } else if (systemElement instanceof PowerSwitch) {
            s = String.valueOf(systemElement.getName()) + " State,";
            s = String.valueOf(s) + systemElement.getName() + " Input (W),";
            s = String.valueOf(s) + systemElement.getName() + " Output (W)";
        } else if (systemElement instanceof PowerConverter) {
            s = String.valueOf(systemElement.getName()) + " State,";
            s = String.valueOf(s) + systemElement.getName() + " Input (W),";
            s = String.valueOf(s) + systemElement.getName() + " Output(W)";
        } else if (systemElement instanceof Breaker) {
            s = String.valueOf(systemElement.getName()) + " State,";
            s = String.valueOf(s) + systemElement.getName() + " Output (W)";
        } else if (systemElement instanceof PowerProvider) {
            s = String.valueOf(systemElement.getName()) + " Production (W)";
        } else if (systemElement instanceof PowerConsumer) {
            s = String.valueOf(systemElement.getName()) + " Consumption (W)";
        }
        return s;
    }

    protected String captureData(SystemElement systemElement) {
        String s = null;
        if (systemElement instanceof PowerBus) {
            PowerBus powerBus = (PowerBus)systemElement;
            s = String.valueOf(powerBus.getPowerBusState().getLiteral()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(powerBus.getPowerBalance()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(powerBus.getBusPowerOverload());
        } else if (systemElement instanceof DistributionBus) {
            DistributionBus distributionBus = (DistributionBus)systemElement;
            s = this.decimalFormat.format(distributionBus.getInputPower());
        }
        if (systemElement instanceof Battery) {
            Battery battery = (Battery)systemElement;
            s = String.valueOf(this.decimalFormat.format(battery.getSoc())) + ",";
            s = String.valueOf(s) + battery.getChargingState().getLiteral() + ",";
            s = Double.isNaN(battery.getCurrentPowerFlow()) ? String.valueOf(s) + "NaN" : String.valueOf(s) + this.decimalFormat.format(battery.getCurrentPowerFlow());
        } else if (systemElement instanceof EnergyStorage) {
            EnergyStorage energyStorage = (EnergyStorage)systemElement;
            s = String.valueOf(s) + this.decimalFormat.format(energyStorage.getSoc()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(energyStorage.getCurrentPowerFlow());
        } else if (systemElement instanceof PowerSwitch) {
            PowerSwitch powerSwitch = (PowerSwitch)systemElement;
            s = String.valueOf(powerSwitch.getSwitchState().getLiteral()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(powerSwitch.getInputPower()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(powerSwitch.getOutputPower());
        } else if (systemElement instanceof PowerConverter) {
            PowerConverter powerConverter = (PowerConverter)systemElement;
            s = String.valueOf(powerConverter.getConverterState().getLiteral()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(powerConverter.getInputPower()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(powerConverter.getOutputPower());
        } else if (systemElement instanceof Breaker) {
            Breaker breaker = (Breaker)systemElement;
            s = String.valueOf(breaker.getBreakerState().getLiteral()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(breaker.getInputPower()) + ",";
            s = String.valueOf(s) + this.decimalFormat.format(breaker.getOutputPower());
        } else if (systemElement instanceof PowerProvider) {
            PowerProvider powerProvider = (PowerProvider)systemElement;
            s = this.decimalFormat.format(powerProvider.getPowerProvided());
        } else if (systemElement instanceof PowerConsumer) {
            PowerConsumer powerConsumer = (PowerConsumer)systemElement;
            s = this.decimalFormat.format(powerConsumer.getPowerConsumed());
        }
        return s;
    }
}

